<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL08"
	title	= "メールホスト振分マスタ"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID"
	columns = "SYSTEM_ID,HOST,JOKEN"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select SYSTEM_ID,JOKEN,HOST,PORT,AUTH,AUTHUSER,AUTHPASS,COMMENTS,FGJ
		from GE37
	<og:where>
		<og:and value = "FGJ		=	'{@FGJ}'"		/>
		<og:and value = "SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "JOKEN	like '{@JOKEN}'"	/>
		<og:and value = "HOST like '{@HOST}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,JOKEN" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,JOKEN,HOST" must="true" />

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<og:writeCheck>
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,JOKEN"  />
	<og:submit  action="DELETE"  columnWritable="null" keys="logicalDelete" vals="true" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = ""
	selectedType = "checkbox"/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
