/********************************************************************************************/
/* javaDBに対して、関数を拡張します。														*/
/*																							*/
/* 【概要】 																				*/
/*	 javaDB に、特殊系の関数を登録します。													*/
/*	 これは、JavaDBが、数値⇔文字列の自動変換が出来ないための対応が、主です。				*/
/*																							*/
/* 【方法】 																				*/
/*	 １．Java関数のソースは、org.opengion.fukurou.db.Functions に定義します。				*/
/*	 ２．apps/endorsed7.0 フォルダに、おｇJavaFunction.jar ファイルをコピーします。 		*/
/*	 ３．JavaDB から、上記クラスが見えるようにします。										*/
/*		 具体的には、apps\jdk9u01\db\bin\startNetworkServer.bat (JavaDB 起動スクリプト)に	*/
/*		 set CLASSPATH=%OG_CLASSPATH%; を追記します。										*/
/*		 OG_CLASSPATH は、Tomcat起動用に、uap\bin\const.bat に定義済みです。				*/
/*		 これで、apps/endorsed7.0 フォルダが見える環境になります。							*/
/*	 ４．JavaDBに対して、FUNCTION を定義します。											*/
/********************************************************************************************/

/********************************************************************************************/
/* 数値を文字列に変換します。																*/
/* ただし、元の数字に端数がない場合は、".0" 部分をカットします。							*/
/********************************************************************************************/
DROP FUNCTION TO_CHAR;

CREATE FUNCTION TO_CHAR ( VAL DOUBLE )
RETURNS VARCHAR(20)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.toChar' ;

/********************************************************************************************/
/* 文字列を数値に変換します。																*/
/* ORACLEとなんとなく互換を持たせるため、TO_NUMBER 関数を作成します。						*/
/********************************************************************************************/
DROP FUNCTION TO_NUMBER;

CREATE FUNCTION TO_NUMBER ( VAL VARCHAR(20) )
RETURNS DOUBLE
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'java.lang.Double.parseDouble' ;


/********************************************************************************************/
/* 文字列を置換します。																		*/
/* 第１引数の文字列から、第２引数の部分文字列を、第２引数の文字列を置き換えます。			*/
/********************************************************************************************/
DROP FUNCTION REPLACE;

CREATE FUNCTION REPLACE ( VARCHAR(2000) , VARCHAR(2000) , VARCHAR(2000) )
RETURNS VARCHAR(4000)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.replace' ;


/********************************************************************************************/
/* 文字列を連結します。																		*/
/* 第１引数の数字と、第２、第３、第４の文字列をスペースで連結した文字列を返します。			*/
/********************************************************************************************/
DROP FUNCTION JOIN2;

CREATE FUNCTION JOIN2 ( INTEGER , VARCHAR(2000) , VARCHAR(2000) , VARCHAR(2000) )
RETURNS VARCHAR(4000)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.db.Functions.join2' ;


/********************************************************************************************/
/* 指定の日付文字列を指定の形式の文字列に変換します。										*/
/* 第１引数の日付文字列と、第２引数の yyyyMMddHHmmss 形式フォーマットで変換します。			*/
/********************************************************************************************/
DROP FUNCTION TO_YMD;

CREATE FUNCTION TO_YMD ( VARCHAR(100) , VARCHAR(100) )
RETURNS VARCHAR(100)
DETERMINISTIC			-- 引数が同じなら常に同じ値を返すことを示す.(省略時はnot deterministic)
PARAMETER STYLE JAVA	-- 戻り値のタイプ
NO SQL LANGUAGE JAVA	-- 関数の中でSQLは実行しないことを示す
EXTERNAL NAME 'org.opengion.fukurou.util.HybsDateUtil.toYmd' ;
