<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7212"
	title	= "ｸﾞﾗﾌ合成、ﾊﾟﾚｰﾄ図"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:equals val1="{@Pareto}" val2="false">
	<og:chartCreate
		title			= "{@LBL.KNORDER}"
		width			= "1200"
		height			= "500"
		plotOrientation	= "{@plotOrientation}"
	>
		<og:chartDataset
			chartType		= "{@chartType}"
			barItemMargin	= "0"
			itemLabelVisible= "true"
		>
				SELECT 	 ENAME							<!-- 営業担当者 -->
						,SAL
						,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as SALES	-- 乱数倍
						,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as AMOUNT	-- 乱数倍
				FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
		</og:chartDataset>
		<og:chartDataset
			chartType		= "HybsLine"
		>
				SELECT 	 ENAME							<!-- 営業担当者 -->
						,SAL
						,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as SALES	-- 乱数倍
						,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as AMOUNT	-- 乱数倍
				FROM EMP
			<og:where>
				<og:and value=" DEPTNO = {@SOOUID}" />
			</og:where>
		</og:chartDataset>
	</og:chartCreate>
</og:equals>

<og:equals val1="{@Pareto}" val2="true">
	<!-- パレート図は、同じデータを HybsBar と HybsParetoLine で使うので、useTableData = "true" のサンプルを提示 -->
	<og:query command="{@command}">
			SELECT 	 ENAME
					,ROUND(SAL * 2 * DBMS_RANDOM.VALUE) as SAL
			FROM EMP
		<og:where>
			<og:and value=" DEPTNO = {@SOOUID}" />
		</og:where>
			ORDER BY 2 DESC
	</og:query>

	<og:chartCreate
		title			= "{@LBL.KNORDER}"
		width			= "1200"
		height			= "500"
		plotOrientation	= "{@plotOrientation}"
	>
		<og:chartDataset
			chartType		= "{@chartType}"
			itemLabelVisible= "true"
			useTableData	= "true"
		/>
		<!-- upperBound を 109 にすることで、tickSize 未満になるので、表示されない -->
		<og:chartDataset
			chartType		= "HybsParetoLine"
			itemLabelVisible= "true"
			useTableData	= "true"
			valueLabelsVisible = "true"
			tickSize		= "10"
			lowerBound		= "0"
			upperBound		= "109"
			baseLegend		= "false"
		/>
	</og:chartCreate>
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
