<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />

	<xsl:template match="/javadoc">
		<ROWSET tableName="GEA08">
			<EXEC_SQL>delete from GEA08 where SYSTEM_ID='GF' and KBSAKU='0' and KBLBL='A'</EXEC_SQL>
			<xsl:apply-templates select="classDoc/method" />
			<EXEC_SQL>
				<xsl:text>delete from GEA08 A where A.SYSTEM_ID='GF' and A.KBSAKU='0' and A.KBLBL='A' </xsl:text>
				<xsl:text>and exists ( select 'A' from GEA08 B where  B.SYSTEM_ID in ( 'GF' , '**' ) </xsl:text>
							<xsl:text>and A.CLM = B.CLM and A.LANG = B.LANG and A.LNAME != B.LNAME </xsl:text>
							<xsl:text>and B.KBLBL != 'A' and B.FGJ = '1' )</xsl:text>
			</EXEC_SQL>
			<EXEC_SQL>update GEA08 set LNAME=STRING_TO_HALF(LNAME) WHERE SYSTEM_ID='GF' and KBLBL='A' and LANG='ja' and LNAME != STRING_TO_HALF(LNAME)</EXEC_SQL>
			<EXEC_SQL>update GEA08 set SNAME=STRING_TO_HALF(SNAME) WHERE SYSTEM_ID='GF' and KBLBL='A' and LANG='ja' and SNAME != STRING_TO_HALF(SNAME)</EXEC_SQL>
			<EXEC_SQL>update GEA08 set NAME_JA=STRING_TO_HALF(NAME_JA) WHERE SYSTEM_ID='GF' and KBLBL='A' and NAME_JA != STRING_TO_HALF(NAME_JA)</EXEC_SQL>
			<EXEC_SQL>update GEA08 set DESCRIPTION=STRING_TO_HALF(DESCRIPTION) WHERE SYSTEM_ID='GF' and KBLBL='A' and LANG='ja' and DESCRIPTION != STRING_TO_HALF(DESCRIPTION)</EXEC_SQL>
		</ROWSET>
	</xsl:template>

	<xsl:template match="classDoc/method">
		<xsl:if test="name[not(.=preceding::name)]">
			<xsl:element name="ROW">
				<xsl:attribute name="num">
					<xsl:number level="any" format="1" count="method" />
				</xsl:attribute>
				<SYSTEM_ID	>GF</SYSTEM_ID>
				<CLM		><xsl:value-of select="name"	/></CLM>
				<NAME_JA	><xsl:value-of select="label"	/></NAME_JA>
				<LNAME		><xsl:value-of select="name"	/></LNAME>
	<!--		<LNAME		><xsl:value-of select="label"	/></LNAME>		-->
	<!--		<LNAME		>
					<xsl:choose>
						<xsl:when test="string-length( label ) &lt;= 10">
							<xsl:value-of select="label" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="name" />
						</xsl:otherwise>
					</xsl:choose>
				</LNAME>
	-->
	<!--		<DESCRIPTION><xsl:value-of select="label" /> <xsl:value-of select="comment" />\n<xsl:value-of select="description" /></DESCRIPTION>	-->
				<DESCRIPTION><xsl:value-of select="description" /></DESCRIPTION>
				<KBSAKU		>0</KBSAKU>
				<LANG		>ja</LANG>
				<KBLBL		>A</KBLBL>
				<FGJ		>1</FGJ>
			</xsl:element>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
