<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck command="{@command}" />
<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DBConfig.xmlの情報を読み取ります -->
<og:equals val1="{@command}" val2="RENEW" notEquals="true">
	<og:dbConfigEditor command="GET" type="{@TYPE}" xmlFile="{@DBCXML}" />
	<og:equals val1="{@TYPE}" val2="DBID">
		<og:columnEditor column="dbidKey" must="true" />
		<og:columnEditor column="readonly" must="true" editor="MENU" codeName="BOOLEAN" />
		<og:columnEditor column="mincount" must="true" />
		<og:columnEditor column="maxcount" must="true" />
		<og:columnEditor column="pooltime" must="true" />
		<og:columnEditor column="applicationInfo" must="true" editor="MENU" codeName="BOOLEAN" />
	</og:equals>
	<og:equals val1="{@TYPE}" val2="CLASS">
		<og:columnEditor column="class" must="true" />
	</og:equals>
</og:equals>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="update"   command="COPY"   lbl="COPY"    accesskey="C"
			keys="noWritable" vals="null" />
	<og:submit  value="update"   command="MODIFY" lbl="MODIFY"  accesskey="M" 
			keys="noWritable" vals="null" />
	<og:submit  value="entry"   command="REALDELETE" lbl="DELETE"  accesskey="Z"
			onClick="return confirm('{@LBL.GEM0040}');" />
	<og:submit  value="save"     command="SAVE"   lbl="SAVE"    accesskey="S"
			style="background-color:red;" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
