<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2090"
	title	= "整合性ﾁｪｯｸ(種別間)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" />

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<!-- トランザクション 登録処理 -->
<og:transaction>

	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}" commitTableModel="false">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "{@sqlType}"
			table		= "{@MEM.TABLE_NAME}"
			where		= "UNIQ=[UNIQ]"
		/>
	</og:tableUpdate>

	<!-- テーブル削除時は、テーブルカラム、インデックスも削除します。 -->
 	<og:equals val1="{@MEM.TABLE_NAME} {@sqlType}" val2="GF02 DELETE" >
		<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}" commitTableModel="false">
			<og:tableUpdateParam
				constObjKey = "GF"
				sqlType		= "{@sqlType}"
				table		= "GF05"
				where		= "SYSTEM_ID=[SYSTEM_ID] AND TBLSYU=[TBLSYU] AND upper(TABLE_NAME)=upper([TABLE_NAME])"
			/>
		</og:tableUpdate>

		<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}" commitTableModel="false">
			<og:tableUpdateParam
				constObjKey = "GF"
				sqlType		= "{@sqlType}"
				table		= "GF06"
				where		= "SYSTEM_ID=[SYSTEM_ID] AND TBLSYU=[TBLSYU] AND upper(TABLE_NAME)=upper([TABLE_NAME])"
			/>
		</og:tableUpdate>

		<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}" commitTableModel="false">
			<og:tableUpdateParam
				constObjKey = "GF"
				sqlType		= "{@sqlType}"
				table		= "GF07"
				where		= "SYSTEM_ID=[SYSTEM_ID] AND TBLSYU=[TBLSYU] AND upper(TABLE_NAME)=upper([TABLE_NAME])"
			/>
		</og:tableUpdate>
	</og:equals>
</og:transaction >

<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
