/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * TableFilter_INDEX_POSTGRES は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、PostgreSQL用のインデックス作成スクリプトを作成します。
 *
 * ここでは、テーブル一覧の検索結果より、GF07 のインデックスカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"I.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,TABLE_LABEL,INDEX_NAME,NAME_JA,INDTYPE,TABLESPACE_NAME,INITIAL_EXTENT)
 * の項目を取得する必要があります。
 *
 * @og.rev 4.0.0.0 (2005/08/31) 新規作成
 * @og.rev 6.5.0.0 (2016/09/30) クラス名変更(TableFilter_INDEX_POSGRE → TableFilter_INDEX_POSTGRES)
 *
 * @version  6.5.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8,
 */
public class TableFilter_INDEX_POSTGRES extends TableFilter_INDEX {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.5.0.0 (2016/09/30)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 * @og.rev 6.5.0.0 (2016/09/30) クラス名変更(TableFilter_INDEX_POSGRE → TableFilter_INDEX_POSTGRES)
	 */
	public TableFilter_INDEX_POSTGRES() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	/**
	 * ヘッダー部分の処理を実行します。
	 *
	 * @og.rev 5.10.25.0 (2020/10/02) 先頭にencodingを付加するために作成
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	ヘッダー部分の文字列
	 */
	@Override
	protected String makeHeadLine( final int[] clmNo,final String[] data ) {
		String str = isXml ? "" : "\\encoding UTF8;" + CR;
		str += super.makeHeadLine( clmNo,data );
		return str;
	}

	/**
	 * インデックス作成の処理を実行します。
	 *
	 * @og.rev 5.10.25.0 (2020/10/02) 小文字化するために追加
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 * @param   clms	カラム名(CSV形式)
	 *
	 * @return	作成された１行分の文字列
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data,final String clms ) {
		return super.makeLineList( clmNo, data, clms ).toLowerCase();
	}

	/**
	 * 定義の最後の部分の処理を実行します。
	 *
	 * @og.rev 6.0.2.3 (2014/10/10) EXEC_END_TAG を追加。キャッシュします。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	定義の最後の部分
	 */
	@Override
	protected String makeEndLine( final int[] clmNo,final String[] data ) {
		return execEndTag ;
	}
}
