/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

/**
 * ファイルの一覧情報から、プルダウンメニューを作成して
 * 編集する場合に使用するエディタークラスです。
 *
 * HTMLのメニューやリストを作成するためのオプションタグを作成したり、
 * 与えられたキーをもとに、チェック済みのオプションタグを作成したりします。
 * ラベル にスペースを含ませる場合は、ダブルクォーテーションで囲ってください。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 7.2.4.0 (2020/05/11) 新規追加
 * @og.group データ編集
 *
 * @version  7.1
 * @author   Kazuhiko Hasegawa
 * @since    JDK11.0,
 */
public class Editor_FILES extends Editor_MENU {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "7.2.4.0 (2020/05/11)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 7.2.4.0 (2020/05/11) 新規追加
	 */
	public Editor_FILES() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 7.2.4.0 (2020/05/11) 新規追加
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	@Override
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_MENU( clm,"FILES" );
	}
}
