/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.opengion.fukurou.model.CloudFileOperation;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFactory;

public class FileOperationInfo
extends CloudFileOperation {
    private static final String VERSION = "7.2.9.4 (2020/11/20)";
    private static final long serialVersionUID = 729420201120L;
    private final String plugin;
    private long size;
    private long lastModified;
    private boolean isFile;
    private boolean isDirectory;
    private FileOperation file;

    public FileOperationInfo(String string, String string2, String string3) {
        super(string2, string3);
        this.plugin = string;
        this.size = 0L;
        this.lastModified = 0L;
        this.isFile = false;
        this.isDirectory = false;
        this.file = null;
    }

    private void setFileOperation() {
        if (this.file == null) {
            this.file = FileOperationFactory.newStorageOperation(this.plugin, this.conBucket, this.conPath);
        }
    }

    @Override
    public void write(InputStream inputStream) throws IOException {
        this.setFileOperation();
        this.file.write(inputStream);
    }

    @Override
    public InputStream read() throws FileNotFoundException {
        this.setFileOperation();
        return this.file.read();
    }

    @Override
    public boolean delete() {
        this.setFileOperation();
        return this.file.delete();
    }

    @Override
    public boolean copy(String string) {
        this.setFileOperation();
        return this.file.copy(string);
    }

    @Override
    public File[] listFiles(FileFilter fileFilter) {
        this.setFileOperation();
        return this.file.listFiles(fileFilter);
    }

    @Override
    public long length() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    public void setLastModifiedValue(long l) {
        this.lastModified = l;
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean bl) {
        this.isFile = bl;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean bl) {
        this.isDirectory = bl;
    }

    @Override
    public File getParentFile() {
        return FileOperationFactory.newStorageOperation(this.file, this.getParent());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof File && super.equals(object);
    }
}

