/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

abstract class HTMLTagSupport
extends CommonTagSupport {
    private static final String VERSION = "6.9.5.0 (2018/04/23)";
    private static final long serialVersionUID = 695020180423L;
    private static final boolean USE_MUST_REQUIRED = HybsSystem.sysBool("USE_MUST_REQUIRED");
    private static final String[] AIMAI_TEXT = new String[]{" V ", " V*", "*V ", "*V*"};
    private static final String[] AIMAI_TITL = new String[]{"\u5b8c\u5168\u4e00\u81f4", "\u524d\u65b9\u4e00\u81f4", "\u5f8c\u65b9\u4e00\u81f4", "\u524d\u5f8c\u66d6\u6627"};
    private String mustType;
    private boolean useMustHidden = true;
    private int aimai = -1;

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag() && this.getUser().isAccess(this.get("roles"))) {
            if ("must".equals(this.mustType) && this.useMustHidden && USE_MUST_REQUIRED) {
                this.set("required", "required");
            }
            this.jspPrint(this.makeTag());
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.mustType = null;
        this.useMustHidden = true;
        this.aimai = -1;
    }

    protected abstract String makeTag();

    public void setId(String string) {
        this.set("id", this.getRequestParameter(string));
    }

    public void setClazz(String string) {
        this.add("class", this.getRequestParameter(string));
    }

    public void setLang(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.set("lang", string2);
            this.set("xml:lang", string2);
        }
    }

    public void setDir(String string) {
        this.set("dir", this.getRequestParameter(string));
    }

    public void setTitle(String string) {
        if (string != null) {
            String string2 = this.getResource().getDescription(string, new String[0]);
            if ((string2 == null || string2.isEmpty() || string2.equals(string)) && ((string2 = this.getResource().getLabel(string, new String[0])) == null || string2.isEmpty() || string2.equals(string))) {
                string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
            }
            if (string2 != null) {
                string2 = string2.replaceAll("\\\\n", "&#13;&#10;");
                this.set("title", string2);
            }
        }
    }

    public void setStyle(String string) {
        this.set("style", this.getRequestParameter(string));
    }

    public void setReadonly(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            if ("readonly".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2)) {
                this.set("readonly", "readonly");
            } else if (!"false".equalsIgnoreCase(string2)) {
                String string3 = "readonly \u306b\u306f\u3001[readonly,true,false]\u4ee5\u5916\u306e\u6587\u5b57\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 readonly=[" + string2 + "]" + CR;
                throw new HybsSystemException(string3);
            }
        }
    }

    public void setDisabled(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            if ("disabled".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2)) {
                this.set("disabled", "disabled");
            } else if (!"false".equalsIgnoreCase(string2)) {
                String string3 = "disabled \u306b\u306f\u3001[disabled/true/false]\u4ee5\u5916\u306e\u6587\u5b57\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 disabled=[" + string2 + "]" + CR;
                throw new HybsSystemException(string3);
            }
        }
    }

    public void setTabindex(String string) {
        this.set("tabindex", this.getRequestParameter(string));
    }

    public void setAccesskey(String string) {
        this.set("accesskey", this.getRequestParameter(string));
    }

    public void setOptionAttributes(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.set("optionAttributes", string2);
        }
    }

    public void setOnClick(String string) {
        this.add("onClick", this.getRequestParameter(string), ";");
    }

    public void setOnChange(String string) {
        this.add("onChange", this.getRequestParameter(string), ";");
    }

    public void setOnBlur(String string) {
        this.add("onBlur", this.getRequestParameter(string), ";");
    }

    public void setOnFocus(String string) {
        this.add("onFocus", this.getRequestParameter(string), ";");
    }

    public void setOnSelect(String string) {
        this.add("onSelect", this.getRequestParameter(string), ";");
    }

    public void setOndblClick(String string) {
        this.add("ondblClick", this.getRequestParameter(string), ";");
    }

    public void setOnMouseDown(String string) {
        this.add("onMouseDown", this.getRequestParameter(string), ";");
    }

    public void setOnMouseUp(String string) {
        this.add("onMouseUp", this.getRequestParameter(string), ";");
    }

    public void setOnMouseMove(String string) {
        this.add("onMouseMove", this.getRequestParameter(string), ";");
    }

    public void setOnMouseOut(String string) {
        this.add("onMouseOut", this.getRequestParameter(string), ";");
    }

    public void setOnMouseOver(String string) {
        this.add("onMouseOver", this.getRequestParameter(string), ";");
    }

    public void setOnKeydown(String string) {
        this.add("onKeydown", this.getRequestParameter(string), ";");
    }

    public void setOnKeypress(String string) {
        this.add("onKeypress", this.getRequestParameter(string), ";");
    }

    public void setOnKeyup(String string) {
        this.add("onKeyup", this.getRequestParameter(string), ";");
    }

    public void setAutocomplete(String string) {
        this.set("autocomplete", this.getRequestParameter(string));
    }

    public void setAutofocus(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            if ("autofocus".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2)) {
                this.set("autofocus", "autofocus");
            } else if (!"false".equalsIgnoreCase(string2)) {
                String string3 = "autofocus \u306b\u306f\u3001[autofocus,true,false]\u4ee5\u5916\u306e\u6587\u5b57\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 autofocus=[" + string2 + "]" + CR;
                throw new HybsSystemException(string3);
            }
        }
    }

    public void setPattern(String string) {
        this.set("pattern", this.getRequestParameter(string));
    }

    public void setPlaceholder(String string) {
        if (string != null) {
            String string2 = this.getResource().getLabel(string, new String[0]);
            if (string2 == null || string2.isEmpty() || string2.equals(string)) {
                string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
            }
            if (string2 != null) {
                string2 = string2.replaceAll("\\\\n", "&#13;&#10;");
                this.set("placeholder", string2);
            }
            if (this.get("title") == null) {
                this.setTitle(string);
            }
        }
    }

    public void setList(String string) {
        this.set("list", this.getRequestParameter(string));
    }

    public void setMin(String string) {
        this.set("min", this.getRequestParameter(string));
    }

    public void setMax(String string) {
        this.set("max", this.getRequestParameter(string));
    }

    public void setStep(String string) {
        this.set("step", this.getRequestParameter(string));
    }

    public void setRequired(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            if ("required".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string2)) {
                this.set("required", "required");
            } else if (!"false".equalsIgnoreCase(string2)) {
                String string3 = "required \u306b\u306f\u3001[required/true/false]\u4ee5\u5916\u306e\u6587\u5b57\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002 required=[" + string2 + "]" + CR;
                throw new HybsSystemException(string3);
            }
        }
    }

    public void setRoles(String string) {
        this.set("roles", this.getRequestParameter(string));
    }

    public void setMust(String string) {
        this.mustType = StringUtil.nval((String)this.getRequestParameter(string), null);
        if ("true".equalsIgnoreCase(this.mustType)) {
            this.mustType = "must";
            this.add("class", "must");
        } else if ("false".equalsIgnoreCase(this.mustType)) {
            this.mustType = "false";
        }
    }

    public void setMustAny(String string) {
        if (this.mustType == null) {
            this.mustType = StringUtil.nval((String)this.getRequestParameter(string), null);
            if ("true".equalsIgnoreCase(this.mustType)) {
                this.mustType = "mustAny";
            }
            this.add("class", this.mustType);
        }
    }

    public void setUseMustHidden(String string) {
        this.useMustHidden = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMustHidden);
    }

    public void setAimai(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null && !string2.isEmpty()) {
            this.add("class", "aimai");
            if (string2.length() == 1 && "0,1,2,3".indexOf(string2) >= 0) {
                this.aimai = Integer.parseInt(string2);
            } else if ("true".equalsIgnoreCase(string2)) {
                this.aimai = -1;
            } else {
                this.aimai = 0;
                if (string2.endsWith("*")) {
                    this.aimai = 1;
                }
                if (StringUtil.startsChar((CharSequence)string2, (char)'*')) {
                    this.aimai += 2;
                }
            }
        }
    }

    protected String getMustType() {
        return this.mustType;
    }

    protected String makeMustHidden(String string) {
        return this.mustType != null && !"false".equalsIgnoreCase(this.mustType) && this.useMustHidden ? XHTMLTag.hidden((String)("h_must_" + this.mustType), (String)string, null) : "";
    }

    protected String makeAimaiPicker(String string) {
        if (this.aimai >= 0) {
            String string2 = this.get("id");
            String string3 = "AIMAI_" + (string2 == null || string2.isEmpty() ? string : string2);
            return new TagBuffer("pre").add("id", string3).add("class", "aimaiClm").add("aimaiType", String.valueOf(this.aimai)).add("title", AIMAI_TITL[this.aimai]).addBody(new String[]{AIMAI_TEXT[this.aimai]}).makeTag();
        }
        return "";
    }
}

