<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0004"
	title    = "コード"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}">
	<og:columnSet command="{@command}" columnId="CLM_T"		action="TBLSET" value="[CLM]" />
	<og:columnSet command="{@command}" columnId="CODE_T"	action="TBLSET" value="[CLM].[CODE]" />
	<og:columnSet command="{@command}" columnId="NAME_JA"	action="TBLSET" value="[LNAME]" />
</og:entry>

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<og:dataCheck
	dbid		= "{@MEM.TO_DBID}"
	command 	= "{@command}"
	sqlType		= "{@sqlType}"
	from		= "GEA04"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND CODE=[CODE] AND KBSAKU=[KBSAKU]"
	uniqCheckClms	= "SYSTEM_ID,CLM,CODE,KBSAKU"
/>

<og:transaction>
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		resourceType	= "GEA04"
		queryType		= "JDBCTableUpdate"
		commitTableModel= "false">
		<og:tableUpdateParam
			sqlType		= "{@sqlType}"
			table		= "GEA04"
			names		= "SYSTEM_ID,CLM_T,CODE,SEQNO,CODELVL,CODEGRP,CODE_PARAM,KBSAKU,RELEASE_NOTES,RDC_CODE,COMMENTS,CDKH"
			where		= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CLM] AND CODE=[CODE] AND KBSAKU=[KBSAKU]"
			asNames		= "CLM_T"
			orgNames	= "CLM"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>

	<!-- ﾗﾍﾞﾙは、削除以外はキーでマージします。 -->
	<og:equals val1="COPY|MODIFY|INSERT|MERGE" val2="{@sqlType}" contains="true">
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "MERGE"
				table		= "GEA08"
				names		= "SYSTEM_ID,CODE_T,LANG,NAME_JA,LNAME,SNAME,DESCRIPTION,COMMENTS,KBSAKU,RELEASE_NOTES,CDKH,RDC_CODE"
				where		= "SYSTEM_ID=[SYSTEM_ID] and CLM=[CODE_T] and LANG=[LANG] and KBSAKU=[KBSAKU]"
				constKeys	= "KBLBL,FGLOAD"
				constVals	= "6,0"
				asNames		= "CODE_T"
				orgNames	= "CLM"
			/>
		</og:tableUpdate>
	</og:equals>

	<og:equals val1="DELETE" val2="{@sqlType}">
		<!-- 削除は、すべての LANG に対して実施する -->
		<og:tableUpdate
			dbid			= "{@MEM.TO_DBID}"
			command			= "{@command}"
			queryType		= "JDBCTableUpdate"
			commitTableModel= "false">
			<og:tableUpdateParam
				sqlType		= "{@sqlType}"
				table		= "GEA08"
				where		= "SYSTEM_ID=[SYSTEM_ID] AND CLM=[CODE_T] AND KBSAKU=[KBSAKU]"
				names		= "CDKH"
				logicalDelete	= "{@logicalDelete}"
			/>
		</og:tableUpdate>
	</og:equals>
</og:transaction>

<!--他システムIDのリソース更新ここから-->
<og:value command="SETTBL" key="CLM" action="APPEND"/><!-- remoteResource.jsp -->
<og:value command="SET" key="remocommand" value="CODE"/>
<jsp:directive.include file="/jsp/common/remoteResource.jsp" />
<og:value command="REMOVE" key="CLM" />
<!--他システムリソース更新ここまで-->

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
