/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* DATA_DEFAULT ( FUNCTION )                                                */
/* Created : 2020/11/13 12:48:34                                            */
/****************************************************************************/

CREATE 
FUNCTION DATA_DEFAULT(
	VAL IN VARCHAR2  )
RETURN VARCHAR2
/**********************************************************************/
/*	デフォルトデータの登録時に、コメント部分を削除します。            */
/*  DATA_DEFAULT( VAL )                                               */
/*                                                                    */
/*	 VAL      IN VARCHAR2      デフォルトデータ                       */
/*	                                                                  */
/*	コメント開始記号（／＊）以降の文字列は削除します。(簡易化の為     */
/*	その後、後ろスペースを削除した文字列を返します。                  */
/**********************************************************************/
IS
    RETVAL     VARCHAR2(30);
	IDX        NUMBER ;
BEGIN
	RETVAL := NULL ;
	IF VAL IS NOT NULL THEN
		IDX := INSTRB(VAL,'/*');
		IF IDX > 0 THEN
			RETVAL := LTRIM(RTRIM(SUBSTRB(REPLACE( VAL,'''',' ' ),1,IDX-1)));
		ELSE
			RETVAL := LTRIM(RTRIM(SUBSTRB(REPLACE( VAL,'''',' ' ),1,30)));
		END IF;
	END IF;

	RETURN RETVAL;
END DATA_DEFAULT;
;
