<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<!-- 2017/10/20 T.OTA 05100-170908-06 クラウド上で動作する場合は、ストレージからダウンロードサーブレットに遷移するように対応。 -->

<og:head headType="init" />
<og:requestCache cacheKey="{@GUI.KEY}" />

<og:fileUD typeDownload="true">
	<!-- 元がリクエストでなく、LASTSQLがnullでなければ、元のDBTableModelを、scope="request" に、コピー(ポインタのみ)している。 -->
	<og:query
		command		= "NEW"
		maxRowCount	= "0"
		quotCheck	= "false"
		scope		= "request"
		mainTrans	= "false"
		queryType	= "{@USER.LASTSQLTYPE}"
		names		= "{@USER.LASTNAMES}">
			{@USER.LASTSQL}
	</og:query>
</og:fileUD>

<og:value command="SET" key="MODELNAME">
	<og:userInfo command="GET" key="REPORT_DEFAULT_MODELNAME_{@GAMENID}" />
</og:value>

<og:equals val1="{@MODELNAME}" nullCheck="true">
	<og:value command="SET" key="MODELNAME" value="{@SYS.TABLE_WRITER_DEFAULT_CLASS}" defaultVal="Default" />
</og:equals>

<!-- 成立すれば、BODY 部は実行しない。 exists の notEquals="true" なので、fileDownloadList.txt があれば、BODYを実行します。 -->
<og:file action="exists" fileURL="{@SYS.REAL_PATH}report/{@GAMENID}" file1="fileDownloadList.txt" notEquals="true" useStop="false">

	<og:readTable
		command		= "NEW"
		fileURL		= "{@SYS.REAL_PATH}report/{@GAMENID}"
		filename	= "fileDownloadList.txt"
		tableId		= "list"
		scope		= "request"
		mainTrans	= "false"
		displayMsg	= ""
		notfoundMsg	= ""
	/>

	<og:readTable
		command		= "NEW"
		fileURL		= "{@SYS.REAL_PATH}report/{@GAMENID}"
		filename	= "fileDownloadList.txt"
		maxRowCount	= "1"
		tableId		= "dummy"
		scope		= "request"
		mainTrans	= "false"
		overflowMsg	= ""
	/>
	<og:entry command="MODIFY" tableId="dummy" scope="request" selectedAll="true" useConsistency="false">
		<og:columnSet command="MODIFY" columnId="MODELNAME" action="SET" value="{@MODELNAME}"/>
	</og:entry>

	<!-- fileDownloadList.txtを結合し、出力対象のデータを設定します -->
	<og:tableMerge
		action			= "INTERSECT"
		masterTableId	= "list"
		masterScope		= "request"
		slaveTableId	= "dummy"
		slaveScope		= "request"
		masterKeys		= "MODELNAME"
		slaveKeys		= "MODELNAME"
		tableId			= "out"
		scope			= "request"
		mainTrans		= "false"
		display			= "false"
	/>

	<og:value command="SETTBL" tableId="out" tblScope="request" key="MODELNAME" action="FIRST" />
	<og:value command="SETTBL" tableId="out" tblScope="request" key="REPNAME"   action="FIRST" />
	<og:value command="SETTBL" tableId="out" tblScope="request" key="TYPE"      action="FIRST" />
	<og:value command="SETTBL" tableId="out" tblScope="request" key="ISREP"     action="FIRST" />

	<!-- ユーザーが追加した帳票の場合 -->
	<og:equals val1="{@ISREP}" val2="Y">
		<og:file action="exists" fileURL="{@SYS.REAL_PATH}report/{@GAMENID}" file1="{@MODELNAME}.ods" notEquals="true" useStop="false">
			<og:equals val1="{@TYPE}" val2="P">
				<og:value command="SET" key="endWith" value="pdf"/>
			</og:equals>

			<og:equals val1="{@TYPE}" val2="E">
				<og:value command="SET" key="endWith" value="xls"/>
			</og:equals>

			<og:report2
				fileURL		= "{@SYS.REAL_PATH}report/{@GAMENID}/"
				listId		= "{@MODELNAME}"
				outFileURL	= "{@USER.ID}/"
				outFilename	= "{@MODELNAME}.{@endWith}"
				fgrun		= "{@TYPE}"
				scope		= "request"
			/>

			<og:forward page="{@SYS.FILE_OUT_URL}/{@USER.ID}/{@MODELNAME}.{@endWith}" filename="{@REPNAME}.{@endWith}" />
		</og:file>
	</og:equals>
</og:file>

<!-- 6.2.0.0 (2015/02/27) EXCELファイルの形式(xls/xlsx)を、個人設定可 に変更 -->
<og:value command="SET" key="SUFIX" value="{@SYS.TABLE_WRITER_EXCEL_TYPE}" defaultVal="xls" />

<!-- ファイルが強制削除されるなどして、帳票発行ができない場合は、Defaultで発行します -->
<og:equals val1="|Default|Renderer|Excel|XLSNR|" val2="|{@MODELNAME}|" contains="true" notEquals="true">
	<!-- 6.2.0.0 (2015/02/27) 初期値を、Default ではなく、TABLE_WRITER_DEFAULT_CLASS で定義する。-->
	<og:value command="SET" key="MODELNAME" value="{@SYS.TABLE_WRITER_DEFAULT_CLASS}" defaultVal="Default" />
</og:equals>

<og:equals val1="Excel" val2="{@MODELNAME}" startsWith="true">
	<og:value command="SET" key="MODELNAME"	value="{@MODELNAME}Renderer" />
	<og:value command="SET" key="CLMS"		value="{@DB.CLM_NAMES}"/>
</og:equals>
<og:equals val1="XLSNR" val2="{@MODELNAME}"><!-- 2013/04/27 5.6.3.4 -->
	<og:value command="SET" key="MODELNAME"	value="Excel" />
</og:equals>
<og:equals val1="Renderer" val2="{@MODELNAME}">
	<og:value command="SET" key="CLMS"		value="{@DB.CLM_NAMES}"/>
	<!-- 6.2.0.0 (2015/02/27) TEXT系は、xlsでないとエラーになる。 -->
	<og:value command="SET" key="SUFIX"		value="xls" />
</og:equals>
<og:equals val1="Default" val2="{@MODELNAME}">
	<!-- 6.2.0.0 (2015/02/27) TEXT系は、xlsでないとエラーになる。 -->
	<og:value command="SET" key="SUFIX"		value="xls" />
</og:equals>

<og:columnEditor columns="*" addKeyLabel="{@SYS.USE_ADD_KEY_LABEL}" scope="request" />

<!-- 7.2.5.0 (2020/06/01) 最初に既存のﾌｧｲﾙを消しておきます。 -->
<og:file action="delete" fileURL="{@USER.ID}" file1="fileout.{@SUFIX}" useStop="false" />

<og:writeTable
	writerClass		= "{@MODELNAME}"
	fileURL			= "{@USER.ID}"
	filename		= "fileout.{@SUFIX}"
	columns			= "{@CLMS}"
	encode			= "{@SYS.FILE_ENCODE}"
	scope			= "request"
/>

<!-- 7.2.5.0 (2020/06/01) ﾌｧｲﾙが存在しなければ、ここで停止します。 -->
<og:file action="exists" fileURL="{@USER.ID}" file1="fileout.{@SUFIX}" >
	<og:message lbl="ERR0042" />
</og:file>

<!-- 5.9.25.2 (2017/10/27) クラウド対応、 5.10.9.0 (2019/03/01) CLOUD_STORAGEからCLOUD_TARGETに名称変更-->
<!-- クラウドでない場合は直接参照 -->
<!-- useRedirect="true" を入れると、ファイル名変換が動作しない。-->
<og:equals val1="{@SYS.CLOUD_TARGET}" nullCheck="true">
	<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/fileout.{@SUFIX}" filename="{@filename}.{@SUFIX}" disposition="attachment" />
</og:equals>
<og:equals val1="{@SYS.CLOUD_TARGET}" val2="DEFAULT" >
	<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/fileout.{@SUFIX}" filename="{@filename}.{@SUFIX}" disposition="attachment" />
</og:equals>

<!-- クラウド利用の場合はダウンロードサーブレットの実行 -->
<og:equals val1="{@SYS.CLOUD_TARGET}" nullCheck="true" notEquals="true">
	<!-- 5.10.9.0 (2019/03/01) useStringConvert属性を追加 -->
	<og:forward page="../fileDownload" keys="file,name,useStringConvert,bucketName,storageType" vals="{@SYS.FILE_URL}{@USER.ID}/fileout.{@SUFIX},{@filename},false,{@bucketName},{@storageType}" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
