/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5DigestCalculatingInputStream
extends SdkFilterInputStream {
    private MessageDigest digest = this.newMD5();
    private MessageDigest digestLastMarked;

    public MD5DigestCalculatingInputStream(InputStream in) {
        super(in);
    }

    private MessageDigest newMD5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("unexpected", e);
        }
    }

    private MessageDigest cloneFrom(MessageDigest from) {
        try {
            return (MessageDigest)from.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("unexpected", e);
        }
    }

    public byte[] getMd5Digest() {
        return this.digest.digest();
    }

    public void mark(int readlimit) {
        if (this.markSupported()) {
            super.mark(readlimit);
            this.digestLastMarked = this.cloneFrom(this.digest);
        }
    }

    public void reset() throws IOException {
        if (!this.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        super.reset();
        this.digest = this.digestLastMarked == null ? this.newMD5() : this.cloneFrom(this.digestLastMarked);
    }

    public int read() throws IOException {
        int ch = super.read();
        if (ch != -1) {
            this.digest.update((byte)ch);
        }
        return ch;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result != -1) {
            this.digest.update(b, off, result);
        }
        return result;
    }
}

