/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.internal;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.exception.SystemException;
import oracle.cloud.storage.internal.TokenAuthFilter;
import oracle.cloud.storage.javaservice.StorageHelper;
import oracle.cloud.storage.nls.ClientMessage;
import oracle.cloud.storage.spi.CloudStorageAuthenticationProvider;
import oracle.cloud.storage.spi.CloudStorageReAuthenticationProvider;

public class TokenAuthenticationProvider
implements CloudStorageAuthenticationProvider,
CloudStorageReAuthenticationProvider {
    private static final String AUTH_HEADER = "X-Auth-Token";
    private static final String PASSWORD_HEADER = "X-Storage-Pass";
    private static final String USER_HEADER = "X-Storage-User";
    private static final String API_VERSION = "v1.0";
    public static final Logger logger = Logger.getLogger("oracle.cloud.storage.internal");

    private UriBuilder getAuthUrl(URL serviceUrl) {
        return UriBuilder.fromPath((String)serviceUrl.toExternalForm()).path("auth").path(API_VERSION);
    }

    @Override
    public final void authenticate(Client client, CloudStorageConfig config) {
        WebResource resource = client.resource(this.getAuthUrl(config.getServiceUrl()).build(new Object[0]));
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.accept(new String[]{"*/*"}).header(USER_HEADER, (Object)(config.getServiceName() + ":" + config.getUsername()))).header(PASSWORD_HEADER, (Object)new String(config.getPassword()))).get(ClientResponse.class);
        if (response.getClientResponseStatus() != ClientResponse.Status.OK) {
            String message = (String)response.getEntity(String.class);
            throw new SystemException(ClientMessage.systemError(response.getClientResponseStatus().name(), message));
        }
        String token = (String)response.getHeaders().getFirst((Object)AUTH_HEADER);
        client.addFilter((ClientFilter)new TokenAuthFilter(token, this, client, config));
    }

    @Override
    public final void reauthenticate(Client client, CloudStorageConfig config, ClientRequest cr) {
        String token;
        WebResource resource;
        ClientResponse response;
        StorageHelper helper = null;
        Class<?> clz = null;
        try {
            clz = Class.forName("oracle.cloud.storage.javaservice.StorageHelperImpl");
            helper = (StorageHelper)clz.newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Association StorageHelper impl class missing. Hence not considering association for reauthentication logic.");
        }
        String serviceName = config.getServiceName();
        if (helper != null && helper.isServiceAssociated(serviceName)) {
            try {
                Object[] creds = helper.getCredentials(serviceName);
                config.setUsername((String)creds[0]).setPassword((char[])creds[1]);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to reauthenticate", e);
            }
        }
        if ((response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)(resource = client.resource(this.getAuthUrl(config.getServiceUrl()).build(new Object[0]))).accept(new String[]{"*/*"}).header(USER_HEADER, (Object)(config.getServiceName() + ":" + config.getUsername()))).header(PASSWORD_HEADER, (Object)new String(config.getPassword()))).get(ClientResponse.class)).getClientResponseStatus() == ClientResponse.Status.OK) {
            token = (String)response.getHeaders().getFirst((Object)AUTH_HEADER);
            if (cr.getHeaders().containsKey((Object)AUTH_HEADER)) {
                cr.getHeaders().remove((Object)AUTH_HEADER);
            }
        } else {
            String message = (String)response.getEntity(String.class);
            throw new SystemException(ClientMessage.systemError(response.getClientResponseStatus().name(), message));
        }
        cr.getHeaders().add((Object)AUTH_HEADER, (Object)token);
        client.addFilter((ClientFilter)new TokenAuthFilter(token, this, client, config));
    }
}

