/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.post;

import java.security.PrivateKey;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.head.IHeadRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.post.IPostObjectReply;
import oracle.cloudstorage.api.post.IPostRequestBuilder;
import oracle.cloudstorage.api.post.IPostRequestProcessor;
import oracle.cloudstorage.api.post.PostObjectReply;
import oracle.cloudstorage.api.request.processor.AbstractRequestProcessor;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.retry.RetryException;

public abstract class PostRequestProcessor
extends AbstractRequestProcessor<IPostRequestBuilder, IPostRequestProcessor>
implements IPostRequestProcessor {
    protected PostRequestProcessor(IProcessorFactory factory) {
        super(factory);
    }

    protected abstract IPostObjectReply objectImpl() throws RetryException;

    protected IPostObjectReply rotateCipherKeys() throws RetryException, InterruptedException {
        IPostRequestBuilder builder = (IPostRequestBuilder)this.getBuilder();
        PrivateKey decryptionKey = builder.getDecryptionKey();
        if (decryptionKey == null) {
            return null;
        }
        String accountId = builder.getAccountId();
        String containerId = builder.getContainerId();
        String objectId = builder.getObjectId();
        IHeadObjectReply headObjectReply = ((IHeadRequestBuilder.Object)((IHeadRequestBuilder.Container)((IHeadRequestBuilder.Account)((IHeadRequestBuilder.Header)((IHeadRequestBuilder.ReadTimeout)((IHeadRequestBuilder.ConnectTimeout)this.getSession().head().retry(builder.getRetryStrategy())).connect(builder.getConnectTimeout(), TimeUnit.MILLISECONDS)).read(builder.getReadTimeout(), TimeUnit.MILLISECONDS)).account(accountId)).container(containerId)).object(objectId)).send();
        if (!headObjectReply.isSuccessful()) {
            PostObjectReply postObjectReply = new PostObjectReply(headObjectReply);
            return postObjectReply;
        }
        Map headers = headObjectReply.getHeaders();
        String failure = this.getSession().rotate(headers, decryptionKey);
        if (failure != null) {
            PostObjectReply postObjectReply = new PostObjectReply(headers, Status.BAD_REQUEST.getStatusCode(), failure, null);
            return postObjectReply;
        }
        for (String key : headers.keySet()) {
            String value = headers.get(key);
            builder.getSendable().getHeaders().setHeader(Header.provide(key, value));
        }
        return null;
    }

    @Override
    public final IPostObjectReply object() throws RetryException, InterruptedException {
        IPostObjectReply postObjectReply = this.rotateCipherKeys();
        if (postObjectReply == null) {
            postObjectReply = this.objectImpl();
        }
        return postObjectReply;
    }
}

