/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFactory;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.LogWriter;

public final class FileUtil {
    private static final NonClosePrintWriter outWriter = new NonClosePrintWriter(System.out);
    private static final NonClosePrintWriter errWriter = new NonClosePrintWriter(System.err);
    private static final String CR = System.getProperty("line.separator");
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final char EXTENSION_SEPARATOR = '.';
    private static final byte B_CR = 13;
    private static final byte B_LF = 10;
    private static final int BUFSIZE = 8192;

    private FileUtil() {
    }

    public static PrintWriter getPrintWriter(File file, String string) {
        return FileUtil.getPrintWriter(file, string, false);
    }

    public static PrintWriter getPrintWriter(File file, String string, boolean bl) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + unsupportedEncodingException.getMessage() + CR + "File=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + fileNotFoundException.getMessage() + CR + "File=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string3, fileNotFoundException);
        }
        return printWriter;
    }

    public static PrintWriter getLogWriter(String string) {
        if (string == null) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u540d\u306b\u3001null \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        PrintWriter printWriter = "System.out".equalsIgnoreCase(string) ? outWriter : ("System.err".equalsIgnoreCase(string) ? errWriter : FileUtil.getPrintWriter(new File(string), "UTF-8", true));
        return printWriter;
    }

    public static PrintWriter getPrintWriter(OutputStream outputStream, String string) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + unsupportedEncodingException.getMessage() + CR + "encode=[" + string + "]";
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        return printWriter;
    }

    public static PrintWriter getNonFlushPrintWriter(Writer writer) {
        return new NonFlushPrintWriter(writer);
    }

    public static BufferedReader getBufferedReader(File file, String string) {
        BufferedReader bufferedReader;
        try {
            if (file instanceof FileOperation) {
                FileOperation fileOperation = (FileOperation)file;
                bufferedReader = new BufferedReader(new InputStreamReader(fileOperation.read(), string));
            } else {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "\u6307\u5b9a\u3055\u308c\u305f\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0\u304c\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + CR + unsupportedEncodingException.getMessage() + CR + "FIle=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string2, unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30aa\u30fc\u30d7\u30f3\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + fileNotFoundException.getMessage() + CR + "FIle=[" + file + " , encode=[" + string + "]";
            throw new RuntimeException(string3, fileNotFoundException);
        }
        return bufferedReader;
    }

    public static File checkFile(String string, String string2) {
        return FileUtil.checkFile(string, string2, 3);
    }

    public static File checkFile(String string, String string2, int n) {
        File file = null;
        for (int i = n; i > 0 && !(file = new File(string, string2)).exists(); --i) {
            if (i == 1) {
                return null;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException");
            }
            System.out.println();
            System.out.print("CHECK File Error! CNT=" + i);
            System.out.print(" File=" + file.getAbsolutePath());
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            String string3 = "\u30d5\u30a1\u30a4\u30eb\u306e\u6b63\u5f0f\u30d1\u30b9\u540d\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002[" + file.getAbsolutePath() + "]";
            throw new RuntimeException(string3, iOException);
        }
    }

    public static boolean copy(String string, String string2) {
        return FileUtil.copy(new File(string), new File(string2), false);
    }

    public static boolean copy(String string, String string2, boolean bl) {
        return FileUtil.copy(new File(string), new File(string2), bl);
    }

    public static boolean copy(File file, File file2) {
        return FileUtil.copy(file, file2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copy(File file, File file2, boolean bl) {
        InputStream inputStream;
        File file3;
        FileChannel fileChannel;
        FileChannel fileChannel2;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        block16: {
            boolean bl2;
            block15: {
                boolean bl3;
                block14: {
                    fileInputStream = null;
                    fileOutputStream = null;
                    fileChannel2 = null;
                    fileChannel = null;
                    file3 = file2;
                    inputStream = null;
                    try {
                        File file4;
                        if (file.isDirectory()) {
                            System.err.println(file + " \u304c\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u305f\u3081\u3001\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3002");
                            bl3 = false;
                            Closer.ioClose(fileInputStream);
                            break block14;
                        }
                        if (file2.isDirectory()) {
                            file3 = file2 instanceof FileOperation ? FileOperationFactory.newStorageOperation(file2, file2.getAbsolutePath(), file.getName()) : new File(file2, file.getName());
                        }
                        if (!(file4 = file3.getParentFile()).exists() && !file4.mkdirs()) {
                            System.err.println(file4 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            bl2 = false;
                            Closer.ioClose(fileInputStream);
                            break block15;
                        }
                        if (file2 instanceof FileOperation) {
                            inputStream = file instanceof FileOperation ? ((FileOperation)file).read() : new FileInputStream(file);
                            ((FileOperation)file2).write(inputStream);
                        } else if (file instanceof FileOperation) {
                            inputStream = ((FileOperation)file).read();
                            Files.copy(inputStream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        } else {
                            fileInputStream = new FileInputStream(file);
                            fileOutputStream = new FileOutputStream(file3);
                            fileChannel2 = fileInputStream.getChannel();
                            fileChannel = fileOutputStream.getChannel();
                            fileChannel2.transferTo(0L, fileChannel2.size(), fileChannel);
                        }
                        Closer.ioClose(fileInputStream);
                        break block16;
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.getMessage());
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                Closer.ioClose(fileOutputStream);
                Closer.ioClose(fileChannel2);
                Closer.ioClose(fileChannel);
                Closer.ioClose(inputStream);
                return bl3;
            }
            Closer.ioClose(fileOutputStream);
            Closer.ioClose(fileChannel2);
            Closer.ioClose(fileChannel);
            Closer.ioClose(inputStream);
            return bl2;
        }
        Closer.ioClose(fileOutputStream);
        Closer.ioClose(fileChannel2);
        Closer.ioClose(fileChannel);
        Closer.ioClose(inputStream);
        if (!bl) return true;
        return file3.setLastModified(file.lastModified());
        finally {
            Closer.ioClose(fileInputStream);
            Closer.ioClose(fileOutputStream);
            Closer.ioClose(fileChannel2);
            Closer.ioClose(fileChannel);
            Closer.ioClose(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeCrLfcopy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        File file3 = file2;
        try {
            int n;
            if (file2.isDirectory()) {
                file3 = new File(file2, file.getName());
            }
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            byte[] byArray = new byte[8192];
            boolean bl = true;
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) != -1) {
                int n3 = 0;
                if (bl && n >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                    n3 = 3;
                } else if (n2 == 13 && byArray[0] == 10) {
                    n3 = 1;
                }
                bl = false;
                for (int i = n3; i < n; ++i) {
                    n2 = byArray[i];
                    if (n2 == 13 || n2 == 10) {
                        bufferedOutputStream.write(13);
                        bufferedOutputStream.write(10);
                        if (n2 != 13 || i + 1 >= n || byArray[i + 1] != 10) continue;
                        n2 = byArray[++i];
                        continue;
                    }
                    bufferedOutputStream.write(n2);
                }
            }
            if (n2 != 13 && n2 != 10) {
                bufferedOutputStream.write(13);
                bufferedOutputStream.write(10);
            }
        }
        catch (IOException iOException) {
            boolean bl;
            try {
                System.out.println(iOException.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                Closer.ioClose(bufferedOutputStream);
                throw throwable;
            }
            Closer.ioClose(bufferedInputStream);
            Closer.ioClose(bufferedOutputStream);
            return bl;
        }
        Closer.ioClose(bufferedInputStream);
        Closer.ioClose(bufferedOutputStream);
        return true;
    }

    public static boolean copy(InputStream inputStream, OutputStream outputStream) {
        if (inputStream == null) {
            System.err.println("\u5165\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304c \u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (outputStream == null) {
            System.err.println("\u51fa\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u304c \u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return false;
        }
        return true;
    }

    public static boolean copyDirectry(String string, String string2) {
        return FileUtil.copyDirectry(new File(string), new File(string2), false);
    }

    public static boolean copyDirectry(File file, File file2) {
        return FileUtil.copyDirectry(file, file2, false);
    }

    public static boolean copyDirectry(File file, File file2, boolean bl) {
        if (!file.exists() || !file.isDirectory()) {
            System.err.println(file + " \u304c \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306a\u3044\u304b\u3001\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
            return false;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.err.println(file + " \u306f\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        boolean bl2 = true;
        for (int i = 0; fileArray.length > i; ++i) {
            bl2 = fileArray[i].isDirectory() ? FileUtil.copyDirectry(fileArray[i], new File(file2, fileArray[i].getName()), bl) : FileUtil.copy(fileArray[i], new File(file2, fileArray[i].getName()), bl);
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteFiles(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray == null) {
                    System.err.println(file + " \u306f\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3002");
                    return false;
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    FileUtil.deleteFiles(fileArray[i]);
                }
            }
            if (!file.delete()) {
                return false;
            }
        }
        return true;
    }

    public static void getFileList(File file, boolean bl, List<String> list, boolean bl2) {
        if (list == null) {
            return;
        }
        if (file.isFile()) {
            if (!bl2 && !file.renameTo(file)) {
                return;
            }
            list.add(file.getAbsolutePath());
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.getFileList(fileArray[i], bl, list, bl2);
            }
        }
        if (bl) {
            Collections.sort(list);
        }
    }

    public static void getFileList(File file, boolean bl, List<String> list) {
        FileUtil.getFileList(file, bl, list, true);
    }

    public static String getBaseName(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        int n3 = string.lastIndexOf(47);
        int n4 = Math.max(n3, n2 = string.lastIndexOf(92));
        if (n4 > (n = string.lastIndexOf(46))) {
            n = -1;
        }
        if (n < 0) {
            return string.substring(n4 + 1);
        }
        return string.substring(n4 + 1, n);
    }

    public static boolean renameTo(File file, File file2, boolean bl) {
        Object object;
        if (file == null || file2 == null) {
            String string = "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u304c null \u3067\u3059\u3002";
            System.err.println(string);
            return false;
        }
        if (file2.exists()) {
            if (bl) {
                object = file2.getParentFile();
                FileOperation fileOperation = FileOperationFactory.newStorageOperation(file2, ((File)object).getPath(), "_backup");
                if (!fileOperation.exists() && !fileOperation.mkdirs()) {
                    String string = "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u51e6\u7406\u3067backup\u30d5\u30a9\u30eb\u30c0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + fileOperation + "]";
                    System.err.println(string);
                    return false;
                }
                String string = file2.getName();
                FileOperation fileOperation2 = FileOperationFactory.newStorageOperation(file2, ((File)object).getPath(), string);
                string = string + "_" + System.currentTimeMillis() + "." + FileUtil.getExtension(string);
                File file3 = new File(fileOperation, string);
                FileOperationFactory.newStorageOperation(fileOperation, fileOperation.getParent(), string);
                if (!fileOperation2.renameTo(file3)) {
                    String string2 = "\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u51e6\u7406\u3067\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "  [" + file2 + "] \u21d2 [" + file3 + "]";
                    System.err.println(string2);
                    return false;
                }
            } else if (!file2.delete()) {
                String string = "\u65e2\u5b58\u306e\u30d5\u30a1\u30a4\u30eb[" + file2 + "]\u304c\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
                System.err.println(string);
                return false;
            }
        }
        if (!file.renameTo(file2)) {
            object = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "  [" + file + "] \u21d2 [" + file2 + "]";
            System.err.println((String)object);
            return false;
        }
        return true;
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length != 2 && stringArray.length != 4) {
            LogWriter.log("Usage: java FileUtil <file1> <file2> [<encode1> <encode2>]");
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        File file3 = new File(stringArray[1] + "_backup");
        if (stringArray.length < 3) {
            if (file.isDirectory()) {
                FileUtil.copyDirectry(file, file2, true);
            } else {
                FileUtil.copy(file2, file3);
                FileUtil.copy(file, file2, true);
            }
        } else {
            String string = stringArray[2];
            String string2 = stringArray[3];
            FileUtil.copy(file2, file3);
            BufferedReader bufferedReader = FileUtil.getBufferedReader(file, string);
            PrintWriter printWriter = FileUtil.getPrintWriter(file2, string2);
            try {
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    printWriter.println(string3);
                }
            }
            finally {
                Closer.ioClose(bufferedReader);
                Closer.ioClose(printWriter);
            }
        }
    }

    private static final class NonFlushPrintWriter
    extends PrintWriter {
        public NonFlushPrintWriter(Writer writer) {
            super(writer);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }

    private static final class NonClosePrintWriter
    extends PrintWriter {
        public NonClosePrintWriter(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() {
        }
    }
}

