/****************************************************************************/
/* GE66 ( 受信管理テーブル )                                                */
/*                                                                          */
/* Created : 2019/08/30 14:47:17                                            */
/****************************************************************************/
CREATE TABLE GE66 (
   SYSTEM_ID    VARCHAR2 (  100 )                   NOT NULL            /*  10 ｼｽﾃﾑID               */
 , YKNO         NUMBER   (   10 )                   NOT NULL            /*  20 要求番号             */
 , QUEUEID      VARCHAR2 (  100 )                   NOT NULL            /*  30 キューID             */
 , SFDUPID      VARCHAR2 (  100 )                                       /*  40 SQSFIFO重複排除ID    */
 , MESSAGE      CLOB                                                    /*  50 送信メッセージ       */
 , FGKAN        VARCHAR2 (    1 )                   NOT NULL            /*  60 完了フラグ           */
 , ERRMSG       VARCHAR2 ( 1000 )                                       /*  70 エラーメッセージ     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  80 ﾕﾆｰｸｷｰ               */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /*  90 状態ﾌﾗｸﾞ             */
 , DYSET        VARCHAR2 (   14 )                                       /* 100 登録日時             */
 , PGSET        VARCHAR2 (   10 )                                       /* 110 作成PG               */
 , PGPSET       VARCHAR2 (   10 )                                       /* 120 作成親PG             */
 , USRSET       VARCHAR2 (   10 )                                       /* 130 作成社員             */
 , DYUPD        VARCHAR2 (   14 )                                       /* 140 更新日時             */
 , PGUPD        VARCHAR2 (   10 )                                       /* 150 更新PG               */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 160 更新親PG             */
 , USRUPD       VARCHAR2 (   10 )                                       /* 170 更新者               */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GE66S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE66T00 
  BEFORE INSERT ON GE66
  FOR EACH ROW 
  BEGIN 
    SELECT GE66S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
