/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.cipher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.cloudstorage.io.IO;

public class CryptoUtils {
    public static final String AES = "AES";
    public static final String RSA = "RSA";
    public static final String HMAC = "HMACSHA256";
    public static final String AES_CIPHER = "AES/CBC/PKCS5Padding";
    public static final String RSAWithPadding = "RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING";
    public static final int AES_KEYSIZE = 128;
    public static final int RSA_KEYSIZE = 2048;

    public static SecretKey createAESKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(AES);
        keyGen.init(128);
        SecretKey sk = keyGen.generateKey();
        return sk;
    }

    public static KeyPair createRSAKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(RSA);
        keyGen.initialize(2048);
        KeyPair kp = keyGen.generateKeyPair();
        return kp;
    }

    public static SecretKey createHMACKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(HMAC);
        return keyGen.generateKey();
    }

    public static String encrypt(byte[] value, PublicKey key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(RSAWithPadding);
        cipher.init(1, key);
        byte[] encrypted = cipher.doFinal(value);
        return CryptoUtils.byteArrayToHexString(encrypted);
    }

    public static String encrypt(byte[] value, SecretKey key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_CIPHER);
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[cipher.getBlockSize()];
        random.nextBytes(iv);
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] encrypted = cipher.doFinal(value);
        return CryptoUtils.byteArrayToHexString(iv) + CryptoUtils.byteArrayToHexString(encrypted);
    }

    public static InputStream decrypt(String envelopeKey, String digestKey, String digest, InputStream in, KeyPair keyPair) throws GeneralSecurityException {
        byte[] decryptedEnvelope = CryptoUtils.decrypt(envelopeKey, keyPair.getPrivate());
        byte[] decryptedDigest = CryptoUtils.decrypt(digestKey, keyPair.getPrivate());
        byte[] digestBytes = digest == null ? null : CryptoUtils.hexStringToByteArray(digest);
        SecretKeySpec aes = new SecretKeySpec(decryptedEnvelope, AES);
        SecretKeySpec hmac = new SecretKeySpec(decryptedDigest, HMAC);
        InputStream decryptionStream = CryptoUtils.createDecryptionFilter(in, aes, hmac, digestBytes);
        return decryptionStream;
    }

    public static byte[] decrypt(String encrypted, PrivateKey key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(RSAWithPadding);
        cipher.init(2, key);
        byte[] decrypted = cipher.doFinal(CryptoUtils.hexStringToByteArray(encrypted));
        return decrypted;
    }

    public static byte[] decrypt(String encrypted, SecretKey key) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_CIPHER);
        byte[] iv = CryptoUtils.hexStringToByteArray(encrypted.substring(0, cipher.getBlockSize() * 2));
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] decrypted = cipher.doFinal(CryptoUtils.hexStringToByteArray(encrypted.substring(cipher.getBlockSize() * 2)));
        return decrypted;
    }

    public static DigestInputStream createEncryptionFilter(InputStream in, SecretKey key, SecretKey hmac) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_CIPHER);
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[cipher.getBlockSize()];
        random.nextBytes(iv);
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        CipherInputStream cin = new CipherInputStream(in, cipher);
        Mac mac = Mac.getInstance(hmac.getAlgorithm());
        mac.init(hmac);
        return new DigestInputStream(cin, iv, mac);
    }

    public static InputStream createDecryptionFilter(InputStream in, SecretKey key, SecretKey hmac, final byte[] digest) throws GeneralSecurityException {
        int len;
        Cipher cipher = Cipher.getInstance(AES_CIPHER);
        int off = 0;
        byte[] iv = new byte[len];
        try {
            int n;
            for (len = cipher.getBlockSize(); (n = in.read(iv, off, len)) < len; len -= n) {
                off += n;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        final Mac mac = Mac.getInstance(hmac.getAlgorithm());
        mac.init(hmac);
        InputStreamAdapter hin = new InputStreamAdapter(in){

            @Override
            public int read() throws IOException {
                int n = super.read();
                if (n == -1) {
                    this.checkHMAC();
                } else {
                    mac.update((byte)n);
                }
                return n;
            }

            @Override
            public int read(byte[] b, int moff, int mlen) throws IOException {
                int n = super.read(b, moff, mlen);
                if (n == -1) {
                    this.checkHMAC();
                } else {
                    mac.update(b, moff, n);
                }
                return n;
            }

            private void checkHMAC() {
                byte[] d = mac.doFinal();
                if (digest != null && !Arrays.equals(digest, d)) {
                    throw new IllegalStateException("HMAC digest does not match for decrypted content");
                }
            }
        };
        return new CipherInputStream(hin, cipher);
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }

    public static String encryptedToString(InputStream encryptedData) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IO.read(encryptedData).into(baos);
        String s = "<" + baos.toByteArray().length + " bytes of encrypted data>";
        return s;
    }

    public static class InputStreamAdapter
    extends InputStream {
        private InputStream in;

        public InputStreamAdapter(InputStream in) {
            this.in = in;
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }
    }

    public static class DigestInputStream
    extends InputStreamAdapter {
        private byte[] iv;
        private Mac mac;
        private boolean done = false;
        private int offset = 0;
        byte[] digest;

        public DigestInputStream(InputStream in, byte[] iv, Mac mac) {
            super(in);
            this.iv = iv;
            this.mac = mac;
        }

        @Override
        public int read() throws IOException {
            if (this.iv == null || this.mac == null) {
                return super.read();
            }
            if (!this.done) {
                byte b = this.iv[this.offset++];
                if (this.offset == this.iv.length) {
                    this.done = true;
                }
                return b;
            }
            int b = super.read();
            if (b == -1) {
                this.digest = this.mac.doFinal();
            } else {
                this.mac.update((byte)b);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.iv == null || this.mac == null) {
                return super.read(b, off, len);
            }
            if (!this.done) {
                int remaining = this.iv.length - this.offset;
                if (remaining <= len) {
                    System.arraycopy(this.iv, this.offset, b, off, remaining);
                    this.done = true;
                    return remaining;
                }
                System.arraycopy(this.iv, this.offset, b, off, len);
                this.offset += len;
                return len;
            }
            int n = super.read(b, off, len);
            if (n == -1) {
                this.digest = this.mac.doFinal();
            } else {
                this.mac.update(b, off, n);
            }
            return n;
        }

        public byte[] getDigest() {
            return this.digest;
        }
    }
}

