/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.reply;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.reply.Reply;
import oracle.cloudstorage.text.Strings;

public class IdSetReply
extends Reply {
    private final Set<String> ids = new LinkedHashSet<String>();

    public IdSetReply(Map<String, ?> headers, int statusCode, String message, String joinedIds, IReply.Context context) {
        super(headers, statusCode, message, context);
        if (this.getStatus().getFamily() == Status.Family.SUCCESSFUL) {
            this.ids.addAll(Strings.split(joinedIds).on(Strings.Split.Pattern.newlines));
        }
    }

    protected final Set<String> getIds() {
        return Collections.unmodifiableSet(this.ids);
    }

    @Override
    public String toString() {
        return ((Strings.Join)Strings.join(super.toString()).and(this.getIds())).with("\n    ");
    }
}

