/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.request.AttributeProvider;
import oracle.cloudstorage.api.request.IAttribute;
import oracle.cloudstorage.text.Strings;

public abstract class AttributetMap<P extends AttributeProvider<String, P, A>, A extends IAttribute>
extends HashMap<String, String>
implements Iterable<Map.Entry<String, String>> {
    private static final long serialVersionUID = 6264193913397432064L;

    public AttributetMap() {
    }

    public AttributetMap(Map<? extends String, ?> source) {
        this.putNormalized(source);
    }

    private String normalizedKey(Object key) {
        String normalizedKey;
        if (key == null) {
            return null;
        }
        String string = normalizedKey = key instanceof String ? (String)key : key.toString();
        if (!normalizedKey.equals("repPolicy")) {
            normalizedKey = normalizedKey.toLowerCase();
        }
        return normalizedKey;
    }

    @Override
    public final boolean containsKey(Object key) {
        return super.containsKey(this.normalizedKey(key));
    }

    @Override
    public final String get(Object key) {
        return (String)super.get(this.normalizedKey(key));
    }

    @Override
    public final String put(String key, String value) {
        String normalizedKey = null;
        if (key != null) {
            normalizedKey = key.equals("repPolicy") ? key : key.toLowerCase();
        }
        return super.put(normalizedKey, value);
    }

    @Override
    public final String put(A key, Object value) {
        String normalizedKey = key == null ? null : key.getKey();
        String joinedValue = this.joined(value);
        return super.put(normalizedKey, joinedValue);
    }

    @Override
    public final void putAll(Map<? extends String, ? extends String> source) {
        this.putNormalized(source);
    }

    public final void putNormalized(Iterable<Map.Entry<String, String>> source) {
        for (Map.Entry<String, String> entry : source) {
            this.put((P)entry);
        }
    }

    protected final void put(Map.Entry<? extends String, ?> entry) {
        String value = this.joined(entry.getValue());
        this.put(entry.getKey(), value);
    }

    protected String joined(Object value) {
        return Strings.join(value).with(",");
    }

    public final void putNormalized(Map<? extends String, ?> source) {
        if (source == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            this.put((P)entry);
        }
    }

    public final Map<String, List<Object>> split() {
        HashMap<String, List<Object>> split = new HashMap<String, List<Object>>();
        for (Map.Entry entry : this.entrySet()) {
            List<String> stringValues = Strings.split(entry.getValue()).on(Strings.Split.Pattern.comma);
            ArrayList<String> objectValues = new ArrayList<String>(stringValues.size());
            objectValues.addAll(stringValues);
            split.put((String)entry.getKey(), (List<Object>)objectValues);
        }
        return split;
    }

    @Override
    public final String remove(Object key) {
        return (String)super.remove(this.normalizedKey(key));
    }

    public final void put(P provider) {
        this.put(((AttributeProvider)provider).key, (String)((AttributeProvider)provider).value);
    }

    @Override
    public final Iterator<Map.Entry<String, String>> iterator() {
        return this.entrySet().iterator();
    }

    protected String mask(String key) {
        return this.get(key);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("{");
        for (String key : this.keySet()) {
            String value = this.mask(key);
            s.append(key).append(':').append(value).append(", ");
        }
        if (s.length() > 2) {
            s.setLength(s.length() - 2);
        }
        s.append('}');
        return s.toString();
    }
}

