/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.util.AbstractObjectPool;
import org.opengion.fukurou.util.Closer;

class ConnectionPool
extends AbstractObjectPool<Connection> {
    private final transient EDbid edbid;
    private static final String CR = System.getProperty("line.separator");

    public ConnectionPool(EDbid eDbid) {
        this.edbid = eDbid;
        this.init(eDbid.getMincount(), eDbid.getMaxcount(), true, eDbid.getPooltime());
    }

    @Override
    protected void objectFinal(Connection connection) {
        Closer.connClose(connection);
    }

    @Override
    protected Connection createInstance() {
        Connection connection = null;
        try {
            Properties properties = new Properties(this.edbid.getProps());
            properties.put("user", this.edbid.getUser());
            properties.put("password", this.edbid.getPassword());
            connection = DriverManager.getConnection(this.edbid.getUrl(), properties);
            connection.setReadOnly(this.edbid.isReadonly());
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            if (this.edbid.getDbProductName() == null) {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                this.edbid.setMetaDataInfo(databaseMetaData);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            String string = "\u30b3\u30cd\u30af\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + "DBID=[" + this.edbid.getDbidKey() + "]" + CR + sQLException.getMessage() + " , status=" + sQLException.getSQLState();
            Closer.connClose(connection);
            throw new RuntimeException(string, sQLException);
        }
    }

    public boolean useApplicationInfo() {
        return this.edbid.isApplicationInfo();
    }

    public String getDBName() {
        return this.edbid.getDbProductName();
    }

    public String getDBVersion() {
        return this.edbid.getDbProductVersion();
    }

    public String dbidInfo() {
        return this.edbid.info();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.edbid.toString());
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }
}

