/************************************************************************************/
/* 即時実行関数                                                                     */
/*                                                                                  */
/* @og.rev 5.10.10.0 (2019/03/29) 新規追加、jQueryバージョン違いの吸収              */
/* Revision: $Id$                                                                   */
/************************************************************************************/
(function(){
	if(jQuery != null && !jQuery._data){
		jQuery._data = jQuery.data;
	}
})();

/************************************************************************************/
/* 旧 focusHilight.js の内容を移植 5.2.1.0 (2010/10/01) 							*/
/*																					*/
/* フォーカスが当っているアクティブフィールドの色を変更します						*/
/* 色はfocusFieldクラスで指定しています 											*/
/*																					*/
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離・イベントにJQuery利用				*/
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる		*/
/* @og.rev 5.5.9.0 (2010/12/03) IE9対応。selectはstyleを直接変更する				*/
/* @og.rev 5.6.4.2 (2013/05/17) エラー表示の alertメッセージ修正					*/
/* Revision: $Id$																	*/
/************************************************************************************/

var orgFldCls = null;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusin( function(){ doFocus2( this ); } );
//	$('textarea,select,input[type="text"]').focusout( function(){ doBlur2( this ); } );
	if(USE_FOCUS_HILIGHT){ //5.4.5.0 flag add
		setEvent( "textarea,select,input[type=\"text\"]", "focusin", function(){ doFocus2( this ); } );
		setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ doBlur2( this ); } );
	}
});

function doFocus2( obj ) {
	// 入力中のフォームの色
	if( obj != null  ) {
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 4.3.2.2 (2008/09/16) 入力中のフォームの色をcustom.cssに指定するように変更
			// 5.5.9.0 (2012/12/03) selectタグの場合は直接背景色変更
			if( obj.tagName == "SELECT" ){ // 5.5.9.1(2012/12/07) 小文字を大文字に
				obj.orgBgColor	  = obj.style.backgroundColor;
				obj.style.backgroundColor = '#ffcccc';
			}
			else{
				orgFldCls	 = obj.className;
				obj.className = 'focusField ' + orgFldCls;
			}
		}
	}
}

function doBlur2( obj ) {
	if( obj != null ) {
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 元のフォームの色
			// 5.5.9.0 (2012/12/03) selectタグの場合は直接背景色変更
			if( obj.tagName == "SELECT" ){
				obj.style.backgroundColor = obj.orgBgColor;
			}
			else{
				if( orgFldCls != null ) {
					obj.className = orgFldCls;
				}
				else {
					obj.className = 'notFocusField';
				}
			}
		}
	}
}

/* 旧関数を呼び出した場合はアラートを出す（旧の*_inof.jsp対策） */
oldDoFocusFlag = true;
function doFocus( obj ) {
	if(oldDoFocusFlag){
		oldDoFocusFlag = false;
//		setTimeout(alert("custom/query_info.jsp及びcustom/result_info.jspで次の部分を削除して下さい。\n<script>タグ（ヘッダ固定とフォーカス）、BODYのonLoadとoncontextmenu属性"),100);
		setTimeout(alert("Old Script Error!!\ncustom/query_info.jsp,custom/result_info.jsp Please delete the following part.\n<script>Tag(Header fix and Focus) , BODY onLoad and oncontextmenu Attribute"),100);
	}
}
/*エラー対策の空関数 */
function doBlur( obj ) {}

/************************************************************************************/
/* 旧 autoConvert.js の内容を移植 5.2.1.0 (2010/10/01)								*/
/*																					*/
/* 入力値自動変換機能 4.3.0.0 (2008/07/25) 追加 									*/
/* dbType XL及びXUについて、大文字・小文字の自動変換を行います						*/
/*																					*/
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)						*/
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる		*/
/* @og.rev 5.9.5.0 (2016/02/05) PN2も大文字化の対象とする							*/
/* @og.rev 6.8.0.1 (2017/06/23) XU など変換時に、rtrim を行う						*/
/* Revision: $Id$																	*/
/************************************************************************************/
$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ convert( this ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ convert( this ); } );
});

function convert( obj ) {
	var val , cls ;

	val = obj.value;
	cls = obj.className;
	if( val != null && cls != null ) {
		if( cls.match( /XL/ ) && !(cls.match( /XLU/ )) ) {
			obj.value = val.toLowerCase();
		}
//		else if( cls.match( /XU/ ) && !(cls.match( /XUL/ )) ) {
		else if( (cls.match( /XU/ ) && !(cls.match( /XUL/ ))) || cls.match( /PN2/ ) ) { // 5.9.5.0
//			obj.value = val.toUpperCase();
			obj.value = val.replace( /\s+$/, "" ).toUpperCase();	// 6.8.0.1 (2017/06/23) rtrim を行う
		}
	}
	return true;
}

/************************************************************************************/
/* 旧 eventColumn.js の内容を移植 5.2.1.0 (2010/10/01)								*/
/*																					*/
/* 動的プルダウンを実行するためのJavaScriptです。									*/
/*																					*/
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる		*/
/* @og.rev 5.10.27.0 (2021/01/05) 初期発火のカラム判定修正                          */
/* Revision: $Id$																	*/
/************************************************************************************/
var colMap;
var notFireCols;
var jH_evElm;

$(function(){
	if( ! ( typeof( EC_NAME ) == "undefined" ) ) {
		// 初期化処理だけは、予め要素オブジェクトを取得しておき、ここから子カラムを取得する。
		jH_evElm = $( ".h_evElm" );

		makeColMapping();

		setEvent( "textarea,select,input[type=\"text\"]", "change", function(){ makeColumn( this ); }, ".h_evCol", true, addEvColCls );
		setEvent( "input[type=checkbox],input[type=radio]", "click", function(){ makeColumn( this ); }, ".h_evCol", true );
	}
});

/**
 * 親カラムをキーにしたイベントカラムの一覧を作成します。
 *
 * 親カラムを連想配列のキーとして、子カラムの一覧を配列として保持します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 * @og.rev 5.10.27.0 (2021/01/05) notFireColsのセット変更
 *
**/
function makeColMapping() {
	var i , j , evCols , evc , cCols ;

	if( colMap ){ return; }

	colMap = new Object();
	for(  i=0; i<EC_EVCOL.length; i++ ) {
		evCols = EC_EVCOL[i].split(",");
		for( j=0; j<evCols.length; j++ ) {
			evc = evCols[j];
			if( evc.charAt(0) == "_" ) {
				evc = evc.substring(1);
				// if( notFireCols ) { notFireCols += ","; }
				if( notFireCols == null ) { notFireCols = ","; }	// 5.10.27.0 (2021/01/05)
				notFireCols += evc;
				notFireCols += ","; 								// 5.10.27.0 (2021/01/05)
			}
			cCols = colMap[evc];
			if( !cCols ) { cCols = new Array(); }
			cCols[cCols.length] = EC_NAME[i];
			colMap[evc] = cCols;
		}
	}
}

/**
 * 親カラムに対してクラスを付加します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
**/
function addEvColCls() {
	for( var evCol in colMap ) {
		$("#"+evCol+",[id^="+evCol+"__]").addClass("h_evCol");
	}
}

/**
 * イベントカラムが設定されたタグ(spanタグ)を検索し、親カラムにイベントを登録します。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 新規作成(動的プルダウン実装見直し)
 * @og.rev 5.10.27.0 (2021/01/05) notFireColsの判定修正
 *
 * @param evCol	イベントが発生した親カラムのオブジェクト
**/
function makeColumn( evCol ) {
	var jEvCol , evColId , evColName , cColNameArr , i , suffix , cid , cname , jTag , writable ;

	if( jH_evElm && isEndInitEvent() ) { jH_evElm = null; }

	jEvCol = $( evCol );
	evColId = jEvCol.attr("id");
	evColName = evColId.split("__")[0];

	cColNameArr = colMap[evColName];
	if( !cColNameArr ) { return; }

	// イベントカラムでカラム名の頭文字が'_'で始まっている場合、初回イベント発行を行わない。
//	if( !isEndInitEvent() && notFireCols && notFireCols.indexOf( evColName ) >= 0 ) { return; }
	if( !isEndInitEvent() && notFireCols && notFireCols.indexOf( ","+evColName+"," ) >= 0 ) { return; } // 5.10.27.0 (2021/01/05)

	for( i=0; i<cColNameArr.length; i++ ) {
		suffix = ( evColId == evColName ? "" : "__" + evColId.split("__")[1] );
		cid = cColNameArr[i]+suffix;
		cname = cid.split("__")[0];
		jTag = isEndInitEvent() ? $( ".h_evElm[h_evCid="+cid+"]" ) : jH_evElm.filter( "[h_evCid="+cid+"]" );
		writable = jTag.attr("h_evWrtbl");
		eventColumn( jEvCol, jTag, cid, cname, suffix, writable );
	}
}

/**
 * Ajax動的カラム変更用の共通JavaScript
 *
 * カラムにeventColumnをセットした時に親側にID指定でChangeイベントとして登録されます。
 * ※イベント処理用のJSP用に送られるパラメーターに関しては、jsp/common/eventColumnMaker.jspの
 *	 コメントを参照して下さい。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
 * @og.rev 5.5.4.0 (2012/07/02) suffixが存在すればSLABEL利用を標準にする。eventCallbackの動作追加
 * @og.rev 5.6.2.0 (2013/03/01) jQueryのval()がリセット後のプルダウンから取得できないのでvlaueで取る
 * @og.rev 5.6.4.2 (2013/05/17) エラー表示の alertメッセージに、発生元が分かるように、 cname を追加します。
 * @og.rev 6.3.3.0 (2015/07/25) eventValue 追加
 * @og.rev 5.9.4.6 (2016/01/29) multiple対応
 * @og.rev 5.9.28.1 (2018/01/19) {@xxx}が存在しない場合でも処理が流れるように対応
 * @og.rev 5.10.4.0 (2018/10/05) eventColumnのparam暗号化対応
 * @og.rev 7.0.2.2 (2019/03/25) eventColumnが動作しない(問合・ﾄﾗﾌﾞﾙ 61200-190319-01)
 *
 * @param jEvCol	イベントが発生した親カラムのjQueryオブジェクト
 * @param jTag		置き換え要素をラップしたspanタグのjQueryオブジェクト
 * @param cid		変更対象の子要素(inputタグなど)のID
 * @param cname		子のカラム名
 * @param suffix	__ + 行番号(一覧表示の場合のみ)
 * @param writable	書き込み可能かどうか
**/
function eventColumn( jEvCol, jTag, cid, cname, suffix, writable ){
	var evVal , url , param , _pos1 , _pos2 , _repClm, _rep, _clm , noVal , columnFocus , jCol , val , renderer , editor , ATTRS , optAttrs , i , optAtt , vtype , isAdd ;
	var callback; // 5.5.4.0 (2012/07/02)
	var keys, keysList, flgEncrypt;	// 5.10.4.0 (2018/10/05)
	var obj = {}; // 5.10.4.0 (2018/10/05)

	if( !jTag || jTag.length == 0 ) {
//		alert( "[SYSTEM_ERROR] : イベントカラムで置き換え対象の要素が存在しません" );
		alert( "[SYSTEM_ERROR] : jTag is null. The element of the replacement object doesn't exist. [" + cname + "]" );		// 5.6.4.2 (2013/05/17) cname 追加
		return;
	}

//	if( cid == null || cid == "" || cname == null || cname == "" ) {
//		alert( "[SYSTEM_ERROR] : 子要素のIDまたはNAMEがセットされていません" );
//		return;
//	}

	if( !isEndInitEvent() ) {
//		evVal = jEvCol.val();
		evVal = jEvCol.get(0).value; //2013/03/01
		if( !evVal || evVal == null || evVal == "" ) { return; }
	}

	try {
		url = eval( "EC_" + cname + "_URL" );
	}
	catch( e ) {
//		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。(変数未定義)" );
		alert( "[SYSTEM_ERROR] : URL that processes the event is not specified. (variable undefinition). [" + cname + "]" );		// 5.6.4.2 (2013/05/17) cname 追加
		return;
	}
	if( !url || url == "" ) {
//		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。" );
		alert( "[SYSTEM_ERROR] : URL that processes the event is not specified. [" + cname + "]" );		// 5.6.4.2 (2013/05/17) cname 追加
		return;
	}

	// SQL文をパースして{@xxx}をxxxのvalue値に変更する。一覧での利用では同一行のカラムになる。
	//（リクエスト変数はテキストボックスやhiddenで一度受ける必要がある）
	// 又、パースして得られたvalue値をJSPのリクエスト変数としてURLの後ろに付ける
	// 5.9.28.1 なお、存在しない場合はnullで返すようにする。
	param = "";
	try { param = ( writable ? eval( "EC_" + cname + "_EDITPARAM" ) : eval( "EC_" + cname + "_RENDPARAM" ) ); } catch( e ) {}

	// 5.10.4.0 (2018/10/05)
	try{ keys = ( writable ? eval( "EC_" + cname + "_EDITPARAMKEYS") : eval( "EC_" + cname + "_RENDPARAMKEYS" ) ); } catch( e ){}
	flgEncrypt = eval( "EC_" + cname + "_FLGENCRYPT");

	// sqlの暗号化が行われている場合(値の変換はajaxの受信側で行う)
	if(flgEncrypt === 'true'){
		if(keys){
			keysList = keys.split(',');
			for(var i = 0; i < keysList.length; i++){
				var key = keysList[i];
				var val = suffix == "" ? $('#' + key).get(0).value : $('#'+key+suffix).get(0).value;
				obj[key] = val;
			}
		}
	// sqlの暗号化が行われていない場合
	}else{
		if( param != null && param != "" ) {
			url += "?";
			_pos1 = 0;
			_pos2 = 0;
			while( (_pos1 = param.indexOf("{@",_pos2)) != -1){
				_pos2 = param.indexOf("}",_pos1);
				_clm = param.substring(_pos1+2,_pos2);
				if( _clm.indexOf(".") < 0 ) {
					_repClm = "{@"+_clm+"}";
	//				_rep = suffix == "" ? $('#'+_clm).val() : $('#'+_clm+suffix).val();
	//				_rep = suffix == "" ? $('#'+_clm).get(0).value : $('#'+_clm+suffix).get(0).value;  // 2013/03/01
					var rtnNull = function(){ console.log("noDifined:"); console.log(arguments[0]); return null; };
					_rep = suffix == "" ? $('#'+_clm)[0] ? $('#'+_clm).get(0).value : rtnNull(_clm)
										: $('#'+_clm+suffix)[0] ? $('#'+_clm+suffix).get(0).value : rtnNull(_clm+suffix);  // 5.9.28.1 (2018/01/19)
					_rep = ( _rep == null ? "" : _rep );
					param = param.replace(_repClm,_rep);
					url += _clm + "=" +  encodeURIComponent(_rep) +"&";
				}
				_pos2 = _pos1+1; // 4.3.6.2 (2009/04/15)
			}
		}
	}

	// 6.3.3.0 (2015/07/25) eventValue 追加
	valsql = "";
	try { valsql = eval( "EC_" + cname + "_VALSQL" ); } catch( e ) {}
	if( valsql != null && valsql != "" ) {
//		url += "?";
		_pos1 = 0;
		_pos2 = 0;
		while( (_pos1 = valsql.indexOf("{@",_pos2)) != -1){
			_pos2 = valsql.indexOf("}",_pos1);
			_clm = valsql.substring(_pos1+2,_pos2);
			if( _clm.indexOf(".") < 0 ) {
				_repClm = "{@"+_clm+"}";
//				_rep = suffix == "" ? $('#'+_clm).val() : $('#'+_clm+suffix).val();
				_rep = suffix == "" ? $('#'+_clm).get(0).value : $('#'+_clm+suffix).get(0).value;  // 2013/03/01
				_rep = ( _rep == null ? "" : _rep );
				valsql = valsql.replace(_repClm,_rep);
//				url += _clm + "=" +  encodeURIComponent(_rep) +"&";
			}
			_pos2 = _pos1+1; // 4.3.6.2 (2009/04/15)
		}
	}

	// 子がSelectタグの場合、最上部に空のoptionが存在すればEC_NOVALUEをtrueで送る
	noVal = function(){
		_firstOption = jCol.children('option').get(0);
		if( _firstOption == null || _firstOption.value != "" ){ return false; }
		return true;
	};

	// 4.3.6.5 (2009/05/08) must,mustAnyを引数でJSPに送る。
//	var mustOrMustAny = function(){
//		var _haveClasses = jCol.attr("class");
//		if( _haveClasses && _haveClasses.indexOf("must") >= 0 ){
//			if( _haveClasses.indexOf("mustAny") >= 0 )	{ return "mustAny"; }
//			else										{ return "must"; }
//			return "";
//		}
//	}

	columnFocus = function() {
		jCol.attr("isfocus","true");
	};

//	var jCol;
	if( cid != null && cid != "" ) {
		jCol = jTag.find( "#"+cid );
	}
	else {
		jCol = new Array(0);
	}

	if( jCol.length > 0 && isEndInitEvent() ) {
		jCol.bind("focus",columnFocus);
	}

	val = "";
	if( jCol.length > 0 ) {
		if( isEndInitEvent() )	{ val = ( jCol.val() == null ? "" : jCol.val() ); }
		else					{ val = ( jTag.attr( "h_evVal" ) == null ? "" : jTag.attr( "h_evVal" ) ); }
	}

	renderer = "";
	try { renderer = eval( "EC_" + cname + "_RENDERER" ); } catch( e ) {}

	editor = "";
	try { editor = eval( "EC_" + cname + "_EDITOR" ); } catch( e ) {}

	// 5.2.0.0 (2010/09/01) 属性値が正しく引き継がれないバグを修正
	ATTRS = [ "title", "style", "tabindex", "readonly", "disabled"
				, "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp"
				, "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup"
				, "eventCallBack" // 5.5.4.0 (2012/07/02)
				, "multiple" // 5.9.4.5 (2016/01/29)
			 ];
	optAttrs = "";
	if( jCol.length > 0 ) {
		for( i=0; i<ATTRS.length; i++ ) {
			optAtt = jCol.attr(ATTRS[i]);
			if( optAtt != null ) {
				vtype = typeof( optAtt );
				isAdd = false;
				if( vtype == "function" ) {
					optAtt = optAtt.toString();
					isAdd = optAtt.length > 0 ? true : false;
					// 関数の場合は、文字列表現として"function anonymous(){...}"という関数定義が返るため、
					// ( FUNCTION )(); 形式で関数を実行するように変更
					optAtt = "(" + optAtt + ")()";
				}
				else if( vtype == "boolean" ) {
					isAdd = optAtt;
				}
				else {
					isAdd = optAtt.length > 0 ? true : false;
				}

				if( isAdd ) {
					optAttrs += ATTRS[i] + "='" + optAtt + "' ";
				}
			}
		}
	}

	// 5.10.4.0 (2018/10/05) ADD objにEC_XXXの情報を設定する
	obj.EC_CID		= ( cid == null ? "" : cid );
	obj.EC_CNAME	= ( cname == null ? "" : cname );
	obj.EC_RENDERER	= renderer;
	obj.EC_EDITOR	= editor;
	obj.EC_PARAM	= param;
	obj.EC_SQL		= param;
	obj.EC_WRITABLE	= ( writable == null ? "" : writable );
	obj.EC_CVALUE	= val;
	obj.EC_NOVALUE	= ( jCol.length == 0 ? "" : noVal() );
	obj.EC_CLASS	= ( jCol.length == 0 ? "" : jCol.attr("class") );
	obj.EC_SIZE		= ( jCol.length == 0 ? "" : jCol.attr("size") );
	obj.EC_MAXLENGTH= ( jCol.length == 0 ? "" : jCol.attr("maxlength") );
	obj.EC_OPTATTRS	= optAttrs;
	obj.EC_PNAME	= jEvCol.attr("id") == null ? "" : jEvCol.attr("id").split("__")[0];
	obj.EC_PVALUE	= jEvCol.get(0).value == null ? "" : jEvCol.get(0).value; // 5.6.2.0 (2013/03/01)
	obj.EC_USESLBL	= (suffix == null || suffix == "") ? "false" : "true"; // 5.5.4.0 (2012/07/02)

	// JSPを呼び出して処理する
	$.ajax({
		url: url,
//		data: {
//			"EC_CID"		: ( cid == null ? "" : cid ),
//			"EC_CNAME"		: ( cname == null ? "" : cname ),
//			"EC_RENDERER"	: renderer,
//			"EC_EDITOR"		: editor,
//			"EC_PARAM"		: param,
//			"EC_SQL"		: param,
//			"EC_VALSQL"		: valsql,		// 6.3.3.0 (2015/07/25)
//			"EC_WRITABLE"	: ( writable == null ? "" : writable ),
//			"EC_CVALUE"		: val,
//			"EC_NOVALUE"	: ( jCol.length == 0 ? "" : noVal() ),
////			"EC_MUST"		: ( jCol.length == 0 ? "" : mustOrMustAny() ),
//			"EC_CLASS"		: ( jCol.length == 0 ? "" : jCol.attr("class") ),
//			"EC_SIZE"		: ( jCol.length == 0 ? "" : jCol.attr("size") ),
//			"EC_MAXLENGTH"	: ( jCol.length == 0 ? "" : jCol.attr("maxlength") ),
//			"EC_OPTATTRS"	: optAttrs,
//			"EC_PNAME"		: jEvCol.attr("id") == null ? "" : jEvCol.attr("id").split("__")[0],
////			"EC_PVALUE"		: jEvCol.val() == null ? "" : jEvCol.val(),
//			"EC_PVALUE"		: jEvCol.get(0).value == null ? "" : jEvCol.get(0).value, // 5.6.2.0 (2013/03/01)
//			"EC_USESLBL"	: (suffix == null || suffix == "") ? "false" : "true" // 5.5.4.0 (2012/07/02)
//		},
		data: obj,
		type: 'POST',
		dataType: 'html',
		async : isEndInitEvent(),
		error: function(r,s,e){
			// 5.6.4.2 (2013/05/17) 紙芝居作成時は、url が存在しないエラーが発生するので、無視する。(htm呼び出し時は無視)
			if( url.indexOf( ".htm" ) < 0 ) {
				alert('EventColumnError:'+r+':'+s+':'+e+':'+cname);
			}
		},
		success: function(data,status){
			var jNewCol = $(data);

			if( jCol.length > 0 ) {
				if( isEndInitEvent() ) {
					jCol.unbind("focus",columnFocus);
				}
				// 7.0.2.2 (2019/03/25) eventColumnが動作しない(問合・ﾄﾗﾌﾞﾙ 61200-190319-01)
//				bindOldEvents( jNewCol.get(0), jQuery.data( jCol.clone(true).get(0),"events" ) );
				bindOldEvents( jNewCol.get(0), jQuery._data(jCol.clone(true).get(0)).events );			// 7.0.2.2 (2019/03/25)
			}

			jTag.empty().append( jNewCol );

			if( jCol.length > 0 ) {
				jTag.find("input,select,textarea").attr( "name", cid ).attr( "id", cid );

				if( isEndInitEvent() ) {
					// 置き換え先の要素にフォーカスが当たっていた場合は、フォーカスを復活
					if( jCol.attr("isfocus") ) {
//						jNewCol.focus();
						jNewCol.get(0).focus();
						// IEの場合、置き換え先の要素がテキストボックスの場合は、もう１度フォーカスする必要がある。
						if( $.browser.msie ) {
							jNewCol.get(0).focus();
						}
					}
				}
				// 初回読み込み時に置き換えられた要素はchangeイベントを発行
				if( !isEndInitEvent() ) {
					jNewCol.change();
				}
				// 5.5.4.0 (2012/07/02) callBack処理
				// 置き換え先にeventCallback属性が存在した場合にevalして関数評価した上で、子idと値を引数に渡す。
				if( jCol.attr("eventCallback") ){
					callback = function(){ eval(jCol.attr("eventCallback") + "(arguments);") };
//					callback(cid,jNewCol.val(),jCol.val());
					callback(cid,jNewCol.val(),jCol.get(0).value); // 2013/03/01
				}
			}

			// ヘッダー固定再計算
			if( suffix != null && suffix != "" ) {
				if( isEndInitEvent() ) {
					$('table#viewTable').resizeView();
				}
			}
		}
	});
}

function bindOldEvents( newCol, oldEvents ) {
	var type , handler ;
	for ( type in oldEvents ) {
		for ( handler in oldEvents[type] ) {
			jQuery.event.add( newCol, type, oldEvents[type][handler], oldEvents[type][handler].data );
		}
	}
}

/********************************************************************************************/
/* 旧 realTimeCheck.js の内容を移植 5.2.1.0 (2010/10/01)									*/
/*																							*/
/* 入力欄の簡易チェック(リアルタイム)														*/
/* DBTYPE に応じた簡易チェックを行います。あくまで簡易的なチェックです。					*/
/* 大文字小文字などは、JavaScriptで変換できる為、チェックは行いません。 					*/
/*																							*/
/* @og.rev 4.3.3.0 (2008/10/01) サーバーサイドのリアルタイムチェック対応					*/
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)								*/
/* @og.rev 4.3.6.6 (2009/05/15) bodyに追加し、いつも上に表示								*/
/* @og.rev 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。*/
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる				*/
/* @og.rev 5.2.1.0 (2010/10/01) h_ で始まる内部設定フィールドはチェックしない。 			*/
/* @og.rev 5.3.7.0 (2011/07/01) 入力項目が上方にある場合は、下にチェックチップを表示する。	*/
/* @og.rev 5.4.4.0 (2012/02/01) rtOption対応												*/
/* @og.rev 6.3.6.1 (2015/08/28) ../common/*** の相対パスを絶対パスに変更					*/
/* @og.rev 5.9.32.2 (2018/05/18) :not(.noRealTime)											*/
/* Revision: $Id$																			*/
/********************************************************************************************/
var isShowTip = false;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ check( this, '../common/realtimecheck.jsp' ); } );
	if(USE_REAL_TIME_CHECK){	//5.4.5.0 flag add
//		setEvent( "textarea,select,input[type=\"text\"]" , "focusout" ,
	//	setEvent( "textarea:not(.noRealTime),select:not(.noRealTime),input[type=\"text\"]:not(.noRealTime)" , "focusout" ,	// 5.9.32.2 noRealTime 属性にした場合
		setEvent( "textarea:not([realTimeChk=\"false\"]),select:not([realTimeChk=\"false\"]),input[type=\"text\"]:not([realTimeChk=\"false\"])" , "focusout" ,	// 5.9.32.2
					// 6.3.6.1 (2015/08/28) ../common/*** の相対パスを絶対パスに変更
//					function(){ check( this, '../common/realtimecheck.jsp' ); } );
					function(){
						var obj=RegExp( /jsp/ );
						var tmp = location.pathname.match( obj );
						// RegExp.leftContext : 最期に一致した文字列より前の文字列を取得(/gf/)
						check( this, RegExp.leftContext + 'jsp/common/realtimecheck.jsp' );
					} );

		// 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。
		$('table#viewTable').parent().parent().scroll( function () {
			if( isShowTip ) { isShowTip = false; $(".tipErr").remove(); }
		});
	}
});

function check( obj, sUrl ) {
	var sFullFN , val , arrFName , bTMCheck , sParam , ajaxSettings , tipId, rtoption ;

	sFullFN = obj.name;
//	var cls = obj.className;
//	var msg = null;
	// 6.0.4.1 (2014/12/26) リアルタイムチェックを外す方法。今は、サンプルのみ記載します。
//	if( !obj.id ) { return true; }								// ①id 属性の有無で判定
//	if( obj.getAttribute("rtc") == "false" ) { return true; }	// ②rtc という独自属性で判定。

	if (typeof jQuery != "undefined" && sFullFN.indexOf( "h_" ) != 0 ) {
		val = obj.value;
		if( obj.rtOption != "null" && obj.rtOption != "undefined"){
//			rtoption = obj.rtOption; // 5.4.4.0
			rtoption = obj.getAttribute("rtOption"); // 5.9.24.2
		}
		arrFName = sFullFN.split('__');
		bTMCheck = (2 == arrFName.length);
//		var sParam = "command=RTCHECK&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" );
		sParam = "command=RENEW&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" ) // 4.3.4.0 (2008/12/01)
				   + ( bTMCheck ? "&h_rowSel=" + arrFName[1] : "" )
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + val;
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURI( val ); // 4.3.4.0 (2008/12/01)
				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURIComponent( val ) // 5.2.0.0 (2010/09/01)
				   + (rtoption ? "&" + rtoption : ""); // 5.4.4.0 (2012/02/01)
		ajaxSettings = {
				dataType : 'html',
				type	 : 'POST',
				url		 : sUrl,
				data	 : sParam
		};

		ajaxSettings.error = function() {};
		ajaxSettings.success = function(data) {
			//Remove old msg
//			var sOutId = getTipId(obj);
//			$("#" + sOutId).remove();
			tipId = $(obj).data( "tipId" );
			$("#" + tipId).remove();

			if( $.trim(data).indexOf("row_error") >= 0 ) {
				showCheckTip( obj, data );
				isShowTip = true;
			}
		};
		$.ajax(ajaxSettings);
	}

	return true;
}

/* Revised From jTip Plug-in of jQuery */
function showCheckTip( oEditOut, content ) {
//	var jEditOut , hEditOffset , sJtDiv , jJtDiv , clickElementx , clickElementy , tipId ;
	var jEditOut , hEditOffset , iTipOffset , sArrowId , sJtDiv , jJtDiv , clickElementx , clickElementy , tipId ;

	jEditOut = $(oEditOut);
	hEditOffset = jEditOut.offset();

	// 5.3.7.0 (2011/07/01) 上に表示する場合
	if( hEditOffset.top >= 30 ) {
		sJtDiv = "<div class='tipErr'><div id='tipArrowBottom'></div><div>" + content + "</div></div>";
		jJtDiv = $(sJtDiv).appendTo(document.body);
		//set x position
		clickElementx = hEditOffset.left;
		//set y position
		clickElementy = hEditOffset.top + (-11 - jJtDiv[0].offsetHeight);
	}
	// 5.3.7.0 (2011/07/01) 下に表示する場合
	else {
		sJtDiv = "<div class='tipErr'><div id='tipArrowTop'></div><div>" + content + "</div></div>";
		jJtDiv = $(sJtDiv).appendTo(document.body);
		//set x position
		clickElementx = hEditOffset.left;
		//set y position
		clickElementy = hEditOffset.top + 11 + jJtDiv[0].offsetHeight;
	}

	tipId = (new Date()).getTime();
	$(oEditOut).data( "tipId", tipId );

	jJtDiv.css( { left: clickElementx+"px", top: clickElementy+"px" } )
			.attr( 'id', tipId )
			.click( function() { $(this).remove(); } )
			.show();
}

//function getTipId(oEdit) {
//	return "JT" + $.data(oEdit);
//}

/********************************************************************************************/
/* 旧 bindEvents.js の内容を移植 5.2.1.0 (2010/10/01)										*/
/*																							*/
/* 各JavaScriptで登録されたイベント(主にカラムに割り当てられたイベント)を					*/
/* 実際のイベントハンドラにバインドします。 												*/
/*																							*/
/* @og.rev 5.2.0.0 (2010/09/01) 新規作成													*/
/* Revision: $Id$																			*/
/********************************************************************************************/
$(function(){
	bindEvents();
});


/********************************************************************************************/
/* カラーピッカー 5.5.4.0 (2012/07/02)														*/
/*																							*/
/* カラーピッカーです。 																	*/
/* http://rachel-carvalho.github.io/simple-color-picker/									*/
/* input.colorPickerに対して実行させます													*/
/*																							*/
/* @og.rev 5.5.4.0 (2012/07/02) 新規作成													*/
/* @og.rev 5.5.6.1 (2013/01/11) 名称変更(Og付加)											*/
/* @og.rev 5.9.4.0 (2016/01/08) clear対応													*/
/* @og.rev 5.9.8.3 (2016/05/20) bulk対応													*/
/* @og.rev 7.0.1.0 (2018/10/15) jQuery1.9 以降は、live が廃止(live → on)					*/
/* Revision: $Id$																			*/
/********************************************************************************************/
$.fn.simpleColorPickerOg = function(options) {
	var defaults = {
		colorsPerLine: 8,
		colors: ['#000000', '#444444', '#666666', '#999999', '#cccccc', '#eeeeee', '#f3f3f3', '#ffffff'
				, '#ff0000', '#ff9900', '#ffff00', '#00ff00', '#00ffff', '#0000ff', '#9900ff', '#ff00ff'
				, '#f4cccc', '#fce5cd', '#fff2cc', '#d9ead3', '#d0e0e3', '#cfe2f3', '#d9d2e9', '#ead1dc'
				, '#ea9999', '#f9cb9c', '#ffe599', '#b6d7a8', '#a2c4c9', '#9fc5e8', '#b4a7d6', '#d5a6bd'
				, '#e06666', '#f6b26b', '#ffd966', '#93c47d', '#76a5af', '#6fa8dc', '#8e7cc3', '#c27ba0'
				, '#cc0000', '#e69138', '#f1c232', '#6aa84f', '#45818e', '#3d85c6', '#674ea7', '#a64d79'
				, '#990000', '#b45f06', '#bf9000', '#38761d', '#134f5c', '#0b5394', '#351c75', '#741b47'
				, '#660000', '#783f04', '#7f6000', '#274e13', '#0c343d', '#073763', '#20124d', '#4C1130'],
		showEffect: '',
		hideEffect: '',
		onChangeColor: false
	};

	var opts = $.extend(defaults, options);

	return this.each(function() {
		var txt = $(this);

		var colorsMarkup = '';

		var prefix = txt.attr('id').replace(/-/g, '') + '_';

		for(var i = 0; i < opts.colors.length; i++){
			var item = opts.colors[i];

			var breakLine = '';
			if (i % opts.colorsPerLine == 0)
				breakLine = 'clear: both; ';

			if (i > 0 && breakLine && $.browser && $.browser.msie && $.browser.version <= 7) {
				breakLine = '';
				colorsMarkup += '<li style="float: none; clear: both; overflow: hidden; background-color: #fff; display: block; height: 1px; line-height: 1px; font-size: 1px; margin-bottom: -2px;"></li>';
			}

			colorsMarkup += '<li id="' + prefix + 'color-' + i + '" class="color-box" style="' + breakLine + 'background-color: ' + item + '" title="' + item + '"></li>';
		}
		breakLine = 'clear: both; ';
		// 5.9.4.0	clear
		colorsMarkup += '<li id="' + prefix + 'color-default' + '" class="color-box" style="width:80px; text-align:center; ' + breakLine +	'background-color:white;" title="clear">clear</li>';

		var box = $('<div id="' + prefix + 'color-picker" class="color-picker" style="position: absolute; left: 0px; top: 0px;"><ul>' + colorsMarkup + '</ul><div style="clear: both;"></div></div>');
		$('body').append(box);
		box.hide();

		box.find('li.color-box').click(function() {
			var sel_val = isNaN(this.id.substr(this.id.indexOf('-') + 1)) ? "": opts.colors[this.id.substr(this.id.indexOf('-') + 1)]; // 5.9.4.0

			if (!txt.is('input')) {
//			  txt.val(opts.colors[this.id.substr(this.id.indexOf('-') + 1)]);
			  txt.val(sel_val);
			  txt.blur();
			}
			if ($.isFunction(defaults.onChangeColor)) {
//			  defaults.onChangeColor.call(txt, opts.colors[this.id.substr(this.id.indexOf('-') + 1)]);
			  defaults.onChangeColor.call(txt, sel_val);
			}
			hideBox(box);
		});

//		$('body').live('click', function() {		// jquery-1.12系
		$('body').on('click', function() {			// 7.0.1.0 (2018/10/15) jQuery1.9 以降は、live が廃止
			hideBox(box);
		});

		box.click(function(event) {
			event.stopPropagation();
		});

		var positionAndShowBox = function(box) {
		  var pos = txt.offset();
		  var left = pos.left + txt.outerWidth() - box.outerWidth();
		  if (left < pos.left) left = pos.left;
		  box.css({ left: left, top: (pos.top + txt.outerHeight()) });
		  showBox(box);
		}

		txt.click(function(event) {
          txt = $(this); // 5.9.8.3 (2016/05/20) クリックした際にthisを再セットする（Bulk対応）
		  event.stopPropagation();
		  if (!txt.is('input')) {
			// element is not an input so probably a link or div which requires the color box to be shown
			positionAndShowBox(box);
		  }
		});

		txt.focus(function() {
		  positionAndShowBox(box);
		});

		// 5.9.8.3 (2016/05/20) 外部から変更された場合に、色を変更する。
        txt.change( function(event){
          if( txt.val() != txt.css('background-color')){
	          txt.css('background-color', txt.val()) .css('color',txt.val());
	        }
        });

		function hideBox(box) {
			if (opts.hideEffect == 'fade')
				box.fadeOut();
			else if (opts.hideEffect == 'slide')
				box.slideUp();
			else
				box.hide();
		}

		function showBox(box) {
			if (opts.showEffect == 'fade')
				box.fadeIn();
			else if (opts.showEffect == 'slide')
				box.slideDown();
			else
				box.show();
		}
	});
};

// カラーピッカーの対象はinput.colorPicker
$(function(){
	// 5.5.6.1 (2013/01/11) jQueryの上書き時エラー対策にif文挿入（上書きされると動作しない）
	// 5.9.4.0 (2016/01/08) backgroundではなくbackground-colorにする
	// 5.9.8.3 (2016/05/20) change追加
	if($.fn.simpleColorPickerOg){
//		$('input.colorPicker').simpleColorPickerOg({ onChangeColor: function(color) { $(this).val(color).css('background',color).css('color',color); } });
//		$('input.colorPicker').simpleColorPickerOg({ onChangeColor: function(color) { $(this).val(color).css('background-color', color) .css('color',color); } });
		$('input.colorPicker').simpleColorPickerOg({ onChangeColor: function(color) { $(this).val(color).css('background-color', color) .css('color',color).change(); } });
	}
});

/********************************************************************************************
時間ピッカー 5.6.5.2 (2013/06/21)
ClockPick, by Josh Nathanson
Version 1.2.9 and Masakazu Takahasi Modified
Complete documentation at http://www.jnathanson.com/index.cfm?page=jquery/clockpick/ClockPick

以下を、対象タグの属性値から取得可能なように改造
param	 options[starthour] 	  int					  starting hour (use military int)
param	 options[endhour]		  int					  ending hour (use military int)
param 	 options[minutedivisions] int					  number of divisions, i.e. 4 = :00, :15, :30, :45
param 	 options[military]		  string				  use 24hr time if true(true/false)
param	 options[valuefield]	  string				  field to insert time value, if not same as click field(name of input field)
param	 options[showminutes]	  bool					  show minutes
param	 options[second]		  bool					  add second(00)  // 5.9.12.3
param	 options[layout]		  string				  vertical or horizon  //5.9.17.2

又、対象単位に設定値を持てるように対応。
@og.rev 5.9.8.3 (2016/05/20) 標準をAMPMではなく24時間表記に変更、ピッカー選択時にchangeイベント発生させる
@og.rev 5.9.12.3 (2015/09/23) 返す値に秒(00固定)を追加出来るようにする(useSecond)
@og.rev 5.9.15.1 (2016/12/09) 数値変換不具合対応
@og.rev 5.9.17.2 (2017/02/15) layout指定追加
@og.rev 5.9.27.3 (2017/12/22) 選択時間を幅広く取れるように変更、及び方向キー対応
********************************************************************************************/

jQuery.fn.ogClockpicker = function(options, callback) {

	// 5.9.12.3 (2016/09/23)
	var org_settings = {
		starthour		: 6,
		endhour 		: 20,
		showminutes 	: "true",
		minutedivisions : 4,
		military		: true,				// 5.9.8.3 (2016/05/20)
		event			: 'click',
		layout			: 'vertical',
		valuefield		: null,
		useBgiframe		: false,
		hoursopacity	: 1,
		minutesopacity	: 1,
		second			: ""				// 5.9.12.3 (2015/09/23)
		};

	if(options) {
		jQuery.extend(org_settings, options);
	};

	var callback = callback || function() { },
	 	v = (org_settings.layout == 'vertical'); // boolean for vertical, shorten footprint
	errorcheck(org_settings);


	jQuery(this)[org_settings.event](function(e) {
		var self = this,
		$self = jQuery( this ),
		$body = jQuery( "body" );
		var settings = jQuery.extend(true,{},org_settings); // OpenGion deep copy

		// OpenGion 属性対応
		if( $self.attr('valuefield') ){
			settings.valuefield = $self.attr('valuefield');
		}
		if( $self.attr('starthour') ){
//			settings.starthour = $self.attr('starthour');
			settings.starthour = parseInt($self.attr('starthour')); // 5.9.15.1 (2016/12/09)
		}
		if( $self.attr('endhour') ){
//			settings.endhour = $self.attr('endhour');
			settings.endhour = parseInt($self.attr('endhour')); // 5.9.15.1 (2016/12/09)
		}
		if( $self.attr('minutedivisions') ){
//			settings.minutedivisions = $self.attr('minutedivisions');
			settings.minutedivisions = parseInt($self.attr('minutedivisions'));
		}
		if( $self.attr('military') ){
			settings.military = $self.attr('military');
		}
		if( $self.attr('showminutes') ){
			settings.showminutes = $self.attr('showminutes');
		}
		if( $self.attr('usesecond') == "true" ){ // 5.9.12.3 (2016/09/23)
			settings.second = "00";
		}
		if( $self.attr('layout') ){ // 5.9.17.2 (2017/02/17)
			settings.layout = $self.attr('layout');
			org_settings.layout = settings.layout; // overwrite
			v = (settings.layout == 'vertical');
		}

		errorcheck(settings);

		if ( !settings.valuefield ) {
			$self.unbind( "keydown" ).bind( "keydown", keyhandler );
		}
		else {
			var inputfield = jQuery("[name=" + settings.valuefield + "]");
			inputfield
				.unbind( "keydown" )
				.bind( "keydown", keyhandler)[0]
				.focus();
			inputfield
				.bind("click", function() { inputfield.unbind("keydown"); } );
		}
		// clear any malingerers
		jQuery("#CP_hourcont,#CP_minutecont").remove();

		// append hourcont to body
		// add class "CP" for mouseout recognition, although there is only
		// one hourcont on the screen at a time
		var $hourcont = jQuery("<div id='CP_hourcont' class='CP' />").appendTo( $body );
		!settings.useBgiframe ? $hourcont.css("opacity",settings.hoursopacity) : null;
		binder( $hourcont );

		// 5.9.27.3 (2017/12/22) 多数に対応させるため配列に代入
		var $hourcol = [];
		for(var i=0;i<Math.floor(settings.endhour/12)-Math.floor(settings.starthour/12)+1;i++){
			$hourcol.push(jQuery("<div class='CP_hourcol' id='hourcol"+i+"' />").appendTo( $body ));
		}

//		var $hourcol1 = jQuery("<div class='CP_hourcol' id='hourcol1' />").appendTo( $body );
//		var $hourcol2 = jQuery("<div class='CP_hourcol' id='hourcol2' />").appendTo( $body );

		// if showminutes, append minutes cont to body

		if (settings.showminutes == "true") {
			var $mc = jQuery("<div id='CP_minutecont' class='CP' />").appendTo( $body );
			!settings.useBgiframe ? $mc.css("opacity",settings.minutesopacity) : null;
			binder($mc);
		}
		if ( !v ) {
			$hourcont.css("width","auto");
			if (settings.showminutes == "true") {
				$mc.css("width","auto");
			}
		}
		else {
			for (i=0;i<$hourcol.length;i++){			// 5.9.27.3 (2017/12/22)
				$hourcol[i].addClass('floatleft');
			}
//			$hourcol1.addClass('floatleft');
//			$hourcol2.addClass('floatleft');
		}

		// all the action right here
		// fill in the hours container (minutes rendered in hour mouseover)
		// then make hour container visible
		renderhours();
		putcontainer();

		/*----------------------helper functions below-------------------------*/

		function renderhours() {
			// fill in the $hourcont div
			var c = 1;
			var numberC = 0; 				// 5.9.27.3 (2017/12/22)
			// counter as index 2 of hr id, gives us index
			// in group of hourdivs for calculating where to put minutecont on keydown
			for (var h=settings.starthour; h<=settings.endhour; h++) {
//				if(h==12) { c = 1; } // reset counter for col 2
				if(h%12==0) { c = 1; } // reset counter for col 2	// 5.9.27.3 (2017/12/22)

				var displayhours = ((!settings.military && h > 12) ? h - 12 : h);
				var valuehouers = h; // opengion
				// rectify zero hour
				if (!settings.military && h == 0) {
					//displayhours = '12'; // 日本向けに0時で表示
				}
				else if (!settings.military && h == 12) {
					displayhours = '0'; // 日本向けに0時で表示
				}
				if ( settings.military && h < 10 ) {
					displayhours = '0' + displayhours;
				}
				if ( h < 10 ){
					valuehouers = '0'+valuehouers;
				}

				var $hd = jQuery("<div class='CP_hour' id='hr_" + h + "_" + c + "' " + "value='" +valuehouers+ "' >" + displayhours + set_tt(h) + "</div>");
				// shrink width a bit if military
				if (settings.military) { $hd.width(20); }
				binder($hd);
				if (!v) {
					$hd.css("float","left");
				}
//				(h<12) ? $hourcol1.append($hd) : $hourcol2.append($hd);
				$hourcol[numberC].append($hd);		// 5.9.27.3 (2017/12/22)
				if((h+1)%12==0){
					numberC++;
				}
				c++;
			}
			// 5.9.27.3 (2017/12/22)
			for(var j=0; j<$hourcol.length;j++){
				if(v){
					if(j!=0&&j%2==0){
						$hourcol[j].css("margin-left",$mc.width()+4 + 'px');
					}
				}else{
					$hourcont.append("<div style='clear:left' />");
					if(j!=0&&j%2==0){
						//$mc.height()が0になってまう？？
						$hourcol[j].css("margin-top","19px");
					}
				}
				$hourcont.append($hourcol[j]);
			}
//			$hourcont.append($hourcol1);
//			!v ? $hourcont.append("<div style='clear:left' />") : '';
//			$hourcont.append($hourcol2);
		}

		function renderminutes( h ) {
			var realhours = h;
			var displayhours = (!settings.military && h > 12) ? h - 12 : h;
			var valuehouers = h; // opengion
			if (!settings.military && h == 0) {
				//displayhours = '12'; // 日本向けに0時で表示
			}
			else if (!settings.military && h == 12) {
				displayhours = '0'; // 日本向けに0時で表示
			}
			if ( settings.military && h < 10 ) {
				displayhours = '0' + displayhours;
			}
			if ( h < 10 ){
				valuehouers = '0'+valuehouers;
			}

			$mc.empty();
			var n = 60 / settings.minutedivisions,
				tt = set_tt(realhours),
				counter = 1;

			for(var m=0;m<60;m=m+n) {
				$md = jQuery("<div class='CP_minute' id='" + realhours + "_" + m + "' value='" + valuehouers + ((m<10) ? "0" : "") + m +"'>"
							 + displayhours + ":" + ((m<10) ? "0" : "") + m + tt
							 + "</div>");
				if ( !v ) {
					$md.css("float","left");
					if (settings.minutedivisions > 6
						&& counter == settings.minutedivisions / 2 + 1) {
						// long horizontal, kick in extra row after half
						$mc.append("<div style='clear:left' />");
					}
				}
				$mc.append($md);
				binder($md);
				counter++;
			}
		}

		function set_tt(realhours) {
			if (!settings.military) {
				return (realhours >= 12) ? ' PM' : ' AM';
				}
			else {
				return '';
			}
		}

		function putcontainer() {
			if ( e.type != 'focus') {
				$hourcont[0].style.left = e.pageX - 5 + 'px';
				$hourcont[0].style.top = e.pageY - (Math.floor($hourcont.height() / 2)) + 'px';
				rectify($hourcont);
			}
			else {
				$self.after($hourcont);
			}
			$hourcont.slideDown('fast');

			if ( settings.useBgiframe )
				bgi( $hourcont );
		}

		function rectify($obj) {
			// if a div is off the screen, move it accordingly
			var ph = document.documentElement.clientHeight
						? document.documentElement.clientHeight
						: document.body.clientHeight;
			var pw = document.documentElement.clientWidth
						? document.documentElement.clientWidth
						: document.body.clientWidth;
			var t = parseInt( $obj[0].style.top );
			var l = parseInt( $obj[0].style.left );
			var st = document.documentElement.scrollTop
						? document.documentElement.scrollTop
						: document.body.scrollTop;
			// run off top
			if ( t <= st && !$obj.is("#CP_minutecont") ) {
				$obj.css("top",st+10+'px');
			}
			else if (t + $obj.height() - st > ph) {
				$obj.css("top",st + ph - $obj.height() - 10 + 'px');
			}
			if ( l <= 0 ) {
				$obj.css("left", '10px');
			}
		}

		function bgi( ob ) {
			if ( typeof jQuery.fn.bgIframe == 'function' )
				ob.bgIframe();
			else
				alert('bgIframe plugin not loaded.');
		}

		function binder($obj) {
		// all the binding is done here
		// event handlers have been abstracted out,
		// so they can handle mouse or key events

			// bindings for hc (hours container)
			if($obj.attr("id") == 'CP_hourcont') {
				$obj.mouseout(function(e) { hourcont_out(e) });
			}

			// bindings for mc (minute container)
			else if ($obj.attr("id") == 'CP_minutecont') {
				$obj.mouseout(function(e) { minutecont_out(e) });
			}

			// bindings for $hd (hour divs)
			else if ($obj.attr("class") == 'CP_hour') {
				$obj.mouseover(function(e) { hourdiv_over($obj, e) });
				$obj.mouseout(function() { hourdiv_out($obj) });
				$obj.click(function() {	hourdiv_click($obj) });
			}

			// bindings for $md (minute divs)
			else if ($obj.attr("class") == 'CP_minute') {
				$obj.mouseover(function() { minutediv_over($obj) });
				$obj.mouseout(function() { minutediv_out($obj) });
				$obj.click(function() {	minutediv_click($obj) });
			}
		};

		function hourcont_out(e) {
			/*
			this tells divs to clear only if rolling all the way
			out of hourcont.
			relatedTarget "looks ahead" to see where the mouse
			has moved to on mouseOut.
			IE uses the more sensible "toElement".
			try/catch for Mozilla bug on relatedTarget-input field.
			*/
			try {
				var t = (e.toElement) ? e.toElement : e.relatedTarget;
				if (!(jQuery(t).is("div[class^=CP], iframe"))) {
					// Safari incorrect mouseover/mouseout
					//if (!jQuery.browser.safari) {
						cleardivs();
					//}
				}
			}
			catch(e) {
				cleardivs();
			}
		}

		function minutecont_out(e) {
			try {
				var t = (e.toElement) ? e.toElement : e.relatedTarget;
				if (!(jQuery(t).is("div[class^=CP], iframe"))) {
					cleardivs();
				}
			}
			catch(e) {
				cleardivs();
			}
		}

		function hourdiv_over($obj, e) {
			var h = $obj.attr("id").split('_')[1],
				i = $obj.attr("id").split('_')[2],
				l,
				t,
				nn;								// 5.9.27.3 (2017/12/22)
			$obj.addClass("CP_over");

			// 5.9.27.3 (2017/12/22) 何個目の要素を見ているか計算して、分表示を配置するための独立変数nnを算出
			nn = Math.ceil((Math.floor(h/12)-Math.floor(settings.starthour/12))/2);

			if ( settings.showminutes == "true") {
				$mc.hide();
				renderminutes(h);

				// set position & show minutes container
				if (v) {
					t = e.type == 'mouseover'
						? e.pageY - 15
						: $hourcont.offset().top + 2 + ($obj.height() * i);
					l = $hourcont.offset().left + $hourcol[0].width()*2*nn + $mc.width()*(nn-1) + 4*nn-2;	// 5.9.27.3 (2017/12/22)
	//				if ( h < 12 )
	//					l = $hourcont.offset().left - $mc.width() - 2;
	//				else
	//					l = $hourcont.offset().left + $hourcont.width() + 2;
				}
				else {
					l = (e.type == 'mouseover')
						? e.pageX - 10
						: $hourcont.offset().left + ($obj.width()-5) * i;
						//$hourcol[0].height()は出ないため全体から各要素を引いて導出
					t = $hourcont.offset().top + ($hourcont.height()-($mc.height()+2)*(Math.ceil($hourcol.length/2)-1))/$hourcol.length*2*nn + $mc.height()*(nn-1) + 2*nn-1;	// (2017/12/19)
	//				if(h<12) {
	//					t = $hourcont.offset().top - $mc.height() - 2;
	//				}
	//				else {
	//					t = $hourcont.offset().top + $hourcont.height();
	//				}
				}
				$mc.css("left",l+'px').css("top",t+'px');
				rectify( $mc );
				$mc.show();

				if ( settings.useBgiframe )
					bgi( $mc );
			}
			return false;
		}



		function hourdiv_out($obj) {
			$obj.removeClass("CP_over");
			return false;
		}

		function hourdiv_click($obj) {
			var h = $obj.attr("id").split('_')[1],
				tt = set_tt(h),
				str = $obj.attr('value');
			if(str.indexOf(' ') != -1) {
				var cleanstr = str.substring(0,str.indexOf(' '));
			}
			else {
				var cleanstr = str;
			}


			//$obj.text(cleanstr + ':00' + tt);
			//$obj.text(cleanstr + '00');
			$obj.text(cleanstr + '00' + settings.second ); // 5.9.12.3 (2016/09/23)
			setval($obj);
			cleardivs();
		}

		function minutediv_over($obj) {
			$obj.addClass("CP_over");
			return false;
		}

		function minutediv_out($obj) {
			$obj.removeClass("CP_over");
			return false;
		}

		function minutediv_click($obj) {
			//$obj.text( $obj.attr('value'));
			$obj.text( $obj.attr('value') + settings.second); // 5.9.12.3 (2016/09/23)
			setval($obj);
			cleardivs();
		}

		function setval($obj) { // takes either hour or minute obj
			if(!settings.valuefield) {
				self.value = $obj.text();
			}
			else {
			//	jQuery("input[name=" + settings.valuefield + "]").val($obj.text());
				jQuery("input[name=" + settings.valuefield + "]").val($obj.text()).change(); // 5.9.8.3 (2016/05/17)
			}
			callback.apply( $self, [ $obj.text() ]);
			// unbind keydown handler, otherwise it will double-bind if
			// field is activated more than once
			$self.unbind( "keydown", keyhandler );
		}

		function cleardivs() {
			if ( settings.showminutes == "true") {
				$mc.hide();
			}
			$hourcont.slideUp('fast');
			$self.unbind( "keydown", keyhandler );
		}

		// keyboard handling

		function keyhandler( e ) {

			// $obj is current active div
			var $obj = $("div.CP_over").size() ? $("div.CP_over") : $("div.CP_hour:first"),
				divtype = $obj.is(".CP_hour") ? 'hour' : 'minute',
				hi = (divtype == 'hour') ? $obj[0].id.split('_')[2] : 0, // hour index
				h = (divtype == 'minute') ? $obj[0].id.split('_')[0] : $obj[0].id.split('_')[1]; // real hour
			// 5.9.27.3 (2017/12/22)
			if (divtype == 'minute') {
				if((Math.floor(h/12)-Math.floor(settings.starthour/12))==0){
					var curloc = 'm1';
				}else if((Math.floor(h/12)-Math.floor(settings.endhour/12))==0&&(Math.floor(h/12)-Math.floor(settings.starthour/12))%2!=0){
					var curloc = 'm2';
				}else{
					var curloc = 'm3';
				}
			}else{
				if((Math.floor(h/12)-Math.floor(settings.starthour/12))%2==0){
					var curloc = 'h1';
				}else{
					var curloc = 'h2';
				}
			}
//			if (divtype == 'minute')
//				{ var curloc = h<12 ? 'm1' : 'm2' }
//			else
//				{ var curloc = h<12 ? 'h1' : 'h2' }

			function divprev($obj) {
				if ($obj.prev().size()) {
					eval(divtype + 'div_out($obj)');
					eval(divtype + 'div_over($obj.prev(), e)');
				}
				else { return false; }
			}

			function divnext($obj) {
				if ($obj.next().size()) {
					eval(divtype + 'div_out($obj)');
					eval(divtype + 'div_over($obj.next(), e)');
				}
				else { return false; }
			}

			function hourtohour($obj) {
				// 5.9.27.3 (2017/12/22)
				if((Math.floor(h/12)-Math.floor(settings.starthour/12))%2==0){
					var next = String((Math.floor(h/12)-Math.floor(settings.starthour/12))+1);
				}else{
					var next = String((Math.floor(h/12)-Math.floor(settings.starthour/12))-1);
				}
				var ctx = '#hourcol'+next;
//				var ctx = h>=12 ? '#hourcol1' : '#hourcol2';
				$newobj = jQuery(".CP_hour[id$=_" + hi + "]", ctx );
				if ($newobj.size()) {
					hourdiv_out($obj);
					hourdiv_over($newobj, e);
				}
				else { return false; }
			}

			function hourtominute($obj) {
				hourdiv_out($obj);
				minutediv_over($(".CP_minute:first"));
			}

//			function minutetohour($obj) {
			function minutetohour($obj,where) {
				minutediv_out($obj);
				// 5.9.27.3 (2017/12/22)
				if(where<0){
					if((Math.floor(h/12)-Math.floor(settings.starthour/12))%2==0){
						var next = String((Math.floor(h/12)-Math.floor(settings.starthour/12))+where);
						h = String(Number(h)-12);
					}else{
						var next = String((Math.floor(h/12)-Math.floor(settings.starthour/12)));
					}
				}else{
					if((Math.floor(h/12)-Math.floor(settings.starthour/12))%2==0){
						var next = String((Math.floor(h/12)-Math.floor(settings.starthour/12)));
					}else{
						var next = String((Math.floor(h/12)-Math.floor(settings.starthour/12))+where);
						h = String(Number(h)+12);
					}
				}
				var ctx = '#hourcol'+next;
				var $newobj = jQuery(".CP_hour[id^=hr_" + h + "]", ctx);
//				var ctx = h>=12 ? '#hourcol2' : '#hourcol1';
				// extract hour from minutediv, then find hourdiv with that hour
				var $newobj = jQuery(".CP_hour[id^=hr_" + h + "]", ctx);
				hourdiv_over($newobj, e);
			}

			switch (e.keyCode) {
				case 37: // left arrow
					if (v) {
						switch (curloc) {
							case 'm1':
								return false;
								break;
							case 'm2':
//								minutetohour($obj);		// 5.9.27.3 (2017/12/22)
								minutetohour($obj,-1);
								break;
							case 'm3':
								minutetohour($obj,-1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'h1':
								hourtominute($obj);
								break;
							case 'h2':
								hourtohour($obj);
								break;
						}
					}
					else {
						divprev($obj);
					}
					break;

				case 38: // up arrow
					if(v) {
						divprev($obj);
					}
					else {
						switch (curloc) {
							case 'm1':
								return false;
								break;
							case 'm2':
//								minutetohour($obj);
								minutetohour($obj,-1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'm3':
								minutetohour($obj,-1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'h1':
								hourtominute($obj);
								break;
							case 'h2':
								hourtohour($obj);
								break;
						}
					}
					break;
				case 39: // right arrow
					if (v) {
						switch (curloc) {
							case 'm1':
//								minutetohour($obj);
								minutetohour($obj,1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'm2':
								return false;
								break;
							case 'm3':
								minutetohour($obj,1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'h1':
								hourtohour($obj);
								break;
							case 'h2':
								hourtominute($obj);
								break;
						}
					}
					else {
						divnext($obj);
					}
					break;

				case 40: // down arrow
					if(v) {
						divnext($obj);
					}
					else {
						switch (curloc) {
							case 'm1':
//								minutetohour($obj);
								minutetohour($obj,1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'm2':
								return false;
								break;
							case 'm3':
								minutetohour($obj,1);	// 5.9.27.3 (2017/12/22)
								break;
							case 'h1':
								hourtohour($obj);
								break;
							case 'h2':
								hourtominute($obj);
								break;
						}
					}
					break;

				case 13: // return
					eval(divtype + 'div_click($obj)');
					break;

				default:
					return true;
			}

		return false;

		}

	return false;
	});

	function errorcheck(settings) {
		if (settings.starthour >= settings.endhour) {
			alert('Error - start hour must be less than end hour.');
			return false;
		}
		else if (60 % settings.minutedivisions != 0) {
			alert('Error - param minutedivisions must divide evenly into 60.');
			return false;
		}
	}

	return this;

}

$(function(){
	if($.fn.ogClockpicker){
		$(document).ready(function(){ $(".clockpick").ogClockpicker(); });
	}
});

/********************************************************************************************/
/* 曖昧ピッカー																				*/
/*																							*/
/*	AIMAI_xxxのid属性を持つタグを見つけて、xxxのvalue値の％付加を行います。					*/
/*	openGion的には、カラムタグに、aimai属性を設定することで、関連するタグを出力します。		*/
/*		0/null : 何もなし(処理的には1,2,3以外とする)										*/
/*		1 : 前方一致％																		*/
/*		2 : ％後方一致																		*/
/*		3 : ％前後曖昧％																	*/
/*																							*/
/*	@og.rev 6.2.0.0 (2015/02/28) 新規作成													*/
/*	@og.rev 6.5.0.0 (2016/09/30) 文字列の長さが、maxlengthの場合は、% を追加しない。		*/
/********************************************************************************************/
function likeComp( _tgtName ){
	var _orgTagName  = _tgtName.substring(6);						// 'AIMAI_' の文字数
	var _likePtn	 = $("#" + _tgtName ).attr('aimaiType');
	var _orgTagValue = $("#" + _orgTagName ).val();
	_orgTagValue	 = _orgTagValue.replace(/^%+|%+$/g, "");

	var _orgMaxLen	 = $("#" + _orgTagName ).attr('maxlength');		// 6.5.0.0 (2016/09/30)

//	if( _orgTagValue != "" ){
	if( _orgTagValue != "" &&
		(_orgMaxLen == null || _orgTagValue.length < parseInt( _orgMaxLen, 10 ) ) ) {	// 6.5.0.0 (2016/09/30)
		switch( _likePtn ){
			case "1": _orgTagValue =	   _orgTagValue + "%";	break;
			case "2": _orgTagValue = "%" + _orgTagValue;		break;
			case "3": _orgTagValue = "%" + _orgTagValue + "%";	break;
		}
	}

	$("#" + _orgTagName ).val( _orgTagValue );
}

/* onSubmit時に自動実行 */
$(function(){
	$("form").submit(function() {
		$("[id^='AIMAI_']").each( function(){likeComp(this.id);} );
	});
});

/********************************************************************************************/
/* 曖昧ピッカー																				*/
/* jQueryのプラグイン																		*/
/*																							*/
/*	@og.rev 5.8.4.1 (2015/02/21) 新規作成(6.2.0.0)											*/
/********************************************************************************************/
$.fn.aimaiPickerOg = function(options) {
	// この文字列が順に0,1,2,3という扱いにいなる。
	var defaults = {
		texts: [' V '	  , ' V*'	  , '*V '	  , '*V*'],			// 桁数を合わせる。
		titls: ['完全一致', '前方一致', '後方一致', '前後曖昧']		// 日本語はリソース化しなければ…
	};

	var opts = $.extend(defaults, options);

	return this.each(function() {
		var txt = $(this);
		var prefix = 'PIC_' + txt.attr('id').replace(/-/g, '') + '_';

		var textsMarkUp = '';
		// ここでピッカーの中身のタグを作成
		for(var i = 0; i < opts.texts.length; i++){
			var item = opts.texts[i];
			var titl = opts.titls[i];
			textsMarkUp += '<span id="'
								+ prefix + 'text-' + i
								+ '" class="text-box"'
								+ '" title="' + titl + '">'
								+ '(' + item + ') </span>';
		}

		// ピッカーそのものを作成
		var box = $('<div id="'
						+ prefix
						+ 'aimai-picker" class="aimai-picker" style="position: absolute; left: 0px; top: 0px;">'
						+ textsMarkUp
						+ '<div style="clear: both;"></div></div>');

		$('body').append(box);
		box.hide();

		// ピッカークリック時の挙動
		box.find('span.text-box').click(function() {
			var indx = this.id.substr(this.id.indexOf('-') + 1);
			txt.attr( 'aimaiType',indx );
			txt.attr( 'title',opts.titls[indx] );
			txt.text( opts.texts[indx] );
			txt.blur();
			hideBox(box);
		});

		// 以下、ボックス制御。気にしなくて良い
		$('body').live('click', function() {
			hideBox(box);
		});

		box.click(function(event) {
			event.stopPropagation();
		});

		var positionAndShowBox = function(box) {
			var pos = txt.offset();
			var left = pos.left + txt.outerWidth() - box.outerWidth();
			if (left < pos.left) left = pos.left;
			box.css({ left: left, top: (pos.top + txt.outerHeight()) });
			showBox(box);
		}

		txt.click(function(event) {
			event.stopPropagation();
			if (!txt.is('input')) {
				positionAndShowBox(box);
			}
		});

		txt.focus(function() {
			positionAndShowBox(box);
		});

		function hideBox(box) {
			if (opts.hideEffect == 'fade')
				box.fadeOut();
			else if (opts.hideEffect == 'slide')
				box.slideUp();
			else
				box.hide();
		}

		function showBox(box) {
			if (opts.showEffect == 'fade')
				box.fadeIn();
			else if (opts.showEffect == 'slide')
				box.slideDown();
			else
				box.show();
		}
	});
};

/* aimaiPicker自動セット */
$(function(){
	if($.fn.aimaiPickerOg){
		$('.aimaiClm').aimaiPickerOg();
	}
});

/*
 * glDatePicker v2.0
 * http://glad.github.com/glDatePicker/
 * カレンダーピッカー
 *
 * この処理は、calendar3.js として、別に管理しています。
 *
 * og.rev 5.8.9.0 (2015/08/07)
*/

/*
 * multipleのリストボックスで、初期選択されていた場合にその位置にスクロールします。
 * optionの高さが取れなかったので、sizeから割り出しています。
 *
 * @og.rev 5.9.4.5 (2016/01/29) 新規作成
 */
function selectScroll(_tgt){
		var size = 4;
		if( _tgt.getAttribute('size') ){ size= _tgt.getAttribute('size');}
		var _child = _tgt.options;
		for(var i=0; i<_child.length; i++){
			if(_child[i].selected){
				// 親がグループの場合のみ
				if( _child[i].parentNode.tagName.toUpperCase() == 'OPTGROUP'){
					 i += $(_child[i].parentNode).prev().length;

				}
				var firstSelected = i * ($(_tgt).height()/size);
				break;
			}
		}
		$(_tgt).scrollTop(firstSelected);
	}

// マルチのセレクトに対して画面ロード時に実行する
$(function(){
	$('select[multiple]').each(function(){ selectScroll(this); });
});
