/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.post;

import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.post.IPostContainerReply;
import oracle.cloudstorage.api.post.IPostObjectReply;
import oracle.cloudstorage.api.post.PostContainerReply;
import oracle.cloudstorage.api.post.PostObjectReply;
import oracle.cloudstorage.api.post.PostRequestProcessor;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ScopedRequestProcessor;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostSendableProcessor
extends PostRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PostSendableProcessor.class);

    public PostSendableProcessor(IProcessorFactory processorFactory) {
        super(processorFactory);
    }

    @Override
    public IPostContainerReply container() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IPostContainerReply> processor = new ScopedRequestProcessor<IRequestBuilder, IPostContainerReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder requestBuilder) {
                IResponse response = PostSendableProcessor.this.send(logger, Marker.post.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IPostContainerReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                PostContainerReply reply = new PostContainerReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IPostContainerReply reply = (IPostContainerReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    protected IPostObjectReply objectImpl() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IPostObjectReply> processor = new ScopedRequestProcessor<IRequestBuilder, IPostObjectReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder requestBuilder) {
                IResponse response = PostSendableProcessor.this.send(logger, Marker.post.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IPostObjectReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                PostObjectReply reply = new PostObjectReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IPostObjectReply reply = (IPostObjectReply)processor.execute(this.getBuilder());
        return reply;
    }
}

