/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal.auth;

import com.ibm.cloud.objectstorage.AmazonWebServiceClient;
import com.ibm.cloud.objectstorage.auth.RegionAwareSigner;
import com.ibm.cloud.objectstorage.auth.Signer;
import com.ibm.cloud.objectstorage.internal.auth.SignerProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProviderContext;
import com.ibm.cloud.objectstorage.services.s3.internal.ServiceUtils;
import com.ibm.cloud.objectstorage.util.AwsHostNameUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.signer = defaultSigner;
    }

    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (uri == null || ServiceUtils.isS3AccelerateEndpoint(uri.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName((String)uri.getHost(), (String)"s3"));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region"), (Throwable)e);
            }
        }
        return this.signer;
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

