/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth.presign;

import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.Request;
import com.ibm.cloud.objectstorage.annotation.Immutable;
import com.ibm.cloud.objectstorage.annotation.SdkProtectedApi;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.Presigner;
import com.ibm.cloud.objectstorage.auth.presign.PresignerParams;
import com.ibm.cloud.objectstorage.internal.auth.SignerProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProviderContext;
import com.ibm.cloud.objectstorage.util.CredentialUtils;
import com.ibm.cloud.objectstorage.util.RuntimeHttpUtils;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Immutable
@SdkProtectedApi
public final class PresignerFacade {
    private final AWSCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;

    public PresignerFacade(PresignerParams presignerParams) {
        this.credentialsProvider = presignerParams.credentialsProvider();
        this.signerProvider = presignerParams.signerProvider();
    }

    public URL presign(Request<?> request, Date expirationDate) {
        Presigner presigner = (Presigner)((Object)this.signerProvider.getSigner(SignerProviderContext.builder().withIsRedirect(false).withRequest(request).withUri(request.getEndpoint()).build()));
        if (request.getOriginalRequest() != null) {
            this.addCustomQueryParams(request);
            this.addCustomHeaders(request);
        }
        AWSCredentialsProvider credentialsProvider = this.resolveCredentials(request);
        presigner.presignRequest(request, credentialsProvider.getCredentials(), expirationDate);
        return RuntimeHttpUtils.convertRequestToUrl(request, true, false);
    }

    private void addCustomQueryParams(Request<?> request) {
        Map<String, List<String>> queryParameters = request.getOriginalRequest().getCustomQueryParameters();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> param : queryParameters.entrySet()) {
            request.addParameters(param.getKey(), param.getValue());
        }
    }

    private void addCustomHeaders(Request<?> request) {
        Map<String, String> headers = request.getOriginalRequest().getCustomRequestHeaders();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.addHeader(header.getKey(), header.getValue());
        }
    }

    private AWSCredentialsProvider resolveCredentials(Request<?> request) {
        return CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.credentialsProvider);
    }

    public static class PresigningRequest
    extends AmazonWebServiceRequest {
        public PresigningRequest withRequestCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
            this.setRequestCredentialsProvider(credentialsProvider);
            return this;
        }
    }
}

