/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.waiters;

import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.annotation.SdkProtectedApi;
import com.ibm.cloud.objectstorage.util.ValidationUtils;
import com.ibm.cloud.objectstorage.waiters.PollingStrategy;
import com.ibm.cloud.objectstorage.waiters.SdkFunction;
import com.ibm.cloud.objectstorage.waiters.Waiter;
import com.ibm.cloud.objectstorage.waiters.WaiterAcceptor;
import com.ibm.cloud.objectstorage.waiters.WaiterBuilder;
import com.ibm.cloud.objectstorage.waiters.WaiterExecution;
import com.ibm.cloud.objectstorage.waiters.WaiterExecutionBuilder;
import com.ibm.cloud.objectstorage.waiters.WaiterHandler;
import com.ibm.cloud.objectstorage.waiters.WaiterParameters;
import com.ibm.cloud.objectstorage.waiters.WaiterTimedOutException;
import com.ibm.cloud.objectstorage.waiters.WaiterUnrecoverableException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@SdkProtectedApi
public class WaiterImpl<Input extends AmazonWebServiceRequest, Output>
implements Waiter<Input> {
    private final SdkFunction<Input, Output> sdkFunction;
    private final List<WaiterAcceptor<Output>> acceptors;
    private final PollingStrategy defaultPollingStrategy;
    private final ExecutorService executorService;

    @SdkProtectedApi
    public WaiterImpl(WaiterBuilder<Input, Output> waiterBuilder) {
        this.sdkFunction = ValidationUtils.assertNotNull(waiterBuilder.getSdkFunction(), "sdkFunction");
        this.acceptors = ValidationUtils.assertNotNull(waiterBuilder.getAcceptor(), "acceptors");
        this.defaultPollingStrategy = ValidationUtils.assertNotNull(waiterBuilder.getDefaultPollingStrategy(), "defaultPollingStrategy");
        this.executorService = ValidationUtils.assertNotNull(waiterBuilder.getExecutorService(), "executorService");
    }

    @Override
    public void run(WaiterParameters<Input> waiterParameters) throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        ValidationUtils.assertNotNull(waiterParameters, "waiterParameters");
        AmazonWebServiceRequest request = ((AmazonWebServiceRequest)ValidationUtils.assertNotNull(waiterParameters.getRequest(), "request")).clone();
        request.getRequestClientOptions().appendUserAgent("waiter-request");
        WaiterExecution waiterExecution = new WaiterExecutionBuilder().withRequest(request).withPollingStrategy(waiterParameters.getPollingStrategy() != null ? waiterParameters.getPollingStrategy() : this.defaultPollingStrategy).withAcceptors(this.acceptors).withSdkFunction(this.sdkFunction).build();
        waiterExecution.pollResource();
    }

    @Override
    public Future<Void> runAsync(final WaiterParameters<Input> waiterParameters, final WaiterHandler callback) throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    WaiterImpl.this.run(waiterParameters);
                    callback.onWaitSuccess(waiterParameters.getRequest());
                }
                catch (Exception ex) {
                    callback.onWaitFailure(ex);
                    throw ex;
                }
                return null;
            }
        });
    }
}

