/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.magnum.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.magnum.MagnumService;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.magnum.Bay;
import org.openstack4j.model.magnum.Baymodel;
import org.openstack4j.model.magnum.Carequest;
import org.openstack4j.model.magnum.Certificate;
import org.openstack4j.model.magnum.Cluster;
import org.openstack4j.model.magnum.Clustertemplate;
import org.openstack4j.model.magnum.Container;
import org.openstack4j.model.magnum.Mservice;
import org.openstack4j.model.magnum.Pod;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.magnum.MagnumBay;
import org.openstack4j.openstack.magnum.MagnumBaymodel;
import org.openstack4j.openstack.magnum.MagnumCertificate;
import org.openstack4j.openstack.magnum.MagnumCluster;
import org.openstack4j.openstack.magnum.MagnumClustertemplate;
import org.openstack4j.openstack.magnum.MagnumContainer;
import org.openstack4j.openstack.magnum.MagnumMservice;
import org.openstack4j.openstack.magnum.MagnumPod;

public class MagnumServiceImpl
extends BaseOpenStackService
implements MagnumService {
    @Override
    public List<? extends Mservice> listMservices() {
        return this.get(MagnumMservice.Mservices.class, this.uri("/mservices", new Object[0])).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public List<? extends Baymodel> listBaymodels() {
        return this.get(MagnumBaymodel.Baymodels.class, this.uri("/baymodels", new Object[0])).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public Baymodel createBaymodel(Baymodel baymodel) {
        Preconditions.checkNotNull((Object)baymodel);
        return this.post(MagnumBaymodel.class, "/baymodels").serviceType(ServiceType.MAGNUM).entity(baymodel).execute();
    }

    @Override
    public ActionResponse deleteBaymodel(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse("/baymodels", "/", id).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Baymodel showBaymodel(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(MagnumBaymodel.class, "/baymodels", "/", id).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Baymodel updateBaymodel(String id, String operations) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)operations);
        return this.patch(MagnumBaymodel.class, "/baymodels", "/", id).serviceType(ServiceType.MAGNUM).json(operations).execute();
    }

    @Override
    public List<? extends Bay> listBays() {
        return this.get(MagnumBay.BayConcreteBuilder.Bays.class, this.uri("/bays", new Object[0])).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public Bay createBay(Bay bay) {
        Preconditions.checkNotNull((Object)bay);
        return this.post(MagnumBay.class, "/bays").serviceType(ServiceType.MAGNUM).entity(bay).execute();
    }

    @Override
    public ActionResponse deleteBay(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse("/bays", "/", id).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Bay showBay(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(MagnumBay.class, "/bays", "/", id).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Bay updateBay(String id, String operations) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)operations);
        return this.patch(MagnumBay.class, "/bays", "/", id).serviceType(ServiceType.MAGNUM).json(operations).execute();
    }

    @Override
    public List<? extends Container> listContainers() {
        return this.get(MagnumContainer.Containers.class, this.uri("/containers", new Object[0])).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public Container createContainer(Container container) {
        Preconditions.checkNotNull((Object)container);
        return this.post(MagnumContainer.class, "/containers").serviceType(ServiceType.MAGNUM).entity(container).execute();
    }

    @Override
    public ActionResponse deleteContainer(String uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return this.deleteWithResponse("/containers", "/", uuid).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public String execCmdInContainer(String id, String cmd) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)cmd);
        return this.put(String.class, this.uri("%s/execute?command=%s", "/containers", id, cmd)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public String getContainerLogs(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(String.class, this.uri("%s/%s/logs", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container pauseContainer(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.put(MagnumContainer.class, this.uri("%s/%s/pause", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container unpauseContainer(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.put(MagnumContainer.class, this.uri("%s/%s/unpause", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container rebootContainer(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.put(MagnumContainer.class, this.uri("%s/%s/reboot", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container startContainer(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.put(MagnumContainer.class, this.uri("%s/%s/start", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container stopContainer(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.put(MagnumContainer.class, this.uri("%s/%s/stop", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container showContainer(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(MagnumContainer.class, this.uri("%s/%s", "/containers", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Container updateContainer(String id, String operations) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)operations);
        return this.patch(MagnumContainer.class, "/containers", "/", id).serviceType(ServiceType.MAGNUM).json(operations).execute();
    }

    @Override
    public Certificate getCertificate(String uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return this.get(MagnumCertificate.class, this.uri("%s/%s", "/certificates", uuid)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Certificate signCertificate(Carequest ca) {
        Preconditions.checkNotNull((Object)ca);
        return this.post(MagnumCertificate.class, "/certificates").serviceType(ServiceType.MAGNUM).entity(ca).execute();
    }

    @Override
    public ActionResponse rotateCertificate(String uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return this.patch(ActionResponse.class, this.uri("%s/%s", "/certificates", uuid)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Cluster createCluster(Cluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        return this.post(MagnumCluster.class, "/clusters").serviceType(ServiceType.MAGNUM).entity(cluster).execute();
    }

    @Override
    public List<? extends Cluster> listClusters() {
        return this.get(MagnumCluster.Clusters.class, this.uri("/clusters", new Object[0])).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public Cluster showCluster(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(Cluster.class, this.uri("%s/%s", "/clusters", id)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public ActionResponse deleteCluster(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse("/clusters", "/", id).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Cluster updateCluster(String id, String operations) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)operations);
        return this.patch(MagnumCluster.class, "/clusters", "/", id).serviceType(ServiceType.MAGNUM).json(operations).execute();
    }

    @Override
    public Clustertemplate createClustertemplate(Clustertemplate template) {
        Preconditions.checkNotNull((Object)template);
        return this.post(MagnumClustertemplate.class, "/clustertemplates").serviceType(ServiceType.MAGNUM).entity(template).execute();
    }

    @Override
    public List<? extends Clustertemplate> listClustertemplate() {
        return this.get(MagnumClustertemplate.Clustertemplates.class, this.uri("/clustertemplates", new Object[0])).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public ActionResponse deleteClustertemplate(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse("/clustertemplates", "/", id).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Clustertemplate updateClustertemplate(String id, String operations) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)operations);
        return this.patch(MagnumClustertemplate.class, "/clustertemplates", "/", id).serviceType(ServiceType.MAGNUM).json(operations).execute();
    }

    @Override
    public List<? extends Pod> listPods(String bayUuid) {
        Preconditions.checkNotNull((Object)bayUuid);
        return this.get(MagnumPod.Pods.class, this.uri("%s/?bay_ident=%s", "/pods", bayUuid)).serviceType(ServiceType.MAGNUM).execute().getList();
    }

    @Override
    public Pod createPod(Pod pod) {
        Preconditions.checkNotNull((Object)pod);
        return this.post(MagnumPod.class, "/pods").serviceType(ServiceType.MAGNUM).entity(pod).execute();
    }

    @Override
    public ActionResponse deletePod(String bayUuid, String id) {
        Preconditions.checkNotNull((Object)bayUuid);
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("%s/%s/?bay_ident=%s", "/pods", id, bayUuid)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Pod showPod(String bayUuid, String id) {
        Preconditions.checkNotNull((Object)bayUuid);
        Preconditions.checkNotNull((Object)id);
        return this.get(MagnumPod.class, this.uri("%s/?bay_ident=%s", "/pods", bayUuid)).serviceType(ServiceType.MAGNUM).execute();
    }

    @Override
    public Pod updatePod(String bayUuid, String id, String operations) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)operations);
        return this.patch(MagnumPod.class, "/pods", "/", id).serviceType(ServiceType.MAGNUM).json(operations).execute();
    }
}

