/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.javaservice;

import java.io.IOException;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.cloud.storage.CloudStorage;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.EncryptedCloudStorage;
import oracle.cloud.storage.internal.CloudStorageServiceProviderImpl;
import oracle.cloud.storage.javaservice.StorageHelper;

public class JavaServiceCloudStorageProvider
extends CloudStorageServiceProviderImpl {
    private final Map<String, CloudStorageConfig> configCache = new HashMap<String, CloudStorageConfig>();
    private final Map<CloudStorageConfig, CloudStorage> storageCache = new HashMap<CloudStorageConfig, CloudStorage>();
    private final Map<CloudStorageConfig, EncryptedCloudStorage> encryptedStorageCache = new HashMap<CloudStorageConfig, EncryptedCloudStorage>();
    private final StorageHelper helper;

    public JavaServiceCloudStorageProvider() throws IOException {
        try {
            Class<?> clz = Class.forName("oracle.cloud.storage.javaservice.StorageHelperImpl");
            this.helper = (StorageHelper)clz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    @Override
    public final String getName() {
        return "javaservice";
    }

    private CloudStorageConfig getConfig(String serviceName) {
        CloudStorageConfig csc = this.configCache.get(serviceName);
        if (!this.helper.isServiceAssociated(serviceName)) {
            if (csc != null) {
                this.configCache.remove(serviceName);
            }
            return null;
        }
        if (csc != null) {
            return csc;
        }
        csc = this.createConfig(serviceName);
        if (csc == null) {
            return null;
        }
        this.configCache.put(serviceName, csc);
        return csc;
    }

    private synchronized CloudStorageConfig createConfig(String serviceName) {
        try {
            Properties props = this.helper.getStorageProperties(serviceName);
            if (props == null) {
                return null;
            }
            Object[] creds = this.helper.getCredentials(serviceName);
            KeyPair kp = null;
            try {
                kp = this.helper.getKeyPair(serviceName);
            }
            catch (SecurityException se) {
                se.printStackTrace();
            }
            CloudStorageConfig config = new CloudStorageConfig();
            config.setUsername((String)creds[0]).setPassword((char[])creds[1]);
            if (kp != null) {
                config.setKeyPair(kp);
            }
            for (String k : props.stringPropertyNames()) {
                String val = props.getProperty(k);
                if (k.equals("cloud.storage.name")) {
                    config.setServiceName(val);
                    continue;
                }
                if (k.equals("cloud.storage.url")) {
                    config.setServiceUrl(val);
                    continue;
                }
                if (k.equals("cloud.storage.chunk-size")) {
                    config.setChunkSize(Integer.parseInt(val));
                    continue;
                }
                if (k.equals("cloud.storage.auth-provider")) {
                    config.setAuthProvider(val);
                    continue;
                }
                if (k.equals("cloud.storage.service-prefix")) {
                    config.setServicePrefix(val);
                    continue;
                }
                if (!k.equals("cloud.storage.log-filter")) continue;
                config.setLogFilter(val);
            }
            return config;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public final void validateConfig(CloudStorageConfig config) {
        if (config.getServiceName() == null) {
            throw new IllegalArgumentException("service name is not set");
        }
    }

    private CloudStorageConfig processConfig(CloudStorageConfig other) {
        CloudStorageConfig csc = this.getConfig(other.getServiceName());
        if (csc == null) {
            super.validateConfig(other);
            return other;
        }
        CloudStorageConfig jsConfig = csc.clone();
        if (other.getAuthProvider() != null) {
            jsConfig.setAuthProvider(other.getAuthProvider());
        }
        if (other.getChunkSize() != -1) {
            jsConfig.setChunkSize(other.getChunkSize());
        }
        if (other.getServicePrefix() != null) {
            jsConfig.setServicePrefix(other.getServicePrefix());
        }
        if (other.getKeyPair() != null) {
            jsConfig.setKeyPair(other.getKeyPair());
        }
        if (other.getLogFilter() != null) {
            jsConfig.setLogFilter(other.getLogFilter());
        }
        return jsConfig;
    }

    @Override
    public final CloudStorage createCloudStorage(CloudStorageConfig config) {
        CloudStorage storage = this.storageCache.get(config);
        if (storage != null) {
            return storage;
        }
        CloudStorageConfig csc = this.processConfig(config);
        storage = super.createCloudStorage(csc);
        if (storage != null) {
            this.storageCache.put(config, storage);
        }
        return storage;
    }

    @Override
    public final EncryptedCloudStorage createEncryptedCloudStorage(CloudStorageConfig config) {
        EncryptedCloudStorage storage = this.encryptedStorageCache.get(config);
        if (storage != null) {
            return storage;
        }
        CloudStorageConfig csc = this.processConfig(config);
        storage = super.createEncryptedCloudStorage(csc);
        if (storage != null) {
            this.encryptedStorageCache.put(config, storage);
        }
        return storage;
    }
}

