/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.session;

import java.security.KeyPair;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.ISessionBuilder;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.cipher.ICipher;
import oracle.cloudstorage.api.http.HttpProxyConfig;
import oracle.cloudstorage.api.http.URLStreamHandlerConfig;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.api.retry.IRetryStrategy;

public class SessionBuilder
implements ISessionBuilder.Sender {
    private final oracle.cloudstorage.api.session.Session session;

    public SessionBuilder() {
        this(new oracle.cloudstorage.api.session.Session());
    }

    protected SessionBuilder(oracle.cloudstorage.api.session.Session session) {
        this.session = session;
    }

    protected Sender createSenderBuilder() {
        Sender senderBuilder = new Sender();
        return senderBuilder;
    }

    @Override
    public ISessionBuilder.RetryStrategy sender(ISender sender) {
        return new Sender().sender(sender);
    }

    @Override
    public ISessionBuilder.SessionHttpProxyConfig retry(IRetryStrategy retryStrategy) {
        RetryStrategy retry = new RetryStrategy();
        return retry.retry(retryStrategy);
    }

    @Override
    public ISessionBuilder.ConnectTimeout httpProxyConfig(HttpProxyConfig httpProxyConfig) {
        SessionHttpProxyConfig proxyConfig = new SessionHttpProxyConfig();
        return proxyConfig.httpProxyConfig(httpProxyConfig);
    }

    @Override
    public ISessionBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
        ConnectTimeout connectTimeout = new ConnectTimeout();
        return connectTimeout.connect(timeout, units);
    }

    @Override
    public ISessionBuilder.Chunk read(long timeout, TimeUnit units) {
        ReadTimeout readTimeout = new ReadTimeout();
        return readTimeout.read(timeout, units);
    }

    @Override
    public ISessionBuilder.Buffer chunk() {
        return new Chunk().chunk();
    }

    @Override
    public ISessionBuilder.Buffer chunk(boolean chunk) {
        return new Chunk().chunk(chunk);
    }

    @Override
    public ISessionBuilder.Buffer chunk(int bytesPerChunk) {
        return new Chunk().chunk(bytesPerChunk);
    }

    @Override
    public ISessionBuilder.Auth buffer(int bufferByteArraySize) {
        return new Buffer().buffer(bufferByteArraySize);
    }

    @Override
    public ISessionBuilder.Cipher authenticator(IAuthStrategy authStrategy) {
        return new Auth().authenticator(authStrategy);
    }

    @Override
    public ISessionBuilder.CipherKeyPair cipher(ICipher cipher) {
        return new Cipher().cipher(cipher);
    }

    @Override
    public ISessionBuilder.Executor cipherKeys(KeyPair keyPair) {
        return new Cryptography().cipherKeys(keyPair);
    }

    @Override
    public ISessionBuilder.SessionURLStreamHandlerConfig executor(ExecutorService executorService) {
        Executor executor = new Executor();
        return executor.executor(executorService);
    }

    @Override
    public ISessionBuilder.Expect urlStreamHandlerConfig(URLStreamHandlerConfig urlStreamHandlerConfig) {
        return new SessionURLStreamHandlerConfig().urlStreamHandlerConfig(urlStreamHandlerConfig);
    }

    @Override
    public ISessionBuilder.Session enableExpect100Continue(boolean enable) {
        return new Expect().enableExpect100Continue(enable);
    }

    @Override
    public final ISession session() {
        this.session.built();
        return this.session;
    }

    private class Session
    implements ISessionBuilder.Session {
        private Session() {
        }

        @Override
        public final ISession session() {
            return SessionBuilder.this.session();
        }
    }

    private class Expect
    extends Session
    implements ISessionBuilder.Expect {
        private Expect() {
        }

        @Override
        public ISessionBuilder.Session enableExpect100Continue(boolean enable) {
            return new Session();
        }
    }

    private class SessionURLStreamHandlerConfig
    extends Expect
    implements ISessionBuilder.SessionURLStreamHandlerConfig {
        private SessionURLStreamHandlerConfig() {
        }

        @Override
        public ISessionBuilder.Expect urlStreamHandlerConfig(URLStreamHandlerConfig urlStreamHandlerConfig) {
            SessionBuilder.this.session.setURLStreamHandlerConfig(urlStreamHandlerConfig);
            return new Expect();
        }
    }

    private class Executor
    extends SessionURLStreamHandlerConfig
    implements ISessionBuilder.Executor {
        private Executor() {
        }

        @Override
        public ISessionBuilder.SessionURLStreamHandlerConfig executor(ExecutorService executor) {
            SessionBuilder.this.session.setExecutor(executor);
            return new SessionURLStreamHandlerConfig();
        }
    }

    private class Cryptography
    extends Executor
    implements ISessionBuilder.CipherKeyPair {
        private Cryptography() {
        }

        @Override
        public ISessionBuilder.Executor cipherKeys(KeyPair keyPair) {
            ICipher cipher = SessionBuilder.this.session.getCipher();
            cipher.setKeyPair(keyPair);
            return new Executor();
        }
    }

    private class Cipher
    extends Cryptography
    implements ISessionBuilder.Cipher {
        private Cipher() {
        }

        @Override
        public ISessionBuilder.CipherKeyPair cipher(ICipher cipher) {
            SessionBuilder.this.session.setCipher(cipher);
            return new Cryptography();
        }
    }

    private class Auth
    extends Cipher
    implements ISessionBuilder.Auth {
        private Auth() {
        }

        @Override
        public ISessionBuilder.Cipher authenticator(IAuthStrategy authStrategy) {
            SessionBuilder.this.session.setAuthStrategy(authStrategy);
            return new Cipher();
        }
    }

    private class Buffer
    extends Auth
    implements ISessionBuilder.Buffer {
        private Buffer() {
        }

        @Override
        public ISessionBuilder.Auth buffer(int bufferByteArraySize) {
            SessionBuilder.this.session.setBuffer(bufferByteArraySize);
            return new Auth();
        }
    }

    private class Chunk
    extends Buffer
    implements ISessionBuilder.Chunk {
        private Chunk() {
        }

        @Override
        public ISessionBuilder.Buffer chunk() {
            return this.chunk(true);
        }

        @Override
        public ISessionBuilder.Buffer chunk(boolean chunk) {
            int chunkSize = chunk ? 0 : -2;
            return this.chunk(chunkSize);
        }

        @Override
        public ISessionBuilder.Buffer chunk(int bytesPerChunk) {
            SessionBuilder.this.session.setChunk(bytesPerChunk);
            return new Buffer();
        }
    }

    private class ReadTimeout
    extends Chunk
    implements ISessionBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public ISessionBuilder.Chunk read(long timeout, TimeUnit units) {
            SessionBuilder.this.session.setReadTimeout(units.toMillis(timeout));
            return new Chunk();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements ISessionBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public ISessionBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            SessionBuilder.this.session.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class SessionHttpProxyConfig
    extends ConnectTimeout
    implements ISessionBuilder.SessionHttpProxyConfig {
        private SessionHttpProxyConfig() {
        }

        @Override
        public ISessionBuilder.ConnectTimeout httpProxyConfig(HttpProxyConfig httpProxyConfig) {
            SessionBuilder.this.session.setHttpProxyConfig(httpProxyConfig);
            return new ConnectTimeout();
        }
    }

    private class RetryStrategy
    extends SessionHttpProxyConfig
    implements ISessionBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ISessionBuilder.SessionHttpProxyConfig retry(IRetryStrategy retryStrategy) {
            SessionBuilder.this.session.setRetryStrategy(retryStrategy);
            return new SessionHttpProxyConfig();
        }
    }

    private class Sender
    extends RetryStrategy
    implements ISessionBuilder.Sender {
        private Sender() {
        }

        @Override
        public ISessionBuilder.RetryStrategy sender(ISender sender) {
            SessionBuilder.this.session.setSender(sender);
            return new RetryStrategy();
        }
    }
}

