/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.File;
import java.util.Arrays;
import org.opengion.fukurou.db.DBFunctionName;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.UnicodeCorrecter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public final class QueueManager_DB
implements QueueManager {
    private static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private static final ApplicationInfo appInfo;
    private static final String DBID;
    private static final String CON;
    private static final String OUT_FILE;
    private static final String OUT_DIR;
    private static final String SQL_SELECT_GE50;
    private static final String SQL_UPDATE_GE50 = "UPDATE GE50 SET FGKAN = ?, DMN_NAME = ?, DMN_HOST = ?, SUDATA = ?, SUPAGE = ?, DYUPD = ? WHERE SYSTEM_ID = ? AND YKNO = ?";
    private static final String SQL_INSERT_GE56 = "INSERT INTO GE56 ( FGJ, SYSTEM_ID, YKNO, ERRMSG, DYSET, DYUPD, USRSET, USRUPD, PGUPD )  VALUES ( '1', ?, ? ,? ,? ,? ,? ,? ,? )";
    private static final int STATUS_COMPLETE = 2;
    private static final int STATUS_EXECUTE = 3;
    private static final int STATUS_ERROR = 8;
    private static QueueManager manager;

    static {
        if (USE_DB_APPLICATION_INFO) {
            appInfo = new ApplicationInfo();
            appInfo.setClientInfo("ReportDaemon", HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            appInfo.setModuleInfo("ReportDaemon", "QueueManager", "QueueManager");
        } else {
            appInfo = null;
        }
        DBID = HybsSystem.sys("RESOURCE_DBID");
        CON = DBFunctionName.getFunctionName((String)"CON", null);
        OUT_FILE = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "OUTFILE" : "OUT_FILE";
        OUT_DIR = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "OUTDIR" : "OUT_DIR";
        SQL_SELECT_GE50 = "SELECT A.SYSTEM_ID, A.YKNO, A.LISTID, A." + OUT_DIR + ", A." + OUT_FILE + ", A.PDF_PASSWD" + ", B.LANG, B.FGRUN, B.DMN_GRP " + ", C.MODELDIR, C.MODELFILE, D.PRTNM, C.FGLOCAL, C.FGCUT, C.BSQL, C.HSQL, C.FSQL " + " ,B.PRTID, B.PRGDIR, B.PRGFILE " + " ,A.GROUPID " + " ,C.FGNOML " + "FROM GE50 A " + "INNER JOIN GE53 B " + "ON A.SYSTEM_ID = B.SYSTEM_ID AND A.JOKEN = B.JOKEN " + "INNER JOIN GE54 C " + "ON A.SYSTEM_ID = C.SYSTEM_ID AND A.LISTID = C.LISTID " + "LEFT OUTER JOIN GE55 D " + "ON B.SYSTEM_ID = D.SYSTEM_ID AND B.PRTID = D.PRTID " + "WHERE A.FGKAN='1' " + "AND EXISTS ( SELECT 'X' FROM GE12 E " + "WHERE\tE.FGJ\t\t\t\t='1' " + "AND\t\tE.SYSTEM_ID \t= '" + HybsSystem.sys("SYSTEM_ID") + "' " + "AND\t\tE.CONTXT_PATH\tin ('" + HybsSystem.sys("HOST_URL") + "','**') " + "AND\t\tE.PARAM_ID\t\tLIKE 'REPORT2_HANDLE_DAEMON_%' " + "AND\t\tE.PARAM\t\t\t= 'RUN_'" + CON + "A.SYSTEM_ID" + CON + "'_'" + CON + "B.DMN_GRP" + ") " + "ORDER BY " + HybsSystem.sys("REPORT_DAEMON_ORDER_BY");
        manager = new QueueManager_DB();
    }

    private QueueManager_DB() {
    }

    public static QueueManager getInstance() {
        return manager;
    }

    @Override
    public synchronized void create() {
        String[][] ge50vals = DBUtil.dbExecute((String)SQL_SELECT_GE50, (String[])new String[0], (ApplicationInfo)appInfo, (String)DBID);
        int i = 0;
        while (i < ge50vals.length) {
            ExecQueue queue = new ExecQueue();
            queue.setSystemId(ge50vals[i][0]);
            queue.setYkno(ge50vals[i][1]);
            queue.setListId(ge50vals[i][2]);
            queue.setOutputName(HybsSystem.url2absPath(ge50vals[i][3]), ge50vals[i][4], ge50vals[i][7], ge50vals[i][1]);
            queue.setPdfPasswd(ge50vals[i][5]);
            queue.setLang(ge50vals[i][6]);
            queue.setOutputType(ge50vals[i][7]);
            queue.setThreadId(String.valueOf(ge50vals[i][0]) + "_" + StringUtil.nval((String)ge50vals[i][8], (String)"_DEFALUT_"));
            queue.setTemplateName(String.valueOf(HybsSystem.url2absPath(ge50vals[i][9])) + File.separator + ge50vals[i][10]);
            queue.setPrinterName(ge50vals[i][11]);
            queue.setFglocal("1".equals(ge50vals[i][12]));
            queue.setFgcut("1".equals(ge50vals[i][13]));
            queue.setPrtId(ge50vals[i][17]);
            queue.setPrgDir(ge50vals[i][18]);
            queue.setPrgFile(ge50vals[i][19]);
            queue.setGrpId(ge50vals[i][20]);
            queue.setDmnGrp(ge50vals[i][8]);
            queue.setFgnoml(ge50vals[i][21]);
            queue.setManager(this);
            ExecThreadManager.insertQueue(queue);
            ++i;
        }
    }

    @Override
    public void set(ExecQueue queue) {
        DBTableModel body;
        DBTableModel footer;
        ResourceManager resource = null;
        resource = queue.isFglocal() ? ResourceFactory.newInstance(queue.getSystemId(), queue.getLang(), false) : ResourceFactory.newInstance(queue.getLang());
        DBTableModel header = new DBTableModelCreator(queue.getSystemId(), queue.getListId(), queue.getYkno(), "H", resource).getTable();
        if (header != null && header.getRowCount() > 0) {
            queue.setHeader(header);
        }
        if ((footer = new DBTableModelCreator(queue.getSystemId(), queue.getListId(), queue.getYkno(), "F", resource).getTable()) != null && footer.getRowCount() > 0) {
            queue.setFooter(footer);
        }
        if ((body = new DBTableModelCreator(queue.getSystemId(), queue.getListId(), queue.getYkno(), "B", resource).getTable()) == null) {
            queue.addMsg("[ERROR] DBTableModel doesn't exists! maybe Layout-Table(GE52) or Report-Data() is not configured..." + HybsSystem.CR);
            queue.setError();
            throw new RuntimeException();
        }
        if (body.getRowCount() <= 0) {
            queue.addMsg("[ERROR] Database Body row count is Zero." + queue.getYkno() + HybsSystem.CR);
            queue.setError();
            throw new RuntimeException();
        }
        if (body.isOverflow()) {
            queue.addMsg("[ERROR]Database is Overflow. [" + body.getRowCount() + "]" + HybsSystem.CR);
            queue.addMsg("[ERROR]Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow" + HybsSystem.CR);
            queue.setError();
            throw new RuntimeException();
        }
        queue.setBody(body);
    }

    @Override
    public void execute(ExecQueue queue) {
        this.status(queue, 3);
    }

    @Override
    public void complete(ExecQueue queue) {
        this.status(queue, 2);
    }

    @Override
    public void error(ExecQueue queue) {
        this.status(queue, 8);
        this.insertErrorMsg(queue);
    }

    private void status(ExecQueue queue, int status) {
        String dyupd = HybsSystem.getDate("yyyyMMddHHmmss");
        String[] args = new String[]{String.valueOf(status), queue.getThreadId(), HybsSystem.sys("HOST_NAME"), String.valueOf(queue.getExecRowCnt()), String.valueOf(queue.getExecPagesCnt()), dyupd, queue.getSystemId(), queue.getYkno()};
        DBUtil.dbExecute((String)SQL_UPDATE_GE50, (String[])args, (ApplicationInfo)appInfo, (String)DBID);
    }

    private void insertErrorMsg(ExecQueue queue) {
        String errmsg = queue.getMsg();
        if (errmsg.length() > 1300) {
            errmsg = errmsg.substring(errmsg.length() - 1300, errmsg.length());
        }
        String dyset = HybsSystem.getDate("yyyyMMddHHmmss");
        String[] args = new String[]{queue.getSystemId(), queue.getYkno(), errmsg, dyset, dyset, "UNKNOWN", "UNKNOWN", "UNKNOWN"};
        DBUtil.dbExecute((String)SQL_INSERT_GE56, (String[])args, (ApplicationInfo)appInfo, (String)DBID);
        if (!"1".equals(queue.getFgnoml())) {
            this.sendMail(queue, errmsg);
        }
    }

    private void sendMail(ExecQueue queue, String inErrMsg) {
        String host = HybsSystem.sys("COMMON_MAIL_SERVER");
        String from = HybsSystem.sys("ERROR_MAIL_FROM_USER");
        Object[] to = StringUtil.csv2Array((String)HybsSystem.sys("ERROR_MAIL_TO_USERS"));
        String match_txt = HybsSystem.sys("REPORT_ERRMAIL_REGEX");
        if (host != null && from != null && to.length > 0 && (match_txt == null || match_txt.length() == 0 || queue.getListId() == null || queue.getListId().length() == 0 || queue.getListId().matches(match_txt))) {
            String subject = "SYSTEM_ID=[" + queue.getSystemId() + "] , YKNO=[" + queue.getYkno() + "] , " + "THREAD_ID=[" + queue.getThreadId() + "] , DMN_HOST=[" + HybsSystem.HOST_NAME + "]" + "LISTID=[" + queue.getListId() + "]";
            try {
                MailTX tx = new MailTX(host);
                tx.setFrom(from);
                tx.setTo((String[])to);
                tx.setSubject("\u5e33\u7968\u30a8\u30e9\u30fc\uff1a" + subject);
                tx.setMessage(inErrMsg);
                tx.sendmail();
            }
            catch (Throwable ex) {
                String errMsg = "\u30a8\u30e9\u30fc\u6642\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsSystem.CR + " SUBJECT:" + subject + HybsSystem.CR + " HOST:" + host + HybsSystem.CR + " FROM:" + from + HybsSystem.CR + " TO:" + Arrays.toString(to) + HybsSystem.CR + ex.getMessage();
                LogWriter.log((String)errMsg);
                LogWriter.log((Throwable)ex);
            }
        }
    }

    public static class DBTableModelCreator {
        private static final String CLM = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "COLUMN_NAME" : "CLM";
        private static final String TEXT_DATA = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "TEXT" : "TEXT_DATA";
        private static final String SQL_SELECT_GE52 = " select " + CLM + ", START_POS, USE_LENGTH" + " from GE52" + " where SYSTEM_ID = ?" + " and LISTID = ?" + " and KBTEXT = ?" + " and FGJ = '1'" + " and FGUSE = '1'" + " order by SEQ";
        private static final String SQL_SELECT_ = " select " + TEXT_DATA + " from GE51" + " where SYSTEM_ID = ?" + " and YKNO = ?" + " and KBTEXT = ?" + " and FGJ = '1'" + " order by EDNO";
        private static final String ENCODE = HybsSystem.sys("DB_ENCODE");
        private final String systemId;
        private final String listId;
        private final String ykno;
        private final String kbtext;
        private final ResourceManager resource;
        private DBTableModel table = null;

        public DBTableModelCreator(String sid, String lid, String yk, String kt, ResourceManager res) {
            this.systemId = sid;
            this.listId = lid;
            this.ykno = yk;
            this.kbtext = kt;
            this.resource = res;
            this.create();
        }

        private void create() {
            String[] ge52Where = new String[]{this.systemId, this.listId, this.kbtext};
            String[][] ge52Vals = DBUtil.dbExecute((String)SQL_SELECT_GE52, (String[])ge52Where, (ApplicationInfo)appInfo, (String)DBID);
            if (ge52Vals == null || ge52Vals.length == 0) {
                return;
            }
            String[] Where = new String[]{this.systemId, this.ykno, this.kbtext};
            String[][] Vals = DBUtil.dbExecute((String)SQL_SELECT_, (String[])Where, (ApplicationInfo)appInfo, (String)DBID);
            if (Vals == null || Vals.length == 0) {
                return;
            }
            String[] clms = new String[ge52Vals.length];
            int i = 0;
            while (i < ge52Vals.length) {
                clms[i] = ge52Vals[i][0];
                ++i;
            }
            String[][] vals = new String[Vals.length][ge52Vals.length];
            int i2 = 0;
            while (i2 < Vals.length) {
                byte[] bytes = StringUtil.makeByte((String)UnicodeCorrecter.correctToCP932((String)Vals[i2][0], (String)ENCODE), (String)ENCODE);
                int j = 0;
                while (j < ge52Vals.length) {
                    int strpos = Integer.valueOf(ge52Vals[j][1]) - 1;
                    int len = Integer.valueOf(ge52Vals[j][2]);
                    if (strpos >= bytes.length) {
                        vals[i2][j] = "";
                    } else {
                        if (strpos + len > bytes.length) {
                            len = bytes.length - strpos;
                        }
                        vals[i2][j] = StringUtil.rTrim((String)StringUtil.makeString((byte[])bytes, (int)strpos, (int)len, (String)ENCODE));
                    }
                    ++j;
                }
                ++i2;
            }
            this.table = DBTableModelUtil.makeDBTable(clms, vals, this.resource);
        }

        public DBTableModel getTable() {
            return this.table;
        }
    }
}

