/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.FixLengthData;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBTableModel;

public class TableFilter_INDEX
extends AbstractTableFilter {
    private static final String VERSION = "5.6.9.2 (2013/10/18)";
    private static final String[] DBKEY = new String[]{"SYSTEM_ID", "TBLSYU", "TABLE_NAME", "TABLE_LABEL", "INDEX_NAME", "NAME_JA", "INDTYPE", "TABLESPACE_NAME", "INITIAL_EXTENT", "NEXT_EXTENT"};
    protected static final int SYSTEM_ID = 0;
    protected static final int TBLSYU = 1;
    protected static final int TABLE_NAME = 2;
    protected static final int TABLE_LABEL = 3;
    protected static final int INDEX_NAME = 4;
    protected static final int INDTYPE = 6;
    protected static final int TABLESPACE_NAME = 7;
    protected static final int INITIAL_EXTENT = 8;
    protected static final int NEXT_EXTENT = 9;
    private static final String GF07_SEL = "select A.CLM, B.USE_LENGTH from GF07 A left outer join GF05 B on    A.SYSTEM_ID  = B.SYSTEM_ID and   A.TBLSYU     = B.TBLSYU and   A.TABLE_NAME = B.TABLE_NAME and   A.CLM        = B.CLM and   B.FGJ        = '1' where A.SYSTEM_ID=? and A.TBLSYU=? and A.TABLE_NAME=? and A.INDEX_NAME=? and   A.FGJ='1' order by A.SEQNO";
    private static final String ENCODE = "UTF-8";
    private static final String CMNT = "************************************************************************";
    private static final int X = 0;
    private static final int S = 1;
    private static final int K = 2;
    protected static final String XML_START_TAG = "<?xml version='1.0' encoding='UTF-8'?>" + CR + "<ROWSET tableName='xxx'>";
    protected static final String XML_END_TAG = "</ROWSET>";
    protected static final String EXEC_START_TAG = "<EXEC_SQL>";
    protected static final String EXEC_END_TAG = "</EXEC_SQL>";
    protected boolean isXml = false;

    protected void init(Map<String, String> map) {
        map.put("DIR", "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306e\u57fa\u6e96\u30d5\u30a9\u30eb\u30c0(\u5fc5\u9808)");
        map.put("XML", "XML\u51fa\u529b\u3092\u884c\u3046\u304b\u3069\u3046\u304b[true/false]\u3092\u6307\u5b9a(\u521d\u671f\u5024:false)");
        map.put("DROP", "INDEX\u69cb\u6587\u306e\u524d\u306b\u3001DROP\u69cb\u6587\u3092\u51fa\u529b\u3059\u308b\u304b\u3069\u3046\u304b(\u521d\u671f\u5024:false)");
    }

    public DBTableModel execute() {
        DBTableModel dBTableModel = this.getDBTableModel();
        this.isXml = StringUtil.nval((String)this.getValue("XML"), (boolean)false);
        boolean bl = StringUtil.nval((String)this.getValue("DROP"), (boolean)false);
        int[] nArray = this.getTableColumnNo(DBKEY);
        int n = dBTableModel.getRowCount();
        File file = new File(this.getValue("DIR"));
        if (!file.exists() && !file.mkdirs()) {
            String string = "\u6240\u5b9a\u306e\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file + "]";
            throw new HybsSystemException(string);
        }
        String[] stringArray = null;
        String string = null;
        PrintWriter printWriter = null;
        Transaction transaction = this.getTransaction();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string2 = null;
            String string3 = null;
            try {
                String[] stringArray2;
                String[][] stringArray3;
                stringArray = (String[])dBTableModel.getValues(i);
                String string4 = stringArray[nArray[0]];
                object = stringArray[nArray[1]];
                string2 = stringArray[nArray[2]];
                string3 = stringArray[nArray[4]];
                if (!string2.equals(string)) {
                    if (printWriter != null) {
                        if (this.isXml) {
                            printWriter.println(XML_END_TAG);
                        }
                        printWriter.close();
                    }
                    string = string2;
                    printWriter = FileUtil.getPrintWriter((File)new File(file, string2 + (this.isXml ? "C.xml" : "C.sql")), (String)ENCODE);
                    if (this.isXml) {
                        printWriter.println(XML_START_TAG.replace("xxx", string2));
                    }
                    printWriter.print(this.makeHeadLine(nArray, stringArray));
                }
                if ((stringArray3 = DBUtil.dbExecute((String)GF07_SEL, (String[])(stringArray2 = new String[]{string4, object, string2, string3}), (Transaction)transaction)).length == 0) {
                    System.out.println("TABLE=[" + string2 + "],INDEX=[" + string3 + "] is Not Found!");
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < stringArray3.length; ++j) {
                    stringBuilder.append(this.makeIndexClmStr(stringArray3[j][0], stringArray3[j][1])).append(",");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                if (bl) {
                    printWriter.print(this.makeDropLine(nArray, stringArray));
                }
                String string5 = stringBuilder.toString();
                printWriter.print(this.makeLineList(nArray, stringArray, string5));
                printWriter.println(this.makeEndLine(nArray, stringArray));
                continue;
            }
            catch (RuntimeException runtimeException) {
                object = this.makeErrorMessage("TableFilter_INDEX Error", 2);
                object.addMessage(i + 1, 2, "INDEX", new String[]{runtimeException.getMessage()});
                object.addMessage(i + 1, 2, "INDEX", new String[]{StringUtil.array2csv((String[])stringArray)});
                object.addMessage(i + 1, 2, "INDEX", new String[]{"TABLE=[" + string2 + "],INDEX=[" + string3 + "]"});
                System.out.println(object);
            }
        }
        if (this.isXml) {
            printWriter.println(XML_END_TAG);
        }
        if (printWriter != null) {
            printWriter.close();
        }
        return dBTableModel;
    }

    protected String makeHeadLine(int[] nArray, String[] stringArray) {
        String string = stringArray[nArray[2]];
        String string2 = string + " ( " + stringArray[nArray[3]] + " )";
        String string3 = "Created : " + HybsSystem.getDate();
        int[] nArray2 = new int[]{0, 0, 0};
        int[] nArray3 = new int[]{0, 2, 0};
        FixLengthData fixLengthData = new FixLengthData(nArray2, nArray3);
        String[][] stringArray2 = new String[][]{{"/**", CMNT, "**/"}, {"/* ", string2, " */"}, {"/* ", string3, " */"}, {"/**", CMNT, "**/"}};
        fixLengthData.addAllListData(stringArray2);
        return fixLengthData.getAllFixData();
    }

    protected String makeLineList(int[] nArray, String[] stringArray, String string) {
        String string2 = stringArray[nArray[2]];
        String string3 = stringArray[nArray[4]];
        String string4 = stringArray[nArray[6]];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CR);
        if (this.isXml) {
            stringBuilder.append(EXEC_START_TAG).append(CR);
        }
        if ("0".equals(string4)) {
            stringBuilder.append("ALTER TABLE ").append(string2).append(" ADD CONSTRAINT ");
            stringBuilder.append(string3).append(" PRIMARY KEY ( ").append(string);
            stringBuilder.append(" )");
        } else if ("1".equals(string4)) {
            stringBuilder.append("ALTER TABLE ").append(string2).append(" ADD CONSTRAINT ");
            stringBuilder.append(string3).append(" UNIQUE( ").append(string);
            stringBuilder.append(" )");
        } else if ("2".equals(string4)) {
            stringBuilder.append("CREATE INDEX ").append(string3).append(" ON ");
            stringBuilder.append(string2).append("( ").append(string);
            stringBuilder.append(" )");
        } else {
            String string5 = "INDTYPE \u304c\u30010,1,2 \u4ee5\u5916\u306e\u5024\u304c\u4f7f\u308f\u308c\u3066\u3044\u307e\u3059\u3002INDTYPE=[" + string4 + "] TABLE_NAME=[" + string2 + "] INDEX_NAME=[" + string3 + "]";
            System.out.println(string5);
        }
        return stringBuilder.toString();
    }

    protected String makeEndLine(int[] nArray, String[] stringArray) {
        String string = stringArray[nArray[7]];
        String string2 = stringArray[nArray[8]];
        String string3 = stringArray[nArray[9]];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CR);
        if (!StringUtil.isNull((String)string) || !StringUtil.isNull((String)string2)) {
            String string4 = stringArray[nArray[6]];
            if ("0".equals(string4) || "1".equals(string4)) {
                stringBuilder.append("USING INDEX ");
            }
            if (!StringUtil.isNull((String)string)) {
                stringBuilder.append("TABLESPACE ").append(stringArray[nArray[7]]).append(CR);
            }
            if (!StringUtil.isNull((String)string2) && string2.charAt(0) != '0') {
                stringBuilder.append("STORAGE( INITIAL ").append(stringArray[nArray[8]]).append("K");
                if (!StringUtil.isNull((String)string3) && string3.charAt(0) != '0') {
                    stringBuilder.append(" NEXT ").append(stringArray[nArray[9]]).append("K");
                }
                stringBuilder.append(")");
            }
        }
        if (this.isXml) {
            stringBuilder.append(CR).append(EXEC_END_TAG);
        } else {
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    protected String makeDropLine(int[] nArray, String[] stringArray) {
        String string = stringArray[nArray[2]];
        String string2 = stringArray[nArray[4]];
        String string3 = stringArray[nArray[6]];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CR);
        if (this.isXml) {
            stringBuilder.append(EXEC_START_TAG).append(CR);
        }
        if ("0".equals(string3) || "1".equals(string3)) {
            stringBuilder.append("ALTER TABLE ").append(string).append(" DROP CONSTRAINT ");
            stringBuilder.append(string2);
        } else if ("2".equals(string3)) {
            stringBuilder.append("DROP INDEX ").append(string2);
        }
        if (this.isXml) {
            stringBuilder.append(CR).append(EXEC_END_TAG);
        } else {
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    protected String makeIndexClmStr(String string, String string2) {
        return string;
    }
}

