/****************************************************************************/
/* GE15 ( ｱｸｾｽ調査ﾃｰﾌﾞﾙ )                                                   */
/*                                                                          */
/* Created : 2020/02/28 14:39:06                                            */
/****************************************************************************/
CREATE TABLE GE15 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID               */
 , USERID           VARCHAR2 (   10 )                   NOT NULL            /*  20 ﾕｰｻﾞｰID              */
 , USERADRS         VARCHAR2 (   40 )                                       /*  30 IPｱﾄﾞﾚｽ(local)       */
 , HOSTADRS         VARCHAR2 (   40 )                                       /*  40 IPｱﾄﾞﾚｽ(remote)      */
 , GUIKEY           VARCHAR2 (   30 )                                       /*  50 画面ID               */
 , DYLOGIN          VARCHAR2 (   14 )                                       /*  60 ﾛｸﾞｲﾝ時間            */
 , DYLOGOUT         VARCHAR2 (   14 )                                       /*  70 ﾛｸﾞｱｳﾄ時間           */
 , USED_TIME        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  80 使用時間(秒)         */
 , CNT_ACCESS       NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  90 ｱｸｾｽ件数             */
 , CNT_ERROR        NUMBER   (    5 )       DEFAULT 0   NOT NULL            /* 100 ｴﾗｰ件数              */
 , CNT_READ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 110 読込件数             */
 , CNT_WRITE        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 120 出力件数             */
 , TM_TOTAL_QUERY   NUMBER   (   18 )       DEFAULT 0   NOT NULL            /* 130 ﾄｰﾀﾙDBｸｴﾘ時間(ms)    */
 , TM_MAX_QUERY     NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 140 最大DBｸｴﾘ時間(ms)    */
 , MAX_QUERY        VARCHAR2 ( 4000 )                                       /* 150 最長実行ｸｴﾘ          */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ               */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ             */
 , DYSET            VARCHAR2 (   14 )                                       /* 820 登録日時             */
 , PGSET            VARCHAR2 (   10 )                                       /* 830 作成PG               */
 , PGPSET           VARCHAR2 (   10 )                                       /* 840 作成親PG             */
 , USRSET           VARCHAR2 (   10 )                                       /* 850 作成社員             */
 , DYUPD            VARCHAR2 (   14 )                                       /* 860 更新日時             */
 , PGUPD            VARCHAR2 (   10 )                                       /* 870 更新PG               */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 880 更新親PG             */
 , USRUPD           VARCHAR2 (   10 )                                       /* 890 更新者               */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GE15S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE15T00 
  BEFORE INSERT ON GE15
  FOR EACH ROW 
  BEGIN 
    SELECT GE15S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
