/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.File;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ZipArchive;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.io.HybsFileOperationFactory;
import org.opengion.hayabusa.report2.DocConverter_OOO;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.OdsContentParser;

public class ExecProcess {
    private final ExecQueue queue;
    private final String type;
    private final long start = System.currentTimeMillis();
    private final boolean debug;
    private final String outTemp;

    public ExecProcess(ExecQueue execQueue, boolean bl) {
        this.queue = execQueue;
        this.type = execQueue.getOutputType();
        this.debug = bl;
        this.outTemp = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("REPORT_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "REPORT/"))) + this.queue.getSystemId() + File.separator + this.queue.getListId() + File.separator + this.queue.getYkno();
    }

    public void process() {
        this.addDebugMsg("[INFO]EXEC-TIME:START=" + this.start);
        this.queue.setEnd(true);
        if (!"2".equals(this.type)) {
            this.parse();
        }
        if ("2".equals(this.type) || "3".equals(this.type)) {
            this.output("PRINT");
        } else if ("P".equals(this.type)) {
            this.output("PDF");
        } else if ("E".equals(this.type)) {
            this.output("EXCEL");
        } else if ("F".equals(this.type)) {
            this.output("XSLX");
        } else if ("Q".equals(this.type)) {
            this.output("PRINT", "PDF");
        } else if ("S".equals(this.type)) {
            this.output("ODS");
        }
        this.addDebugMsg("[INFO]EXEC-TIME:END=" + System.currentTimeMillis());
    }

    private void parse() {
        File file = new File(this.queue.getTemplateName() + ".ods");
        String string = this.outTemp + File.separator;
        File file2 = new File(string);
        File file3 = new File(this.outTemp + ".ods");
        FileUtil.deleteFiles((File)file2);
        ZipArchive.unCompress((File)file2, (File)file);
        this.addDebugMsg("[INFO]EXEC-TIME:UNCOMP=" + (System.currentTimeMillis() - this.start));
        this.queue.setData();
        this.addDebugMsg("[INFO]EXEC-TIME:DATA=" + (System.currentTimeMillis() - this.start));
        OdsContentParser odsContentParser = new OdsContentParser(this.queue, string);
        odsContentParser.exec();
        this.addDebugMsg("[INFO]EXEC-TIME:PARSE=" + (System.currentTimeMillis() - this.start));
        ZipArchive.compress((File)file2, (File)file3);
        this.addDebugMsg("[INFO]EXEC-TIME:COMP=" + (System.currentTimeMillis() - this.start));
        FileUtil.deleteFiles((File)file2);
        this.addDebugMsg("[INFO]EXEC-TIME:DELETE=" + (System.currentTimeMillis() - this.start));
    }

    private void output(String ... stringArray) {
        String string = this.outTemp + ".ods";
        if (!new File(string).exists()) {
            this.queue.addMsg("\u4e2d\u9593\uff8c\uff67\uff72\uff99\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\uff61" + string + HybsConst.CR);
            throw new HybsSystemException();
        }
        DocConverter_OOO docConverter_OOO = new DocConverter_OOO(string);
        try {
            docConverter_OOO.open();
            this.addDebugMsg("[INFO]EXEC-TIME:OPEN=" + (System.currentTimeMillis() - this.start));
            for (int i = 0; i < stringArray.length; ++i) {
                if ("PRINT".equals(stringArray[i])) {
                    if (this.queue.getPrinterName() == null || this.queue.getPrinterName().isEmpty()) {
                        this.queue.addMsg("\u51fa\u529b\u5148\uff8f\uff7d\uff80\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff61" + HybsConst.CR);
                        throw new Exception();
                    }
                    docConverter_OOO.print(this.queue.getPrinterName());
                } else {
                    String string2 = this.queue.getOutputName();
                    if ("PDF".equals(stringArray[i])) {
                        docConverter_OOO.pdf(string2, this.queue.getPdfPasswd());
                    } else {
                        docConverter_OOO.auto(string2);
                    }
                    HybsFileOperationFactory.local2cloud(false, () -> new File(string2));
                }
                this.addDebugMsg("[INFO]EXEC-TIME:EXEC[" + stringArray[i] + "]=" + (System.currentTimeMillis() - this.start));
            }
            docConverter_OOO.close();
            this.addDebugMsg("[INFO]EXEC-TIME:RELEASE=" + (System.currentTimeMillis() - this.start));
        }
        catch (Throwable throwable) {
            docConverter_OOO.close(true);
            this.queue.addMsg("[INFO]EXEC-TIME:ERROR=" + (System.currentTimeMillis() - this.start) + HybsConst.CR);
            throw new HybsSystemException(throwable);
        }
        FileUtil.deleteFiles((File)new File(string));
        this.addDebugMsg("[INFO]EXEC-TIME:DELETE=" + (System.currentTimeMillis() - this.start));
    }

    private void addDebugMsg(String string) {
        if (this.debug) {
            this.queue.addMsg(string + HybsConst.CR);
        }
    }
}

