/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.apache.poi.xssf.usermodel.XSSFTextParagraph;
import org.apache.poi.xssf.usermodel.XSSFTextRun;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.model.TextConverter;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ImageUtil;

public class ExcelModel {
    private static final String VERSION = "8.0.1.0 (2021/10/29)";
    private static final String DEF_SHEET_NAME = "Sheet";
    private static final Map<String, Integer> PICTURE_TYPE = new HashMap<String, Integer>();
    private final String inFilename;
    private final String sufix;
    private final Workbook wkbook;
    private Sheet sheet;
    private Row rowObj;
    private int refSheetIdx = -1;
    private final CreationHelper createHelper;
    private CellStyle style;
    private CellStyle hLinkStyle;
    private int maxColCount = 5;
    private int dataStartRow = -1;
    private boolean isAutoCellSize;
    private String addTitleSheet;
    private String[] recalcSheetNames;

    public ExcelModel(File file) {
        this(file, true);
    }

    public ExcelModel(File file, boolean bl) {
        this.inFilename = file.getName();
        int n = this.inFilename.lastIndexOf(46);
        if (n < 0) {
            String string = "\uff8c\uff67\uff72\uff99\u306e\u62e1\u5f35\u5b50\u304c\u898b\u5f53\u305f\u308a\u307e\u305b\u3093\uff61(.xls \u304b .xlsx/.xlsm \u3092\u6307\u5b9a\u4e0b\u3055\u3044)" + HybsConst.CR + " filename=[" + file + "]" + HybsConst.CR;
            throw new IllegalArgumentException(string);
        }
        this.sufix = this.inFilename.substring(n).toLowerCase(Locale.JAPAN);
        if (bl) {
            this.wkbook = POIUtil.createWorkbook(file);
        } else if (".xlsx".equals(this.sufix) || ".xlsm".equals(this.sufix)) {
            this.wkbook = new SXSSFWorkbook();
        } else if (".xls".equals(this.sufix)) {
            this.wkbook = new HSSFWorkbook();
        } else {
            String string = "\uff8c\uff67\uff72\uff99\u306e\u62e1\u5f35\u5b50\u304c\u4e0d\u6b63\u3067\u3059\uff61(.xls \u304b .xlsx/.xlsm \u306e\u307f\u53ef\u80fd)" + HybsConst.CR + " filename=[" + file + "]" + HybsConst.CR;
            throw new IllegalArgumentException(string);
        }
        this.createHelper = this.wkbook.getCreationHelper();
    }

    public void setFont(String string, short s) {
        if (this.style == null) {
            this.style = this.wkbook.createCellStyle();
        }
        Font font = this.wkbook.createFont();
        if (string != null) {
            font.setFontName(string);
        }
        if (s > 0) {
            font.setFontHeightInPoints(s);
        }
        this.style.setFont(font);
    }

    public void setCellStyle() {
        if (this.style == null) {
            this.style = this.wkbook.createCellStyle();
        }
        this.style.setBorderBottom(BorderStyle.THIN);
        this.style.setBorderLeft(BorderStyle.THIN);
        this.style.setBorderRight(BorderStyle.THIN);
        this.style.setBorderTop(BorderStyle.THIN);
        this.style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        this.style.setVerticalAlignment(VerticalAlignment.TOP);
    }

    public void useAutoCellSize(boolean bl) {
        this.isAutoCellSize = bl;
    }

    public void useAutoCellSize(boolean bl, int n) {
        this.isAutoCellSize = bl;
        this.maxColCount = n;
    }

    public void setRecalcSheetName(String[] stringArray) {
        this.recalcSheetNames = stringArray;
    }

    public void setDataStartRow(int n) {
        this.dataStartRow = n;
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = string;
    }

    public int getNumberOfSheets() {
        return this.wkbook.getNumberOfSheets();
    }

    public void setRefSheetName(String string) {
        int n = this.refSheetIdx = string == null ? 0 : this.wkbook.getSheetIndex(string);
        if (this.refSheetIdx < 0) {
            String string2 = "\u6307\u5b9a\u306e\u53c2\u7167\uff7c\uff70\uff84\u540d\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3067\u3057\u305f\uff61" + HybsConst.CR + " inFilename=[" + this.inFilename + "] , refSheetName=[" + string + "]" + HybsConst.CR;
            throw new IllegalArgumentException(string2);
        }
    }

    public void createSheet(String string, boolean bl) {
        int n;
        if (this.refSheetIdx < 0) {
            this.sheet = this.wkbook.createSheet();
            n = this.wkbook.getNumberOfSheets() - 1;
        } else if (this.refSheetIdx >= this.wkbook.getNumberOfSheets()) {
            this.sheet = this.wkbook.cloneSheet(this.refSheetIdx - 1);
            n = this.wkbook.getNumberOfSheets() - 1;
            ++this.refSheetIdx;
        } else {
            this.sheet = this.wkbook.getSheetAt(this.refSheetIdx);
            n = this.refSheetIdx++;
        }
        if (!bl) {
            this.setSheetName(n, string);
        }
    }

    public void setSheetName(int n, String string) {
        Object object = string == null ? DEF_SHEET_NAME : WorkbookUtil.createSafeSheetName((String)string);
        int n2 = 1;
        String string2 = this.wkbook.getSheetName(n);
        if (object != null && !((String)object).equals(string2)) {
            if (n == this.wkbook.getSheetIndex((String)object)) {
                this.wkbook.setSheetName(n, (String)object);
            } else {
                while (this.wkbook.getSheetIndex((String)object) >= 0) {
                    object = WorkbookUtil.createSafeSheetName((String)(string + "(" + n2 + ")"));
                    if (((String)object).length() >= 31) {
                        object = ((String)object).substring(0, 26) + "(" + n2 + ")";
                    }
                    ++n2;
                }
                this.wkbook.setSheetName(n, (String)object);
            }
        }
    }

    public String getSheetName(int n) {
        int n2 = this.wkbook.getNumberOfSheets();
        String string = null;
        if (n < n2) {
            this.sheet = this.wkbook.getSheetAt(n);
            string = this.sheet.getSheetName();
        }
        return string;
    }

    public int getSheetNo(String string) {
        this.sheet = this.wkbook.getSheet(string);
        return this.wkbook.getSheetIndex(string);
    }

    public void removeSheet(int n, int n2) {
        for (int i = n2; i >= n; --i) {
            this.wkbook.removeSheetAt(i);
        }
    }

    public int getFirstRowNum() {
        return this.sheet.getFirstRowNum();
    }

    public int getLastRowNum() {
        return this.sheet.getLastRowNum();
    }

    public void createRow(int n) {
        this.rowObj = this.sheet.getRow(n);
        if (this.rowObj == null) {
            this.rowObj = this.sheet.createRow(n);
        }
    }

    public void removeRow(int n) {
        int n2;
        int n3 = n;
        for (int i = n2 = this.sheet.getLastRowNum(); i >= n3 && i >= 0; --i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            this.sheet.removeRow(row);
        }
    }

    public void removeCell(int n) {
        int n2;
        int n3 = n;
        for (int i = n2 = this.rowObj.getLastCellNum(); i >= n3; --i) {
            Cell cell = this.rowObj.getCell(i);
            if (cell == null) continue;
            this.rowObj.removeCell(cell);
        }
    }

    public void setValues(String[] stringArray, int n) {
        if (this.rowObj == null) {
            this.createRow(n);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setCellValue(stringArray[i], i);
            }
        }
    }

    public void setValues(String[] stringArray, int n, boolean[] blArray) {
        if (this.rowObj == null) {
            this.createRow(n);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setCellValue(stringArray[i], i, blArray[i]);
            }
        }
    }

    public void setCellValue(String string, int n) {
        this.setCellValue(string, n, false);
    }

    public void setCellValue(String string, int n, boolean bl) {
        Double d;
        Cell cell = this.rowObj.getCell(n);
        if (cell == null) {
            cell = this.rowObj.createCell(n);
        }
        if (this.style != null) {
            cell.setCellStyle(this.style);
        }
        if (bl && (d = this.parseDouble(string)) != null) {
            cell.setCellValue(d.doubleValue());
            return;
        }
        d = this.createHelper.createRichTextString(string);
        cell.setCellValue((RichTextString)d);
    }

    public void setCellLink(String string, int n) {
        Hyperlink hyperlink;
        if (string == null || string.isEmpty()) {
            return;
        }
        Cell cell = this.rowObj.getCell(n);
        if (cell == null) {
            cell = this.rowObj.createCell(n);
        }
        if (this.hLinkStyle == null) {
            this.hLinkStyle = this.wkbook.createCellStyle();
            if (this.style != null) {
                this.hLinkStyle.cloneStyleFrom(this.style);
            }
            hyperlink = this.wkbook.createFont();
            hyperlink.setColor(IndexedColors.BLUE.getIndex());
            hyperlink.setUnderline((byte)1);
            this.hLinkStyle.setFont((Font)hyperlink);
        }
        cell.setCellStyle(this.hLinkStyle);
        hyperlink = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
        hyperlink.setAddress("'" + string + "'!A1");
        cell.setHyperlink(hyperlink);
    }

    public String[] getValues(int n) {
        this.rowObj = this.sheet.getRow(n);
        int n2 = this.rowObj == null ? 0 : this.rowObj.getLastCellNum();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            Cell cell = this.rowObj.getCell(i);
            stringArray[i] = POIUtil.getValue(cell);
        }
        return stringArray;
    }

    public String getValue(int n, int n2) {
        this.rowObj = this.sheet.getRow(n);
        return this.rowObj == null ? null : POIUtil.getValue(this.rowObj.getCell(n2));
    }

    public void addImageFile(String string, int n, int n2, int n3) {
        this.addImageFile(string, n, n2, n3, n2, n3, 0, 0, 0, 0);
    }

    public void addImageFile(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        String string2 = ImageUtil.getSuffix(string);
        Integer n10 = PICTURE_TYPE.get(string2);
        int n11 = n10 == null ? 6 : n10;
        byte[] byArray = ImageUtil.byteImage(string);
        int n12 = this.wkbook.addPicture(byArray, n11);
        Sheet sheet = this.wkbook.getSheetAt(n);
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor clientAnchor = drawing.createAnchor(9525 * n6, 9525 * n7, 9525 * n8, 9525 * n9, n3, n2, n5, n4);
        clientAnchor.setAnchorType(ClientAnchor.AnchorType.MOVE_DONT_RESIZE);
        Picture picture = drawing.createPicture(clientAnchor, n12);
        if (n2 == n4 || n3 == n5) {
            picture.resize();
        }
    }

    public void saveFile(File file) {
        File file2;
        String string = file.getName();
        if (string.toLowerCase(Locale.JAPAN).endsWith(this.sufix)) {
            file2 = file;
        } else {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            file2 = new File(file.getParent(), string + this.sufix);
        }
        if (this.isAutoCellSize) {
            POIUtil.autoCellSize(this.wkbook, this.maxColCount, this.dataStartRow);
        }
        if (this.recalcSheetNames != null && this.recalcSheetNames.length > 0) {
            for (String string2 : this.recalcSheetNames) {
                Sheet sheet = this.wkbook.getSheet(string2);
                if (sheet == null) continue;
                sheet.setForceFormulaRecalculation(true);
            }
        }
        if (this.addTitleSheet != null) {
            this.makeAddTitleSheet();
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            this.wkbook.write((OutputStream)bufferedOutputStream);
        }
        catch (IOException iOException) {
            try {
                String string3 = "\uff8c\uff67\uff72\uff99\u3078\u66f8\u8fbc\u307f\u4e2d\u306b\uff74\uff97\uff70\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff61" + HybsConst.CR + "  File=" + file2 + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string3, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedOutputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedOutputStream);
    }

    private void makeAddTitleSheet() {
        this.sheet = this.wkbook.createSheet();
        String string = this.sheet.getSheetName();
        this.wkbook.setSheetOrder(string, 0);
        this.setSheetName(0, this.addTitleSheet);
        int n = 0;
        this.createRow(n++);
        this.setCellValue("No", 0);
        this.setCellValue(DEF_SHEET_NAME, 1);
        int n2 = this.wkbook.getNumberOfSheets();
        int n3 = 1;
        while (n3 < n2) {
            String string2 = this.wkbook.getSheetName(n3);
            this.createRow(n);
            this.setCellValue(String.valueOf(n), 0, true);
            this.setCellValue(string2, 1);
            this.setCellLink(string2, 1);
            ++n3;
            ++n;
        }
        this.sheet.autoSizeColumn(0);
        this.sheet.autoSizeColumn(1);
    }

    public List<int[]> getLastRowCellNum() {
        return POIUtil.getLastRowCellNum(this.wkbook);
    }

    public void activeWorkbook(boolean bl) {
        POIUtil.activeWorkbook(this.wkbook, bl);
    }

    public void activeWorkbook(List<int[]> list) {
        POIUtil.activeWorkbook(this.wkbook, list);
    }

    public void textConverter(Map<String, String> map) {
        this.textConverter((String string, String string2) -> (String)map.get(string));
    }

    public void textConverter(TextConverter<String, String> textConverter) {
        int n = this.wkbook.getNumberOfSheets();
        for (int i = 0; i < n; ++i) {
            Object object;
            Sheet sheet = this.wkbook.getSheetAt(i);
            String string = textConverter.change(sheet.getSheetName(), DEF_SHEET_NAME);
            if (string != null) {
                this.setSheetName(i, string);
            }
            int n2 = Math.max(sheet.getFirstRowNum(), 0);
            int n3 = sheet.getLastRowNum();
            for (int j = n2; j <= n3; ++j) {
                Row row = sheet.getRow(j);
                if (row == null) continue;
                int n4 = Math.max(row.getFirstCellNum(), 0);
                short s = row.getLastCellNum();
                for (int k = n4; k <= s; ++k) {
                    object = row.getCell(k);
                    if (object == null || object.getCellType() == CellType.BLANK) continue;
                    String string2 = "Sht" + i + ":" + POIUtil.getCelKigo(j, k);
                    String string3 = this.crConv(textConverter, POIUtil.getValue(object), string2);
                    if (string3 == null) continue;
                    POIUtil.setValue(object, string3);
                }
            }
            if (!(sheet instanceof POIXMLDocumentPart)) continue;
            for (Row row : ((POIXMLDocumentPart)sheet).getRelations()) {
                if (!(row instanceof XSSFDrawing)) continue;
                for (XSSFShape xSSFShape : ((XSSFDrawing)row).getShapes()) {
                    XSSFAnchor xSSFAnchor = xSSFShape.getAnchor();
                    object = "XY(" + xSSFAnchor.getDx1() + "-" + xSSFAnchor.getDy1() + ")";
                    int n5 = 0;
                    if (!(xSSFShape instanceof XSSFSimpleShape)) continue;
                    for (XSSFTextParagraph xSSFTextParagraph : ((XSSFSimpleShape)xSSFShape).getTextParagraphs()) {
                        for (XSSFTextRun xSSFTextRun : xSSFTextParagraph.getTextRuns()) {
                            String string4 = "Sht" + i + ":" + (String)object + ":Tb(" + n5++ + ")";
                            String string5 = this.crConv(textConverter, xSSFTextRun.getText(), string4);
                            if (string5 == null) continue;
                            xSSFTextRun.setText(string5);
                        }
                    }
                }
            }
        }
    }

    public void sheetSelected(boolean bl) {
        this.sheet.setSelected(bl);
    }

    public void sheetCopy(TextConverter<String, String> textConverter, String string) {
        int n = this.wkbook.getNumberOfSheets() - 1;
        this.sheet = this.refSheetIdx >= 0 && this.refSheetIdx < n ? this.wkbook.cloneSheet(this.refSheetIdx) : this.wkbook.cloneSheet(n);
        this.setSheetName(++n, string);
        int n2 = Math.max(this.sheet.getFirstRowNum(), 0);
        int n3 = this.sheet.getLastRowNum();
        for (int i = n2; i <= n3; ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            int n4 = Math.max(row.getFirstCellNum(), 0);
            short s = row.getLastCellNum();
            for (int j = n4; j <= s; ++j) {
                Object object;
                Cell cell = row.getCell(j);
                if (cell == null || cell.getCellType() == CellType.BLANK || (object = this.crConv(textConverter, POIUtil.getValue(cell), null)) == null) continue;
                POIUtil.setValue(cell, (String)object);
            }
        }
        if (this.sheet instanceof POIXMLDocumentPart) {
            for (Row row : ((POIXMLDocumentPart)this.sheet).getRelations()) {
                if (!(row instanceof XSSFDrawing)) continue;
                for (XSSFShape xSSFShape : ((XSSFDrawing)row).getShapes()) {
                    if (!(xSSFShape instanceof XSSFSimpleShape)) continue;
                    for (Cell cell : ((XSSFSimpleShape)xSSFShape).getTextParagraphs()) {
                        for (XSSFTextRun xSSFTextRun : cell.getTextRuns()) {
                            String string2 = this.crConv(textConverter, xSSFTextRun.getText(), null);
                            if (string2 == null) continue;
                            xSSFTextRun.setText(string2);
                        }
                    }
                }
            }
        }
    }

    private String crConv(TextConverter<String, String> textConverter, String string, String string2) {
        String string3 = null;
        if (string != null) {
            if (string.contains("\n")) {
                String[] stringArray = string.split("\\n");
                boolean bl = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = textConverter.change(stringArray[i], string2);
                    if (string4 == null) continue;
                    stringArray[i] = string4;
                    bl = true;
                }
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder(200);
                    stringBuilder.append(stringArray[0]);
                    for (int i = 1; i < stringArray.length; ++i) {
                        stringBuilder.append('\n').append(stringArray[i]);
                    }
                    string3 = stringBuilder.toString();
                }
            } else {
                string3 = textConverter.change(string, string2);
            }
        }
        return string3;
    }

    public String[] getSheetNames() {
        return POIUtil.getSheetNames(this.wkbook);
    }

    public String[] getNames() {
        return POIUtil.getNames(this.wkbook);
    }

    public String[] getStyleNames() {
        return POIUtil.getStyleNames(this.wkbook);
    }

    private Double parseDouble(String string) {
        Double d = null;
        try {
            d = string == null || string.isEmpty() || string.equals("_") ? null : (string.indexOf(44) < 0 ? Double.valueOf(string) : Double.valueOf(string.replaceAll(",", "")));
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Double\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff61" + HybsConst.CR + numberFormatException.getMessage() + HybsConst.CR + "  value=" + string;
            System.err.println(string2);
            d = null;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.ExcelModel \u5165\u529b\uff8c\uff67\uff72\uff99\u540d [\u51fa\u529b\uff8c\uff67\uff72\uff99\u540d] \uff65\uff65\uff65\n\t-CS      CellStyle\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\uff61        \n\t-TC      TextConverter\u3092\u5b9f\u884c\u3057\u307e\u3059\uff61     \n\t-AS      useAutoCellSize\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\uff61  \n\t-FN=***  FontName\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\uff61         \n\t-FP=**   FontPoint\u3092 \u8a2d\u5b9a\u3057\u307e\u3059\uff61        \n\t-IMG     \u753b\u50cf\uff8c\uff67\uff72\uff99\u3092\u633f\u5165\u3057\u307e\u3059\uff61      \n\t     (-IMG \uff8c\uff67\uff72\uff99\u540d \uff7c\uff70\uff84\u756a\u53f7 \u884c \u5217)  \n");
            return;
        }
        ExcelModel excelModel = new ExcelModel(new File(stringArray[0]), true);
        excelModel.activeWorkbook(true);
        if (stringArray.length > 1) {
            File file = new File(stringArray[1]);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string3 = null;
            short s = -1;
            for (int i = 2; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if ("-CS".equalsIgnoreCase(string4)) {
                    bl = true;
                }
                if ("-AS".equalsIgnoreCase(string4)) {
                    bl2 = true;
                }
                if ("-TC".equalsIgnoreCase(string4)) {
                    bl3 = true;
                }
                if (string4.startsWith("-FN")) {
                    string3 = string4.substring(3);
                }
                if (string4.startsWith("-FP")) {
                    s = Short.parseShort(string4.substring(3));
                }
                if (!"-IMG".equalsIgnoreCase(string4)) continue;
                String string5 = stringArray[++i];
                int n = Integer.parseInt(stringArray[++i]);
                int n2 = Integer.parseInt(stringArray[++i]);
                int n3 = Integer.parseInt(stringArray[++i]);
                excelModel.addImageFile(string5, n, n2, n3);
            }
            if (bl) {
                excelModel.setCellStyle();
            }
            excelModel.useAutoCellSize(bl2);
            excelModel.setFont(string3, s);
            if (bl3) {
                excelModel.textConverter((String string, String string2) -> {
                    System.out.println((String)string);
                    return null;
                });
            }
            excelModel.saveFile(file);
        } else {
            StringBuilder stringBuilder = new StringBuilder(200);
            int n = excelModel.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                String string6 = excelModel.getSheetName(i);
                int n4 = excelModel.getFirstRowNum();
                int n5 = excelModel.getLastRowNum();
                for (int j = n4; j <= n5; ++j) {
                    stringBuilder.setLength(0);
                    stringBuilder.append(string6).append('\t').append(j);
                    String[] stringArray2 = excelModel.getValues(j);
                    if (stringArray2 != null) {
                        for (int k = 0; k < stringArray2.length; ++k) {
                            String string7 = stringArray2[k] == null ? "" : stringArray2[k];
                            stringBuilder.append('\t').append(string7);
                        }
                    }
                    System.out.println(stringBuilder);
                }
                System.out.println();
            }
        }
    }

    static {
        PICTURE_TYPE.put("png", 6);
        PICTURE_TYPE.put("jpeg", 5);
        PICTURE_TYPE.put("jpg", 5);
    }
}

