/****************************************************************************/
/* GE80 ( FAQﾃｰﾌﾞﾙ )                                                        */
/*                                                                          */
/* Created : 2021/10/18 13:54:00                                            */
/****************************************************************************/

CREATE TABLE GE80 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , SYSCODE      VARCHAR2 (   20 )       DEFAULT '*' NOT NULL            /*  20 ｼｽﾃﾑｺｰﾄﾞ     */
 , KBFAQ        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /*  30 FAQ区分      */
 , QANO         VARCHAR2 (   20 )                   NOT NULL            /*  40 質問番号     */
 , CDBNRUI      VARCHAR2 (   10 )                                       /*  50 分類ｺｰﾄﾞ     */
 , KNRNGUI      VARCHAR2 (  200 )                                       /*  60 関連画面ID   */
 , TITLE        VARCHAR2 (  300 )                                       /*  70 ﾀｲﾄﾙ         */
 , NAIYO        VARCHAR2 ( 4000 )                                       /*  80 内容         */
 , SEQNO        NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  90 表示順       */
 , FILE1        VARCHAR2 (  200 )                                       /* 100 ﾌｧｲﾙ1        */
 , FILE2        VARCHAR2 (  200 )                                       /* 110 ﾌｧｲﾙ2        */
 , FILE3        VARCHAR2 (  200 )                                       /* 120 ﾌｧｲﾙ3        */
 , FILEPATH     VARCHAR2 (  200 )                                       /* 130 ﾌｧｲﾙﾊﾟｽ      */
 , TAG          VARCHAR2 (  200 )                                       /* 140 ﾀｸﾞｷｰﾜｰﾄﾞ    */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 作成日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成者       */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GE80S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE80T00 
  BEFORE INSERT ON GE80
  FOR EACH ROW 
  BEGIN 
    SELECT GE80S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
