/****************************************************************************/
/* GF85 ( 移行DB対応明細 )                                                  */
/*                                                                          */
/* Created : 2021/06/29 14:03:36                                            */
/****************************************************************************/

CREATE TABLE GF85 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  1 ｼｽﾃﾑID        */
 , TABLE_NAME   VARCHAR2 (   50 )                   NOT NULL            /*  2 ﾃｰﾌﾞﾙ名       */
 , CLM          VARCHAR2 (   30 )                   NOT NULL            /*  3 項目          */
 , SEQNO        NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  4 表示順        */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  5 名称          */
 , CLS_NAME     VARCHAR2 (   10 )                   NOT NULL            /*  6 DBｸﾗｽ         */
 , USE_LENGTH   VARCHAR2 (    9 )                                       /*  7 使用桁数      */
 , DATA_DEFAULT VARCHAR2 (  200 )                                       /*  8 初期値        */
 , NOT_NULL     VARCHAR2 (    1 )                                       /*  9 ﾉｯﾄﾇﾙ         */
 , BIKO         VARCHAR2 ( 2000 )                                       /* 10 備考          */
 , NOJUN        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 11 対応順        */
 , CONV_FUNC    VARCHAR2 (  500 )                                       /* 12 変換関数      */
 , F_CLM        VARCHAR2 ( 1000 )                                       /* 13 元項目        */
 , F_NAME_JA    VARCHAR2 (  200 )                                       /* 14 元名称        */
 , F_CLS_NAME   VARCHAR2 (   10 )                                       /* 15 元DBｸﾗｽ       */
 , F_USE_LENGTH VARCHAR2 (    9 )                                       /* 16 元使用桁数    */
 , F_BIKO       VARCHAR2 ( 2000 )                                       /* 17 元備考        */
 , DESCRIPTION  VARCHAR2 ( 4000 )                                       /* 18 概要説明      */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 19 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 20 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (   14 )                                       /* 21 登録日時      */
 , PGSET        VARCHAR2 (   10 )                                       /* 22 作成PG        */
 , PGPSET       VARCHAR2 (   10 )                                       /* 23 作成親PG      */
 , USRSET       VARCHAR2 (   10 )                                       /* 24 作成社員      */
 , DYUPD        VARCHAR2 (   14 )                                       /* 25 更新日時      */
 , PGUPD        VARCHAR2 (   10 )                                       /* 26 更新PG        */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 27 更新親PG      */
 , USRUPD       VARCHAR2 (   10 )                                       /* 28 更新者        */
 , KBCLM        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 29 ｶﾗﾑ区分       */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GF85S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF85T00 
  BEFORE INSERT ON GF85
  FOR EACH ROW 
  BEGIN 
    SELECT GF85S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
