<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC01"
	title	= "タグリブ定義"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select  a.VERNO,a.SEQ,a.TAGNAME,b.HTMLEXT
			<og:text caseNN  ="{@TEXT_DATA}">,CTX_DOC.SNIPPET('GF23_TXT_IDX',b.UNIQ,'{@TEXT_DATA}') AS DESCRIPTION</og:text>
			<og:text caseNull="{@TEXT_DATA}">,b.DESCRIPTION</og:text>
				, a.BODYCONTENT,b.CONTENTS,b.FORM_SAMPLE
		from    GF21 a left outer join GF23 b
		on		a.VERNO		= b.VERNO
		and		a.TAGCLASS	= b.TAGCLASS
		and		a.FGJ		= b.FGJ
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.VERNO			= '{@VERNO}'"				/>
		<og:and value = "upper(a.TAGNAME)	LIKE upper('{@TAGNAME}')"	/>
		<og:and value = "b.DESCRIPTION		LIKE '{@DESCRIPTION}'"		/>
		<og:and value = "b.CONTENTS			LIKE '{@CONTENTS}'"			/>
		<og:and value = "a.FGJ				in ( '0','1' )"				/>
		<og:and value = "CONTAINS ( b.FGJ, '{@TEXT_DATA}' ,1) &gt; 0"	/>
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="a.VERNO,a.SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->

<og:viewLink command="{@command}">
	<og:link column="TAGNAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,TAGNAME,VIEW"
			vals="NEW,[VERNO],[TAGNAME],{@VIEW}" />
</og:viewLink>

<og:equals val1="{@VIEW}" nullCheck="true" >
	<og:view
		viewFormType = "HTMLTable"
		command 	 = "{@command}"
		noDisplay	 = "CONTENTS,FORM_SAMPLE"
		writable     = "false"
		pageSize     = "{@pageSize}" />
</og:equals>

<og:equals val1="{@VIEW}" val2="FULL" >
	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType = "HTMLFormatTable"
		command 	 = "{@command}"
		writable     = "false"
		useTableSorter = "false"
		pageSize     = "{@pageSize}"
		rowspan      = "2"
	>
		<tr>
			<td valign="top">
				[VERNO]<br />[SEQ].[TAGNAME]<br />[HTMLEXT]<br />[BODYCONTENT]
			</td>
			<td><pre>[CONTENTS]</pre></td>
		</tr>
		<tr>
			<td colspan="2"><pre style="font-family:monospace;">[FORM_SAMPLE]</pre></td>
		</tr>
		<tr style="page-break-after:always;" />
	</og:view>
</og:equals>

<!-- ここまで。 -->
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
