<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC04"
	title	= "バージョン差分"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ﾀｸﾞﾘﾌﾞ定義 のｷｰ比較 -->
<og:equals val1="{@TYPE}" val2="DOC01" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.TAGNAME,COALESCE(B.VERNO,C.VERNO) as VERNO,
			case WHEN B.TAGNAME is NULL THEN '' ELSE '〇' end as "{@VERNO}" ,
			case WHEN C.TAGNAME is NULL THEN '' ELSE '〇' end as "{@OLDVAR}" ,
			D.DESCRIPTION
		from (
			<!-- 両ﾊﾞｰｼﾞｮﾝから、共通部分を削除する -->
			select TAGNAME,TAGCLASS from GF21 where VERNO in ( '{@VERNO}','{@OLDVAR}' )
			minus
			(	select TAGNAME,TAGCLASS from GF21 where VERNO = '{@VERNO}'
				INTERSECT
				select TAGNAME,TAGCLASS from GF21 where VERNO = '{@OLDVAR}'
			)
		) A left outer join GF21 B
				on  A.TAGNAME = B.TAGNAME
				and B.VERNO = '{@VERNO}'
			left outer join GF21 C
				on  A.TAGNAME = C.TAGNAME
				and C.VERNO = '{@OLDVAR}'
			left outer join GF23 D
				on  A.TAGCLASS = D.TAGCLASS
				and D.VERNO in ( '{@VERNO}','{@OLDVAR}' )
		order by A.TAGNAME
	</og:query>

	<og:viewLink command="{@command}">
		<og:link column="TAGNAME" gamenId="DOC01" href="index.jsp" target="CONTENTS"
				keys="command,VERNO,TAGNAME,VIEW" vals="NEW,[VERNO],[TAGNAME]," />
	</og:viewLink>
</og:equals>

<!-- ﾀｸﾞﾘﾌﾞ属性定義 のｷｰ比較 -->
<og:equals val1="{@TYPE}" val2="DOC02" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.TAGNAME ,A.VALUENAME ,COALESCE(B.VERNO,C.VERNO) as VERNO,
			case WHEN B.TAGNAME is NULL THEN '' ELSE '〇' end as "{@VERNO}" ,
			case WHEN C.TAGNAME is NULL THEN '' ELSE '〇' end as "{@OLDVAR}" ,
			D.DESCRIPTION
		from (
			<!-- 両ﾊﾞｰｼﾞｮﾝから、共通部分を削除する -->
			select TAGNAME,TAGCLASS,VALUENAME from GF22 where VERNO in ( '{@VERNO}','{@OLDVAR}' )
			minus
			(	select TAGNAME,TAGCLASS,VALUENAME from GF22 where VERNO = '{@VERNO}'
				INTERSECT
				select TAGNAME,TAGCLASS,VALUENAME from GF22 where VERNO = '{@OLDVAR}'
			)
		) A
			inner join (
				<!-- 両ﾊﾞｰｼﾞｮﾝから、共通部分のみを検索する -->
				select TAGNAME,TAGCLASS from GF21 where VERNO = '{@VERNO}'
				INTERSECT
				select TAGNAME,TAGCLASS from GF21 where VERNO = '{@OLDVAR}'
			) X on A.TAGCLASS = X.TAGCLASS
			left outer join GF22 B
				on  A.TAGNAME   = B.TAGNAME
				and A.TAGCLASS  = B.TAGCLASS
				and A.VALUENAME = B.VALUENAME
				and B.VERNO    = '{@VERNO}'
			left outer join GF22 C
				on  A.TAGNAME   = C.TAGNAME
				and A.TAGCLASS  = C.TAGCLASS
				and A.VALUENAME = C.VALUENAME
				and C.VERNO    = '{@OLDVAR}'
			left outer join GF24 D
				on  A.TAGCLASS  = D.TAGCLASS
				and A.VALUENAME = D.VALUENAME
				and D.VERNO in ( '{@VERNO}','{@OLDVAR}' )
		order by A.TAGNAME
	</og:query>

	<og:viewLink command="{@command}">
		<og:link column="TAGNAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
				keys="command,VERNO,TAGNAME,VIEW" vals="NEW,[VERNO],[TAGNAME]," />
		<og:link column="VALUENAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
				keys="command,VERNO,TAGNAME,VALUENAME,VIEW" vals="NEW,[VERNO],[TAGNAME],[VALUENAME],FULL" />
	</og:viewLink>
</og:equals>

<!-- 属性ｸﾗｽ定義 のｷｰ比較 -->
<og:equals val1="{@TYPE}" val2="DOC03" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select A.VALUENAME ,A.ATTKEY,COALESCE(B.VERNO,C.VERNO) as VERNO,
			case WHEN B.ATTKEY is NULL THEN '' ELSE '〇' end as "{@VERNO}" ,
			case WHEN C.ATTKEY is NULL THEN '' ELSE '〇' end as "{@OLDVAR}" ,
			COALESCE(B.DESCRIPTION,C.DESCRIPTION) as DESCRIPTION
		from (
			<!-- 両ﾊﾞｰｼﾞｮﾝから、共通部分を削除する -->
			select ATTKEY,VALUENAME from GF25 where VERNO in ( '{@VERNO}','{@OLDVAR}' )
			minus
			(	select ATTKEY,VALUENAME from GF25 where VERNO = '{@VERNO}'
				INTERSECT
				select ATTKEY,VALUENAME from GF25 where VERNO = '{@OLDVAR}'
			)
		) A left outer join GF25 B
				on  A.ATTKEY    = B.ATTKEY
				and A.VALUENAME = B.VALUENAME
				and B.VERNO = '{@VERNO}'
			left outer join GF25 C
				on  A.ATTKEY    = C.ATTKEY
				and A.VALUENAME = C.VALUENAME
				and C.VERNO = '{@OLDVAR}'
		order by B.ATTCLASS,B.SEQ,B.ATTKEY,B.VALUENAME
	</og:query>

	<og:viewLink command="{@command}">
		<og:link column="VALUENAME" gamenId="DOC03" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,VALUENAME,VIEW" vals="NEW,[VERNO],[VALUENAME]," />
		<og:link column="ATTKEY" gamenId="DOC03" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,ATTKEY,VALUENAME,VIEW" vals="NEW,[VERNO],[ATTKEY],[VALUENAME],FULL" />
	</og:viewLink>
</og:equals>

<og:columnEditor columns="{@VERNO},{@OLDVAR}" clazz="BIT" />

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	noDisplay	 = "VERNO"
	checked		 = "{@checked}"
	writable	 = "false"
	startNo		 = "{@startNo}"
	pageSize	 = "{@pageSize}"
/>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
