/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.db;

/**
 * SelectionCellEditor インターフェースは、データ編集用のインターフェースの特殊系です。
 * これは、Selectionオブジェクトを使用していることを示すマーカーインターフェースであり、
 * デフォルトの メソッドを定義しています。(よって、JDK1.8以降でしか、使用できません)
 * デフォルトメソッドでは、KEY:VAL 形式かどうか判定して、KEY 部分だけ取り出す処理を
 * 行います。つまり、Selection では、KEY文字列に、":" は指定できません。
 *
 * @og.rev 6.2.2.0 (2015/03/27) 新規追加
 * @og.group データ編集
 *
 * @version  6.2
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8
 */
public interface SelectionCellEditor {

	/**
	 * KEY:VAL 形式かどうか判定して、KEY 部分だけ取り出します。
	 *
	 * 引数のvalue に、":" が含まれていれば、それ以前の箇所を
	 * 切り出して返します。
	 * そうでなければ、引数のまま、返します。
	 *
	 * @og.rev 6.2.2.0 (2015/03/27) 新規追加
	 *
	 * @param	value	(一般に編集データとして登録されたデータ)
	 *
	 * @return  KEY:VAL 形式の KEY部分のみ
	 */
	default String getReaderValue( final String value ) {
		if( value == null || value.isEmpty() ) { return value; }

		String rtnVal = value ;
		final int ad = rtnVal.indexOf( ':' );			// KEY:VAL の区切り文字を探す
		if( ad >= 0 ) {
			rtnVal = rtnVal.substring( 0,ad );
		}

		return rtnVal;
	}
}
