<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0010"
	title	= "ﾄｰｸﾝﾏｽﾀ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	checkType = "NEW"
	minRowCount="1"
	nullCheck = "SET_GRP">
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="ENTRY" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="ENTRY" />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<og:dataCheck command="ENTRY" exist="false">
	select count(*) from GG02
	where SET_GRP='{@SET_GRP}' AND TOKEN=[TOKEN]
</og:dataCheck>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- constValsは無条件にシングルクオートを付けるので、数字型はfuncValsで設定します -->
<og:transaction>
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" sqlType="COPY" debug="{@debug}">
		<og:tableUpdateParam
			sqlType= "COPY"
			table  = "GG02"
			names  = "TOKEN,TKN_NM,TKN_GRP"
			where  = "SET_GRP='{@SET_GRP}' AND TOKEN=[TOKEN]"
			constKeys = "SET_GRP,CDREC,CDDISP,FGJ"
			constVals = "{@SET_GRP},0,1,1"
			funcKeys  = "ROWNO,COLNO,ROWSPAN,COLSPAN"
			funcVals  = "1,1,1,1"
		/>
	</og:tableUpdate>

	<!-- SEQNOの再セット -->
	<og:query
		command		= "NEW"
		maxRowCount	= "0" >
			select	B.SEQNO as ROWNO,A.UNIQ
			FROM   GG02 A inner join GG01 B
					on A.TOKEN = B.TOKEN
			WHERE  A.SET_GRP='{@SET_GRP}'
			ORDER  BY 1
	</og:query>

	<og:tableFilter classId="SEQRESET" keys="START_NO,INCREMENT,SEQ_CLM" vals="10000,1,ROWNO" selectedAll="true" />

	<og:tableUpdate
		command		= "{@command}"
		selectedAll = "true"
		queryType	= "JDBCTableUpdate" >
			UPDATE GG02 SET
				ROWNO  = [ROWNO]
			WHERE UNIQ = [UNIQ]
			AND ROWNO != [ROWNO]
	</og:tableUpdate>
</og:transaction>

<og:forward gamenId="GG0020" page="index.jsp" target="parent.parent.CONTENTS"
		keys="command,SET_GRP" vals="NEW,{@SET_GRP}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
