<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useTabLink="true" useIntervalAccess="true">
	<style type="text/css">
		/* useTableSorter=false 時は、th の中に span タグが書かれる */
		th span , th a { white-space: pre; }
	</style>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "GG:拡張ｵﾌﾟｼｮﾝ"
	pgid	= "GG0120"
	title	= "月次一覧表示"
	date	= "2021/11/19"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="MSG0065" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- yyyy-MM 形式を変換します。 -->
<og:value command="SET" action="TO_DATE" key="DATE_YM" value="{@SEL_YM}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<!-- UPCNT は、ﾃﾞｰﾀがない場合 NULL になり、entry で初期値が書き込まれるため、全件変更される -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="0" >
		select	B.DY_HATU	,
				B.SET_GRP	,
				B.SET_KEY	,
				B.TOKEN		,
				B.UPCNT		,
				A.TKN_NM	,
				COALESCE( B.VAL ,'　' ) as VAL	,
				COALESCE( B.JUDG ,'0' ) as JUDG
		from GG02 A left outer join GG10 B
				on  A.SET_GRP	= B.SET_GRP
				and A.TOKEN		= B.TOKEN
		<og:where>
			<og:and value = "B.DY_HATU	LIKE '{@DATE_YM}%'"		/>
			<og:and value = "A.SET_GRP	=    '{@SET_GRP}'"		/>
			<og:and value = "B.SET_KEY	like '{@SET_KEY}'"		/>
		</og:where>
		and   A.FGJ		= '1'
		order by B.DY_HATU,B.SET_GRP,B.SET_KEY,A.ROWNO,A.COLNO,B.TOKEN,B.UPCNT DESC
</og:query>

<!-- 同一 TOKEN で、更新ｶｳﾝﾀ(UPCNT) が一番大きいレコードのみ表示します。(order by で先に現れる) -->
<og:tableMerge
	action		= "GROUP"
	masterKeys	= "DY_HATU,SET_GRP,SET_KEY,TOKEN"
	display		= "{@debug}"
/>

<!-- 0:未 1:OK 2:NG の数値を無理やり変更している。 -->
<og:columnEditor column="VAL" renderer="MENU" codeName="TP_ON" dbType="S9" />
<!-- 判定結果 の凡例と、CSS (追加・変更ボタンの横に出す) -->
<jsp:directive.include file="/jsp/customGG/colorCSS.jsp" />

<og:viewMarker command="{@command}" >
	<og:columnMarker column="VAL" >
		<div class="judg[!JUDG]">[VAL]</div>
	</og:columnMarker>
	<!-- ROTATEでは、viewLinkを処理できない -->
	<og:columnMarker column="SET_KEY" useFormatDeco="true" >
		<og:link gamenId="GG0100" href="index.jsp" target="CONTENTS"
			keys="command,DY_HATU,SET_KEY,SET_GRP"
			vals="NEW,{@DATE.YMD},[SET_KEY],[SET_GRP]" >[$SET_KEY]</og:link>
	</og:columnMarker>
</og:viewMarker>

<!-- 指定月の日付データを生成します -->
<og:value command="SET" action="FOR" key="YM" fromVal="{@DATE.YMD @DATE_YM SD}" toVal="{@DATE.YMD @DATE_YM ED}" />

<og:tableFilter classId="ROTATE" selectedAll="true">
{
	KEY_CLM			: SET_GRP,SET_KEY,TOKEN,TKN_NM	;
	ROTATE_CLM		: DY_HATU	;
	ADD_CLMS		: {@YM}	;
	LBL_FORMAT		: d(EEE)	;		/* MM/dd\n(EEE) */
	VALUE_CLM		: VAL	;
	USE_RENDERER	: true	;
	USE_MARKER		: true	;			/* viewMarker 使うには必要 */
}
</og:tableFilter>

<og:columnEditor column="2021*" clazz="BIT" />

<!-- DB検索結果を表示させます。 -->
<!-- ROTATE してるので、loadMarker = "false" しないと、columnMarkerのｷｰが見つからないエラーになる -->
<og:view
	viewFormType = "HTMLTable"
	writable	= "false"
	noDisplay	= "TOKEN"
	command		= "{@command}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "10000"
	loadMarker	= "false"
	useScrollBar = "false"
	useTableSorter = "false"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
