/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.OracleTypeMetaData;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class ResultSetValue
implements AutoCloseable {
    private static final XLogger LOGGER = XLogger.getLogger(ResultSetValue.class.getSimpleName());
    private static final int BUFFER_MIDDLE = 10000;
    private final ResultSet resultSet;
    private final List<ColumnInfo> clmInfos;
    private boolean skipNext;
    private boolean firstNext;

    public ResultSetValue(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.clmInfos = new ArrayList<ColumnInfo>();
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            int n3 = resultSetMetaData.getColumnType(n2);
            String string = resultSetMetaData.getColumnLabel(n2).toUpperCase(Locale.JAPAN);
            if (n3 == 2002 && DBUtil.isOracle()) {
                Object object;
                if (!this.skipNext) {
                    this.skipNext = true;
                    this.firstNext = this.resultSet.next();
                }
                if (!this.firstNext || (object = this.resultSet.getObject(n2)) == null) continue;
                OracleTypeMetaData oracleTypeMetaData = ((OracleStruct)object).getOracleMetaData();
                ResultSetMetaData resultSetMetaData2 = ((OracleTypeMetaData.Struct)oracleTypeMetaData).getMetaData();
                int n4 = resultSetMetaData2.getColumnCount();
                for (int j = 0; j < n4; ++j) {
                    int n5 = j + 1;
                    String string2 = string + "." + resultSetMetaData2.getColumnLabel(n5).toUpperCase(Locale.JAPAN);
                    int n6 = resultSetMetaData2.getColumnType(n5);
                    int n7 = resultSetMetaData2.getColumnDisplaySize(n5);
                    boolean bl = resultSetMetaData2.isWritable(n5);
                    this.clmInfos.add(new ColumnInfo(string2, n6, n7, bl, n2, j));
                }
                continue;
            }
            int n8 = resultSetMetaData.getColumnDisplaySize(n2);
            boolean bl = resultSetMetaData.isWritable(n2);
            this.clmInfos.add(new ColumnInfo(string, n3, n8, bl, n2, -1));
        }
    }

    public int getColumnCount() {
        return this.clmInfos.size();
    }

    public String[] getNames() {
        return (String[])this.clmInfos.stream().map(columnInfo -> columnInfo.getName()).toArray(String[]::new);
    }

    public String getColumnName(int n) {
        return this.clmInfos.get((int)n).name;
    }

    public int getColumnDisplaySize(int n) {
        return this.clmInfos.get((int)n).size;
    }

    public boolean isWritable(int n) {
        return this.clmInfos.get((int)n).isWrit;
    }

    public boolean next() throws SQLException {
        if (this.skipNext) {
            this.skipNext = false;
            return this.firstNext;
        }
        return this.resultSet.next();
    }

    public String getValue(int n) throws SQLException {
        String string;
        ColumnInfo columnInfo = this.clmInfos.get(n);
        int n2 = columnInfo.clmNo;
        Object object = this.resultSet.getObject(n2);
        if (object == null) {
            string = "";
        } else if (columnInfo.isStruct) {
            int n3 = columnInfo.objNo;
            Object[] objectArray = ((Struct)object).getAttributes();
            string = n3 < objectArray.length ? String.valueOf(objectArray[n3]) : "";
        } else if (columnInfo.isObject) {
            switch (columnInfo.type) {
                case 2005: {
                    string = this.getClobData((Clob)object);
                    break;
                }
                case -8: {
                    string = this.resultSet.getString(n2);
                    break;
                }
                case 93: {
                    string = StringUtil.getTimeFormat(((Timestamp)object).getTime(), "yyyyMMddHHmmss");
                    break;
                }
                default: {
                    string = String.valueOf(object);
                    break;
                }
            }
        } else {
            string = String.valueOf(object);
        }
        return string;
    }

    public String[] getValues() throws SQLException {
        String[] stringArray = new String[this.clmInfos.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getValue(i);
        }
        return stringArray;
    }

    public Number getNumber(int n) throws SQLException {
        ColumnInfo columnInfo = this.clmInfos.get(n);
        int n2 = columnInfo.clmNo;
        Number number = null;
        Object object = this.resultSet.getObject(n2);
        if (object != null) {
            Object object2;
            if (columnInfo.isStruct) {
                int n3 = columnInfo.objNo;
                object2 = ((Struct)object).getAttributes();
                Object object3 = object = n3 < ((Object[])object2).length ? object2[n3] : null;
                if (object == null) {
                    return number;
                }
            }
            switch (columnInfo.type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    number = (Number)object;
                    break;
                }
                case 91: 
                case 92: {
                    number = ((Date)object).getTime();
                    break;
                }
                case 93: {
                    number = ((Timestamp)object).getTime();
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    object2 = (String)object;
                    try {
                        number = Double.valueOf((String)object2);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string = "in=" + (String)object2 + " , clmNo=" + n2 + " , CLM=" + columnInfo.getName();
                        throw MsgUtil.throwException(numberFormatException, "MSG0031", string);
                    }
                }
            }
        }
        return number;
    }

    public String getClassName(int n) {
        return switch (this.clmInfos.get((int)n).type) {
            case -7, 1, 12 -> "VARCHAR2";
            case -1 -> "LONG";
            case -6, -5, 2, 3, 4, 5, 6, 7, 8 -> "NUMBER";
            case 91, 92, 93 -> "DATE";
            case 2005 -> "CLOB";
            case 2002 -> "STRUCT";
            default -> "NONE";
        };
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            String string = "ResultSetValue#close : " + sQLException.getErrorCode();
            LOGGER.warning(sQLException, "MSG0020", sQLException.getSQLState(), string);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warning(runtimeException, "MSG0021", "ResultSetValue#close");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getClobData(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(10000);
        Reader reader = null;
        try {
            int n;
            reader = clob.getCharacterStream();
            char[] cArray = new char[10000];
            while ((n = reader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                throw MsgUtil.throwException(iOException, "MSG0022", iOException.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    LOGGER.warning(iOException2, "MSG0023", "");
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.warning(runtimeException, "MSG0021", "ResultSetValue#getClobData");
                }
                throw throwable;
            }
        }
        try {
            if (reader == null) return stringBuilder.toString();
            reader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            LOGGER.warning(iOException, "MSG0023", "");
            return stringBuilder.toString();
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warning(runtimeException, "MSG0021", "ResultSetValue#getClobData");
            return stringBuilder.toString();
        }
    }

    private static final class ColumnInfo {
        private final String name;
        private final int type;
        private final int size;
        private final boolean isWrit;
        private final int clmNo;
        private final int objNo;
        private final boolean isStruct;
        private final boolean isObject;

        ColumnInfo(String string, int n, int n2, boolean bl, int n3, int n4) {
            this.name = string;
            this.type = n;
            this.size = n2;
            this.isWrit = bl;
            this.clmNo = n3;
            this.objNo = n4;
            this.isStruct = n4 >= 0;
            this.isObject = n == 2005 || n == -8 || n == 93;
        }

        public String getName() {
            return this.name;
        }
    }
}

