/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.util.Locale;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;

public final class FileOperationFactory {
    private static final String CLOUD_PLUGIN = "org.opengion.cloud.FileOperation_";

    private FileOperationFactory() {
    }

    public static FileOperation newStorageOperation(String string) {
        return new FileOperation(string);
    }

    public static FileOperation newStorageOperation(String string, String string2, String string3, String string4) {
        return FileOperationFactory.newStorageOperation(string, string2, new File(string3, string4).getPath());
    }

    public static FileOperation newStorageOperation(String string, String string2, String string3) {
        if (StringUtil.isNull(string, string2) || "LOCAL".equalsIgnoreCase(string) || "LOCAL".equalsIgnoreCase(string2)) {
            return new FileOperation(string3);
        }
        try {
            Object[] objectArray = new Object[]{string2, string3};
            String string4 = string.toUpperCase(Locale.JAPAN);
            return (FileOperation)Class.forName(CLOUD_PLUGIN + string4).getConstructor(String.class, String.class).newInstance(objectArray);
        }
        catch (Throwable throwable) {
            String string5 = "FileOperation \u751f\u6210\u3067\uff64\u5931\u6557\u3057\u307e\u3057\u305f\uff61" + HybsConst.CR + " plugin=" + string + " , bucket=" + string2 + HybsConst.CR + " path=" + string3 + HybsConst.CR;
            throw new RuntimeException(string5, throwable);
        }
    }

    public static FileOperation resolveFile(File file, String string, String string2) {
        return FileOperationFactory.resolveFile(file, new File(string, string2).getPath());
    }

    public static FileOperation resolveFile(File file, String string) {
        if (file == null) {
            return null;
        }
        if (file instanceof FileOperation) {
            String string2 = ((FileOperation)file).getPlugin();
            String string3 = ((FileOperation)file).getBucket();
            return FileOperationFactory.newStorageOperation(string2, string3, string);
        }
        return FileOperationFactory.newStorageOperation(string);
    }
}

