/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.HttpConnect;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.SystemManager;
import org.opengion.hayabusa.common.SystemParameter;

@WebListener
public class HybsContextListener
implements ServletContextListener,
ContainerListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        Map<String, String> map = SystemParameter.makeSystemParameter(servletContext);
        HybsSystem.setInitialData(map);
        String string = HybsSystem.url2dir(System.getProperty("SYS_LOG_URL", HybsSystem.sys("SYS_LOG_URL")));
        String string2 = System.getProperty("SYS_LOG_ENCODE", HybsSystem.sys("SYS_LOG_ENCODE"));
        LogWriter.init((String)string, (String)string2);
        new Thread(new InitialCallURL()).start();
        System.out.println("-------");
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String string = HybsSystem.sys("CONTEXT_NAME");
        System.out.println("Context Destroyed [" + string + "]  " + new Date());
        SystemManager.clearGE12();
        SystemManager.allClear(true);
        SystemManager.sessionDestroyed();
        SystemManager.deleteGUIAccessInfo();
        System.out.println("-------");
    }

    public void containerEvent(ContainerEvent containerEvent) {
        System.out.println("\u3010ContainerEvent:" + containerEvent.getType() + " : " + containerEvent.toString() + "\u3011");
    }

    static {
        Cleanable cleanable = new Cleanable(){

            public void clear() {
                ConnectionFactory.realClose();
            }
        };
        SystemManager.addCleanable(cleanable);
    }

    private static final class InitialCallURL
    implements Runnable {
        private InitialCallURL() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                LogWriter.log((String)("InterruptedException:" + interruptedException.getMessage()));
            }
            String string = HybsSystem.sys("CONTEXT_NAME");
            HybsEntry[] hybsEntryArray = HybsSystem.sysEntry("CONTEXT_INITIAL_CALL_URL");
            String string2 = HybsSystem.sys("CONTEXT_INITIAL_CALL_USERPASS");
            boolean bl = false;
            if (hybsEntryArray.length > 0) {
                for (int i = 0; i < hybsEntryArray.length; ++i) {
                    String string3 = HybsSystem.changeParam(hybsEntryArray[i].getValue());
                    if (string3 == null || string3.isEmpty()) continue;
                    HttpConnect httpConnect = new HttpConnect(string3, string2);
                    String string4 = "    [" + string + "] URL[" + i + "]:" + string3;
                    try {
                        httpConnect.readData();
                        System.out.println(string4);
                        System.out.println("           " + httpConnect.getMessage());
                        bl = true;
                        continue;
                    }
                    catch (IOException iOException) {
                        String string5 = "           " + iOException.getMessage();
                        LogWriter.log((String)string4);
                        LogWriter.log((String)string5);
                        LogWriter.log((Throwable)iOException);
                        System.out.println("    [CONTEXT_INITIAL_CALL_URL Error!]");
                        System.out.println(string4);
                        System.out.println(string5);
                    }
                }
            }
            if (bl) {
                System.out.println("    [" + string + "] CONTEXT_INITIAL_CALL_URL");
                System.out.println("-------");
            }
        }
    }
}

