<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2060"
	title	= "定義ファイル検証・反映"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,TABLE_NAME,CLM"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0" >
		select '' as SEQ,TABLE_NAME,NAME_JA,SEQNO,CLM_NAME,CLM,'' as DTYPE,CLS_NAME,
				VIEW_LENGTH,USE_LENGTH,UK,LUK,IXA,IXB,IXC,IXD,IXE,IXF,IXG,IXH,IXI,IXJ,IXK,
				NOT_NULL,KBCLM,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,
				RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,KBSAKU,SUBSYS,BIKO,COMMENTS
		from GE82
	<og:where>
		<og:and value = "FGJ		= '1'"					/>
		<og:and value = "SYSTEM_ID	= '{@SYSTEM_ID}'"		/>
		<og:and value = "TBLSYU		= '{@TBLSYU}'"			/>
		<og:and value = "TABLE_NAME	like '{@TABLE_NAME}'"	/>
		<og:and value = "CLM		like '{@CLM}'"			/>
	</og:where>
		order by SYSTEM_ID,TBLSYU,
					 regexp_substr( TABLE_NAME, '[A-Z]+' ),
					 to_number(regexp_substr( TABLE_NAME, '[0-9]+' )),TABLE_NAME,SEQNO
	--				translate( TABLE_NAME,'ABCDEFGHIJKLMNOPQRSTUVWXYZ-_0123456789', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'),
	--				to_number(translate( TABLE_NAME,'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_', '0123456789')),SEQNO
</og:query>

<og:columnEditor columns="USE_LENGTH,UK,LUK,IXA,IXB,IXC,IXD,IXE,IXF,IXG,IXH,IXI,IXJ,IXK,NOT_NULL" dbType="S9" />
<og:columnEditor columns="RENDERER,EDITOR,DBTYPE,KBSAKU" addKeyLabel="true" />
<og:columnEditor columns="CLS_NAME,NOT_NULL"      renderer="LABEL" />

<!-- CLS_NAME,USE_LENGTH,DTYPE カラムが必須。異なる場合は、keys,vals で指定します。 -->
<og:tableFilter classId="DTYPE" />

<og:writeTable
	writerClass		= "Excel"
	headerSequence	= "D"
	fileURL			= "{@USER.ID}"
	skipRowCount	= "2"
	omitNames		= "SEQ,KBCLM"
	recalcSheetName	= "Sheet1"
	useRenderer		= "true"
	filename		= "fileout.xlsx"
	refFileURL		= "{@SYS.REAL_PATH}jsp/GF2060/"
	refFilename		= "dbfileOut.xlsx"
	refSheetName	= "Sheet1"
/>

<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/fileout.xlsx" filename="{@LBL.GE82}{@LBL.TBLSYU %C}.xlsx" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
