<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2090"
	title	= "整合性ﾁｪｯｸ(種別間)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID1,SYSTEM_ID2,TABLE_NAME1,TABLE_NAME2"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:value command="SET" key="c_keys" value="{@compareKeys}" action="APPEND" />
<og:value command="SET" key="d_keys" value="{@diffKeys}"    action="APPEND" />
<og:value command="SET" key="m_keys" value="{@modifyKeys}"  action="APPEND" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="0">
		select '1' as WRITABLE, {@TABLE_NAME}.*
		from {@TABLE_NAME}
	<og:where>
		<og:and value="FGJ			in  ('0','1')" />
		<og:and value="SYSTEM_ID	= '{@SYSTEM_ID1}'" />
		<og:and value="TBLSYU		= '{@TBLSYU1}'" />
		<og:and value="TABLE_NAME	like '{@TABLE_NAME1}'" />
		<og:and value="{@WHERE1}"	quotCheck="false" />
	</og:where>
		order by {@c_keys},SYSTEM_ID,TBLSYU
</og:query>

<!--
<og:tableFilter classId="UPPER" keys="KEY_CLMS" vals='"TABLE_NAME,CLM"' />
-->

<og:query command="{@command}" debug="{@debug}" maxRowCount="0" scope="request">
		select '0' as WRITABLE, {@TABLE_NAME}.*
		from {@TABLE_NAME}
	<og:where>
		<og:and value="FGJ			in  ('0','1')" />
		<og:and value="SYSTEM_ID	= '{@SYSTEM_ID2}'" />
		<og:and value="TBLSYU		= '{@TBLSYU2}'" />
		<og:and value="TABLE_NAME	like  '{@TABLE_NAME2}'" />
		<og:and value="{@WHERE2}"	quotCheck="false" />
	</og:where>
		order by {@c_keys},SYSTEM_ID,TBLSYU
</og:query>

<!--
<og:tableFilter classId="UPPER" keys="KEY_CLMS" vals='"TABLE_NAME,CLM"' scope="request" />
-->

<og:tableMerge
	command		= "{@command}"
	action		= "{@ACTION}"
	scope		= "session"
	masterScope	= "session"
	slaveScope	= "request"
	masterKeys	= "{@c_keys}"
	diffKeys	= "{@d_keys}"
	modifyClms	= "{@m_keys}"
	display		= "true"
/>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="COPY"    accesskey="C" noWritable="null" />
	<og:submit  action="MODIFY"  accesskey="M" noWritable="TBLSYU,TABLE_NAME"/>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
<!-- m_keys が指定・・つまり、直接変更箇所が変更されている場合は、入力欄を作成せずに更新する。 -->
<og:equals val1="{@m_keys}" val2="{@m_keys}">
　　　　　　　　　　
	<og:submit  action="MODIFY"  accesskey="X" columnWritable="null"  />
</og:equals>
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ,UNIQ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
