<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2180"
	title	= "テーブル"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheckはcolumnEditorでmust指定したカラムをチェックします。-->
<!-- カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck	command = "{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- データ重複チェック -->
<og:dataCheck command="{@command}" uniqCheckClms="SYSTEM_ID,TABLE_NAME,NOJUN" />

<!-- トランザクション 登録処理 -->
<og:transaction>
	<!-- 通常登録処理 -->
	<og:tableUpdate command="{@command}" sqlType="{@sqlType}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "{@sqlType}"
			table		= "GF84"
			where		= "UNIQ=[UNIQ]"
			omitNames	= "ARROW"
		/>
	</og:tableUpdate>
</og:transaction >

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
