<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6240"
	title	= "IOr連携"
	date	= "2021/11/30"
	author	= "LEE.M"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck command="{@command}" columns="*" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:equals val1="{@command}" val2="NEW" >
	<og:value key="SAVE_FILE" value="{@OUT_FILE}.txt" caseNN="{@OUT_FILE}" />
	<og:value key="LOAD_FILE" value="{@FILE1}" />
</og:equals>

<!-- データ取得を要求します。 -->
<og:iorQuery
	url				= "{@url_sel}"
	proxyHost		= "{@proxyHost}"
	proxyPort		= "{@proxyPort}"
	authURL			= "{@authURL}"
	authUserPass	= "{@userId}:{@password}"
	appliName		= "{@report_name}"
	callMethod		= "{@method}"
	saveFile		= "{@SAVE_FILE}"
	loadFile		= "{@LOAD_FILE}"
	stopZero		= "true"
	debug			= "{@debug}"
	>
	<og:iorQueryParam key="key_value" value="{'TANTO':'{@TANTO}','TANI':'{@TANI}'}" />
<!--<og:iorQueryParam key="select" value="{@SEL}" />-->
<!--<og:iorQueryParam key="where" value="{'TANTO':'{@TANTO}','TANI':'{@TANI}'}" />
	<og:iorQueryParam key="where_ge" value="{'DYNYSY':'{@DYNK_F}'}" />
	<og:iorQueryParam key="where_le" value="{'DYNYSY':'{@DYNK_T}'}" />
	<og:iorQueryParam key="group" value="{@GRP}" />
	<og:iorQueryParam key="order" value="{@ORD}" />-->
</og:iorQuery>

<!-- formタグでリクエストフィールドを囲います。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit action="COPY"   columnWritable="*" />
	<!--<og:submit action="MODIFY" columnWritable="HOKAN,DYNYSY,RIYU,TANTO" />-->
		<og:submit action="DELETE" columnWritable="" />
		<!-- (デバック用)実行結果をファイルに保存した場合は、ファイルにリンクを付けます。 -->
		<og:link lbl="{@SAVE_FILE}" href="{@SYS.JSP}/fileDownload" caseNN="{@OUT_FILE}" caseNull="{@LOAD_FILE}"
				keys="file,name,useLocal" vals="{@SYS.FILE_URL}/{@SAVE_FILE},{@SAVE_FILE},true" />
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
