<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9150"
	title	= "登録前確認（警告）メッセージ表示"
	date	= "2012/08/10"
	author	= "A.SANPEI"
	text	= ""
	version	= "001"
>
	YYYY/MM/DD	XXXXX
</og:comment>

<!-- command="ENTRY"時は、nullCheckはcolumnEditorでmust指定したカラムをチェックします。-->
<!-- カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck	command   = "{@command}" >
	<!-- エラー時の戻るボタン。書き換えないで下さい。-->
	<!-- history.back() で戻るボタンを表示します。	-->
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- 警告ﾁｪｯｸ -->
<!-- stopError属性       ：PLSQL/SQL処理エラーの時に処理を中止しない(false)設定をし、後続処理で分岐を行う。 -->
<!-- tableModelCommit属性：処理を行ってエラーがなかった場合は、テーブルモデルの確定処理（変更フラグ＝改廃のリセット処理）をしない(false)ように設定する。-->
<!-- オラクルに対するcommitはかかるので、警告ﾁｪｯｸSPに登録処理は記述しないこと！！必要な場合は注意すること！！ -->
<og:plsqlUpdate
	command			= "{@command}"
	names			= "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,KBSAKU,CDTAN,UNIQ"
	dbType			= "GF9150ARG"
	queryType		= "JDBCPLSQL"
	stopError		= "false" 
	tableModelCommit= "false">
		{ call GFP19150C.GF19150C( ?,?,?,?,? ) }
</og:plsqlUpdate>

<!-- 後続処理では{@DB.ERR_CODE}の値により、PLSQL/SQLの異常/正常終了によって分岐処理が可能です。 -->
<!-- ERRCODE＝1(警告)の時、メッセージ表示 -->
<og:equals val1="{@DB.ERR_CODE}" val2="1" >
	<form method="POST" action="forward.jsp" target="RESULT">
		<!-- 登録/戻るボタンを作成します。 -->
		<og:writeCheck>
			<og:submit action="ENTRY" />
			<jsp:directive.include file="/jsp/common/history_back.jsp" />
			<og:message lbl="GFE0007" />
		</og:writeCheck>

		<!-- 警告ﾒｯｾｰｼﾞ表示 -->
		<og:errorMessage command="{@command}" viewType="BODY" clear="{@clear}" />
		<br/>
		<!-- 選択行のみ一覧表示 -->
<!--		<og:view
			viewFormType	= "HTMLTable"
			command			= "{@command}"
			noDisplay		= "UNIQ"
			noWritable		= "{@noWritable}"
			columnWritable	= "{@columnWritable}"
			skipNoEdit		= "true"
			noMessage		= "true"
		/>
-->
		<og:view
			viewFormType	= "HTMLCustomTable" 
			command			= "{@command}" 
			noDisplay		= "UNIQ"
			columnBulkSet	= "CLM,LANG,KBSAKU"
			noWritable		= "{@noWritable}"
			columnWritable	= "{@columnWritable}"
			skipNoEdit		= "true"
			noMessage		= "true"
		>
			<og:thead rowspan="1">
				<tr>
					<td>[SYSTEM_ID]</td>										<!-- ｼｽﾃﾑID -->
					<td>[LANG]</td>												<!-- 言語 -->
					<td>[CLM]</td>												<!-- 項目 -->
					<td>[NAME_JA]</td>											<!-- 名称(漢字) -->
					<td>[LABEL_NAME]</td>										<!-- 表示名称 -->
					<td>[KBSAKU]</td>											<!-- 作成区分 -->
					<td>[CDTAN]</td>											<!-- 担当者 -->
				</tr>
			</og:thead>
			<og:tbody rowspan="1">
				<tr>
					<td>[SYSTEM_ID]</td>										<!-- ｼｽﾃﾑID -->
					<td>[LANG]</td>												<!-- 言語 -->
					<td>[CLM]</td>												<!-- 項目 -->
					<td>[NAME_JA]</td>											<!-- 名称(漢字) -->
					<td>[LABEL_NAME]</td>										<!-- 表示名称 -->
					<td>[KBSAKU]</td>											<!-- 作成区分 -->
					<td>[CDTAN]</td>											<!-- 担当者 -->
				</tr>
			</og:tbody>
		</og:view>
	</form>
</og:equals>

<!-- ERRCODE≠1(警告)の時、登録処理へ -->
<og:equals val1="{@DB.ERR_CODE}" val2="1" notEquals="true" >
	<og:forward page="entry.jsp" keys="command" vals="ENTRY" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
